/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import software.amazon.encryption.s3.S3EncryptionClientSecurityException;
import software.amazon.encryption.s3.internal.CipherInputStream;

public class AuthenticatedCipherInputStream
extends CipherInputStream {
    private final boolean multipart;
    private final boolean lastMultipart;

    public AuthenticatedCipherInputStream(InputStream inputStream, Cipher cipher) {
        this(inputStream, cipher, false, false);
    }

    public AuthenticatedCipherInputStream(InputStream inputStream, Cipher cipher, boolean multipart, boolean lastMultipart) {
        super(inputStream, cipher);
        this.multipart = multipart;
        this.lastMultipart = lastMultipart;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.maxPosition = 0;
        this.currentPosition = 0;
        this.abortIfNeeded();
    }

    @Override
    protected int endOfFileReached() {
        this.eofReached = true;
        if (!this.multipart || this.lastMultipart) {
            try {
                this.outputBuffer = this.cipher.doFinal();
                if (this.outputBuffer == null) {
                    return -1;
                }
                this.currentPosition = 0;
                this.maxPosition = this.outputBuffer.length;
                return this.maxPosition;
            }
            catch (GeneralSecurityException exception) {
                throw new S3EncryptionClientSecurityException(exception.getMessage(), exception);
            }
        }
        return -1;
    }
}

