/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.services.dynamodb.model.TimeToLiveSpecification;
import software.amazon.dynamodb.services.local.google.Lists;
import software.amazon.dynamodb.services.local.google.Preconditions;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;

public class TableInfo {
    private final String tableName;
    private final AttributeDefinition hashKey;
    private final AttributeDefinition rangeKey;
    private final List<String> baseTableKeyNames;
    private final Map<String, List<String>> indexKeyNames;
    private final List<AttributeDefinition> allAttributes;
    private final Map<String, ScalarAttributeType> attributeNameToScalarAttributeType;
    private final Map<String, AttributeDefinition> lsiKeys;
    private final Map<String, AttributeDefinition> gsiHashKeys;
    private final Map<String, AttributeDefinition> gsiRangeKeys;
    private final ProvisionedThroughput throughput;
    private final OnDemandThroughput onDemandThroughput;
    private final BillingMode billingMode;
    private final Map<String, LocalSecondaryIndex> lsiMap;
    private final Map<String, GlobalSecondaryIndexDescription> gsiDescMap;
    private final StreamSpecification streamSpecification;
    private final TimeToLiveSpecification timeToLiveSpecification;
    private final String latestStreamId;
    private final Boolean deleteProtectionEnabled;
    private long lastUpdateToPayPerRequestDateTime;
    private long creationDateTime;
    private Instant lastDecreaseDateTime;
    private Instant lastIncreaseDateTime;
    private long numberOfDecreasesToday;

    public TableInfo(String tableName, AttributeDefinition hashKey, AttributeDefinition rangeKey, List<AttributeDefinition> allAttributes, List<LocalSecondaryIndex> lsiIndexes, List<GlobalSecondaryIndexDescription> gsiIndexDescs, ProvisionedThroughput throughput, OnDemandThroughput onDemandThroughput, BillingMode billingMode, StreamSpecification streamSpecification, String latestStreamId, TimeToLiveSpecification timeToLiveSpecification, Boolean deleteProtectionEnabled) {
        Preconditions.checkNotNull(allAttributes, "allAttributes may not be null");
        this.tableName = tableName;
        this.hashKey = hashKey;
        this.rangeKey = rangeKey;
        this.allAttributes = allAttributes;
        this.attributeNameToScalarAttributeType = this.createAttributeNameToScalarAttributeTypeMap(allAttributes);
        this.lsiMap = new HashMap<String, LocalSecondaryIndex>();
        this.lsiKeys = new HashMap<String, AttributeDefinition>();
        if (lsiIndexes != null) {
            for (LocalSecondaryIndex curIndex : lsiIndexes) {
                String curIndexName = curIndex.indexName();
                KeySchemaElement curIndexRangeElement = (KeySchemaElement)curIndex.keySchema().get(1);
                this.lsiKeys.put(curIndexName, LocalDBUtils.findAttributeDefinition(curIndexRangeElement, allAttributes));
                this.lsiMap.put(curIndexName, curIndex);
            }
        }
        this.throughput = throughput;
        this.onDemandThroughput = onDemandThroughput;
        this.billingMode = billingMode;
        this.gsiDescMap = new HashMap<String, GlobalSecondaryIndexDescription>();
        this.gsiHashKeys = new HashMap<String, AttributeDefinition>();
        this.gsiRangeKeys = new HashMap<String, AttributeDefinition>();
        this.setGSIDescs(gsiIndexDescs);
        this.streamSpecification = streamSpecification;
        this.latestStreamId = latestStreamId;
        this.timeToLiveSpecification = timeToLiveSpecification;
        this.deleteProtectionEnabled = deleteProtectionEnabled;
        this.baseTableKeyNames = Collections.unmodifiableList(rangeKey == null ? Collections.singletonList(hashKey.attributeName()) : Lists.newArrayList(hashKey.attributeName(), rangeKey.attributeName()));
        this.indexKeyNames = new HashMap<String, List<String>>();
        if (lsiIndexes != null) {
            for (LocalSecondaryIndex lsi : lsiIndexes) {
                this.indexKeyNames.put(lsi.indexName(), this.getIndexKeyNames(lsi.keySchema()));
            }
        }
        if (gsiIndexDescs != null) {
            for (GlobalSecondaryIndexDescription gsi : gsiIndexDescs) {
                this.indexKeyNames.put(gsi.indexName(), this.getIndexKeyNames(gsi.keySchema()));
            }
        }
    }

    public TableInfo(String tableName, AttributeDefinition hashKey, AttributeDefinition rangeKey, List<AttributeDefinition> allAttributes, List<LocalSecondaryIndex> lsiIndexes, List<GlobalSecondaryIndexDescription> gsiIndexesDesc, ProvisionedThroughput throughput, OnDemandThroughput onDemandThroughput, BillingMode billingMode, StreamSpecification streamSpecification, Boolean deleteProtectionEnabled) {
        this(tableName, hashKey, rangeKey, allAttributes, lsiIndexes, gsiIndexesDesc, throughput, onDemandThroughput, billingMode, streamSpecification, null, null, deleteProtectionEnabled);
    }

    public TableInfo(String tableName, AttributeDefinition hashKey, AttributeDefinition rangeKey, List<AttributeDefinition> allAttributes, List<LocalSecondaryIndex> lsiIndexes, List<GlobalSecondaryIndexDescription> gsiIndexesDesc, ProvisionedThroughput throughput, OnDemandThroughput onDemandThroughput, BillingMode billingMode, String latestStreamId, StreamSpecification spec, TimeToLiveSpecification timeToLiveSpecification, long creationDateTime, Boolean deleteProtectionEnabled) {
        this(tableName, hashKey, rangeKey, allAttributes, lsiIndexes, gsiIndexesDesc, throughput, onDemandThroughput, billingMode, spec, latestStreamId, timeToLiveSpecification, deleteProtectionEnabled);
        this.creationDateTime = creationDateTime;
    }

    public TableInfo(String tableName, AttributeDefinition hashKey, AttributeDefinition rangeKey, List<AttributeDefinition> allAttributes, List<LocalSecondaryIndex> lsiIndexes, List<GlobalSecondaryIndexDescription> gsiIndexesDesc, ProvisionedThroughput throughput, OnDemandThroughput onDemandThroughput, BillingMode billingMode, String latestStreamId, StreamSpecification spec, TimeToLiveSpecification timeToLiveSpecification, long creationDateTime, Instant lastDecreaseDateTime, Instant lastIncreaseDateTime, long numDecreasesToday, Boolean deleteProtectionEnabled) {
        this(tableName, hashKey, rangeKey, allAttributes, lsiIndexes, gsiIndexesDesc, throughput, onDemandThroughput, billingMode, latestStreamId, spec, timeToLiveSpecification, creationDateTime, deleteProtectionEnabled);
        this.lastDecreaseDateTime = lastDecreaseDateTime;
        this.lastIncreaseDateTime = lastIncreaseDateTime;
        this.numberOfDecreasesToday = numDecreasesToday;
    }

    public TableInfo(String tableName, AttributeDefinition hashKey, AttributeDefinition rangeKey, List<AttributeDefinition> allAttributes, List<LocalSecondaryIndex> lsiIndexes, List<GlobalSecondaryIndexDescription> gsiIndexesDesc, ProvisionedThroughput throughput, OnDemandThroughput onDemandThroughput, BillingMode billingMode, StreamSpecification streamSpecification, long creationDateTime, Boolean deleteProtectionEnabled) {
        this(tableName, hashKey, rangeKey, allAttributes, lsiIndexes, gsiIndexesDesc, throughput, onDemandThroughput, billingMode, streamSpecification, deleteProtectionEnabled);
        this.creationDateTime = creationDateTime;
        this.lastDecreaseDateTime = null;
        this.lastIncreaseDateTime = null;
        this.numberOfDecreasesToday = 0L;
    }

    public List<String> getIndexKeyNames(String index) {
        return this.indexKeyNames.get(index);
    }

    private List<String> getIndexKeyNames(List<KeySchemaElement> keySchemata) {
        ArrayList<String> result = new ArrayList<String>(keySchemata.size());
        for (KeySchemaElement key : keySchemata) {
            result.add(key.attributeName());
        }
        return result;
    }

    private Map<String, ScalarAttributeType> createAttributeNameToScalarAttributeTypeMap(List<AttributeDefinition> definitions) {
        HashMap<String, ScalarAttributeType> result = new HashMap<String, ScalarAttributeType>();
        Preconditions.checkNotNull(definitions, "attribute definition list was null");
        for (AttributeDefinition attributeDefinition : definitions) {
            if (result.put(attributeDefinition.attributeName(), ScalarAttributeType.fromValue((String)attributeDefinition.attributeType().toString())) == null) continue;
            throw new IllegalArgumentException("Duplicate attribute name in attribute definition list: " + attributeDefinition.attributeName());
        }
        return Collections.unmodifiableMap(result);
    }

    private void setGSIDescs(List<GlobalSecondaryIndexDescription> gsiIndexesDesc) {
        if (gsiIndexesDesc != null) {
            for (GlobalSecondaryIndexDescription globalSecondaryIndexDescription : gsiIndexesDesc) {
                String curIndexDescName = globalSecondaryIndexDescription.indexName();
                this.gsiDescMap.put(curIndexDescName, globalSecondaryIndexDescription);
            }
        }
        for (Map.Entry entry : this.gsiDescMap.entrySet()) {
            GlobalSecondaryIndexDescription curIndex = (GlobalSecondaryIndexDescription)entry.getValue();
            String curIndexName = curIndex.indexName();
            KeySchemaElement curIndexHashElement = (KeySchemaElement)curIndex.keySchema().get(0);
            this.gsiHashKeys.put(curIndexName, LocalDBUtils.findAttributeDefinition(curIndexHashElement, this.allAttributes));
            if (curIndex.keySchema().size() != 2) continue;
            KeySchemaElement curIndexRangeElement = (KeySchemaElement)curIndex.keySchema().get(1);
            this.gsiRangeKeys.put(curIndexName, LocalDBUtils.findAttributeDefinition(curIndexRangeElement, this.allAttributes));
        }
    }

    public ScalarAttributeType indexedAttributeType(String attributeName) {
        return this.attributeNameToScalarAttributeType.get(attributeName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public ProvisionedThroughput getThroughput() {
        return this.throughput;
    }

    public BillingMode getBillingMode() {
        return this.billingMode;
    }

    public long getLastUpdateToPayPerRequestDateTime() {
        return this.lastUpdateToPayPerRequestDateTime;
    }

    public void setLastUpdateToPayPerRequestDateTime(long lastUpdateToPayPerRequestDateTime) {
        this.lastUpdateToPayPerRequestDateTime = lastUpdateToPayPerRequestDateTime;
    }

    public boolean hasRangeKey() {
        return this.rangeKey != null;
    }

    public AttributeDefinition getHashKey() {
        return this.hashKey;
    }

    public AttributeDefinition getRangeKey() {
        return this.rangeKey;
    }

    public boolean hasIndex(String indexName) {
        return this.lsiKeys.containsKey(indexName) || this.gsiHashKeys.containsKey(indexName);
    }

    public long getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(long curTime) {
        this.creationDateTime = curTime;
    }

    public List<String> getLSINames() {
        return new ArrayList<String>(this.lsiMap.keySet());
    }

    public AttributeDefinition getLSIRangeKey(String indexName) {
        return this.lsiKeys.get(indexName);
    }

    public AttributeDefinition getGSIHashKey(String indexName) {
        return this.gsiHashKeys.get(indexName);
    }

    public AttributeDefinition getGSIRangeKey(String indexName) {
        return this.gsiRangeKeys.get(indexName);
    }

    public List<String> getGSINames() {
        return new ArrayList<String>(this.gsiDescMap.keySet());
    }

    public List<AttributeDefinition> getAttributeDefinitions() {
        return this.allAttributes;
    }

    public List<KeySchemaElement> getKeySchema() {
        ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
        keySchema.add((KeySchemaElement)KeySchemaElement.builder().attributeName(this.hashKey.attributeName()).keyType(KeyType.HASH).build());
        if (this.rangeKey != null) {
            keySchema.add((KeySchemaElement)KeySchemaElement.builder().attributeName(this.rangeKey.attributeName()).keyType(KeyType.RANGE).build());
        }
        return keySchema;
    }

    public ProvisionedThroughputDescription getThroughputDescription() {
        return (ProvisionedThroughputDescription)ProvisionedThroughputDescription.builder().readCapacityUnits(Long.valueOf(this.throughput != null && this.throughput.readCapacityUnits() != null ? this.throughput.readCapacityUnits() : 0L)).writeCapacityUnits(Long.valueOf(this.throughput != null && this.throughput.writeCapacityUnits() != null ? this.throughput.writeCapacityUnits() : 0L)).lastDecreaseDateTime(this.lastDecreaseDateTime).lastIncreaseDateTime(this.lastIncreaseDateTime).numberOfDecreasesToday(Long.valueOf(this.numberOfDecreasesToday)).build();
    }

    public OnDemandThroughput getOndemandThroughput() {
        if (this.onDemandThroughput != null) {
            return (OnDemandThroughput)OnDemandThroughput.builder().maxReadRequestUnits(this.onDemandThroughput.maxReadRequestUnits()).maxWriteRequestUnits(this.onDemandThroughput.maxWriteRequestUnits()).build();
        }
        return (OnDemandThroughput)OnDemandThroughput.builder().maxReadRequestUnits(Long.valueOf(0L)).maxWriteRequestUnits(Long.valueOf(0L)).build();
    }

    public List<LocalSecondaryIndexDescription> getLSIDescriptions() {
        if (this.lsiMap.isEmpty()) {
            return null;
        }
        ArrayList<LocalSecondaryIndexDescription> indexDescList = new ArrayList<LocalSecondaryIndexDescription>();
        for (Map.Entry<String, LocalSecondaryIndex> entry : this.lsiMap.entrySet()) {
            LocalSecondaryIndex index = entry.getValue();
            indexDescList.add((LocalSecondaryIndexDescription)LocalSecondaryIndexDescription.builder().indexName(index.indexName()).keySchema((Collection)index.keySchema()).projection(index.projection()).indexSizeBytes(Long.valueOf(0L)).itemCount(Long.valueOf(0L)).indexArn(LocalDBUtils.generateArn(this.tableName, index.indexName(), null)).build());
        }
        return indexDescList;
    }

    public List<GlobalSecondaryIndexDescription> getGSIDescriptions() {
        if (this.gsiDescMap.isEmpty()) {
            return null;
        }
        ArrayList<GlobalSecondaryIndexDescription> gsiDescriptions = new ArrayList<GlobalSecondaryIndexDescription>();
        for (GlobalSecondaryIndexDescription gsiDesc : this.gsiDescMap.values()) {
            gsiDescriptions.add((GlobalSecondaryIndexDescription)GlobalSecondaryIndexDescription.builder().indexName(gsiDesc.indexName()).keySchema((Collection)gsiDesc.keySchema()).projection(gsiDesc.projection()).provisionedThroughput(gsiDesc.provisionedThroughput()).onDemandThroughput(gsiDesc.onDemandThroughput()).backfilling(gsiDesc.backfilling()).indexStatus(gsiDesc.indexStatus()).indexSizeBytes(gsiDesc.indexSizeBytes()).itemCount(gsiDesc.itemCount()).indexArn(LocalDBUtils.generateArn(this.tableName, gsiDesc.indexName(), null)).build());
        }
        return gsiDescriptions;
    }

    public Projection getProjection(String indexName) {
        if (this.lsiMap.containsKey(indexName)) {
            return this.lsiMap.get(indexName).projection();
        }
        return this.gsiDescMap.get(indexName).projection();
    }

    public List<String> getBaseTableKeyNames() {
        return this.baseTableKeyNames;
    }

    public List<LocalSecondaryIndex> getLSIIndexes() {
        if (this.lsiMap.isEmpty()) {
            return null;
        }
        return new ArrayList<LocalSecondaryIndex>(this.lsiMap.values());
    }

    public boolean isLSIIndex(String indexName) {
        return this.lsiMap.containsKey(indexName);
    }

    public boolean isGSIIndex(String indexName) {
        return this.gsiDescMap.containsKey(indexName);
    }

    public GlobalSecondaryIndexDescription getGSIDescWithName(String gsiName) {
        return this.gsiDescMap.get(gsiName);
    }

    public AttributeDefinition getLSIRangeKeyWithAttributeName(String attrName) {
        for (Map.Entry<String, AttributeDefinition> entry : this.lsiKeys.entrySet()) {
            AttributeDefinition curDef = entry.getValue();
            if (!curDef.attributeName().equals(attrName)) continue;
            return curDef;
        }
        return null;
    }

    public void updateGSIDesc(String gsiName, GlobalSecondaryIndexDescription updatedGsi) {
        this.gsiDescMap.put(gsiName, updatedGsi);
    }

    public boolean hasGSIs() {
        return this.getGSIDescriptions() != null && !this.getGSIDescriptions().isEmpty();
    }

    public int getNumberOfLSIProjectedAttributes() {
        int numberOfLSIProjectedAttrs = 0;
        if (this.getLSIIndexes() != null) {
            for (LocalSecondaryIndex lsi : this.getLSIIndexes()) {
                if (!ProjectionType.INCLUDE.equals((Object)lsi.projection().projectionType())) continue;
                numberOfLSIProjectedAttrs += lsi.projection().nonKeyAttributes().size();
            }
        }
        return numberOfLSIProjectedAttrs;
    }

    public StreamSpecification getStreamSpecification() {
        return this.streamSpecification;
    }

    public TimeToLiveSpecification getTimeToLiveSpecification() {
        return this.timeToLiveSpecification;
    }

    public String getLatestStreamId() {
        return this.latestStreamId;
    }

    public Boolean getDeleteProtectionEnabled() {
        return this.deleteProtectionEnabled;
    }
}

