/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.metadata;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperties;
import software.amazon.documentdb.jdbc.metadata.DocumentDbMetadataScanner;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchema;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaTable;
import software.amazon.documentdb.jdbc.metadata.DocumentDbTableSchemaGenerator;
import software.amazon.documentdb.jdbc.persist.DocumentDbSchemaReader;
import software.amazon.documentdb.jdbc.persist.DocumentDbSchemaSecurityException;
import software.amazon.documentdb.jdbc.persist.DocumentDbSchemaWriter;

public class DocumentDbMetadataService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentDbMetadataService.class);
    private static final Map<String, DocumentDbSchemaTable> TABLE_MAP = new ConcurrentHashMap<String, DocumentDbSchemaTable>();

    public static DocumentDbSchema get(DocumentDbConnectionProperties properties, String schemaName, MongoClient client) throws SQLException {
        return DocumentDbMetadataService.get(properties, schemaName, 0, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static DocumentDbSchema get(DocumentDbConnectionProperties properties, String schemaName, int schemaVersion, MongoClient client) throws SQLException {
        Instant beginRetrieval = Instant.now();
        LinkedHashMap<String, DocumentDbSchemaTable> tableMap = new LinkedHashMap<String, DocumentDbSchemaTable>();
        int lookupVersion = Math.max(schemaVersion, 0);
        DocumentDbSchemaReader schemaReader = new DocumentDbSchemaReader(properties, client);
        try {
            DocumentDbSchema schema = schemaReader.read(schemaName, lookupVersion);
            switch (schemaVersion) {
                case 0: {
                    if (schema != null) {
                        LOGGER.info(String.format("Successfully retrieved metadata schema %s in %d ms.", schemaName, Instant.now().toEpochMilli() - beginRetrieval.toEpochMilli()));
                        DocumentDbSchema documentDbSchema = schema;
                        return documentDbSchema;
                    }
                    LOGGER.info(String.format("Existing metadata not found for schema %s, will generate new metadata instead for database %s.", schemaName, properties.getDatabase()));
                    DocumentDbSchema documentDbSchema = DocumentDbMetadataService.getNewDatabaseMetadata(properties, schemaName, 1, tableMap, client);
                    return documentDbSchema;
                }
                case -1: {
                    int newVersionNumber = schema != null ? schema.getSchemaVersion() + 1 : 1;
                    DocumentDbSchema documentDbSchema = DocumentDbMetadataService.getNewDatabaseMetadata(properties, schemaName, newVersionNumber, tableMap, client);
                    return documentDbSchema;
                }
            }
            if (schema != null) {
                LOGGER.info(String.format("Retrieved schema %s version %d in %d ms.", schema.getSchemaName(), schema.getSchemaVersion(), Instant.now().toEpochMilli() - beginRetrieval.toEpochMilli()));
            } else {
                LOGGER.info("Could not find schema {} in database {}.", (Object)schemaName, (Object)properties.getDatabase());
            }
            DocumentDbSchema documentDbSchema = schema;
            return documentDbSchema;
        }
        finally {
            DocumentDbMetadataService.closeSchemaReader(schemaReader);
        }
    }

    private static LinkedHashMap<String, DocumentDbSchemaTable> buildTableMapById(Map<String, DocumentDbSchemaTable> tableMap) {
        return tableMap.values().stream().collect(Collectors.toMap(DocumentDbSchemaTable::getId, t -> t, (o, d) -> o, LinkedHashMap::new));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static DocumentDbSchemaTable getTable(@NonNull DocumentDbConnectionProperties properties, @NonNull String schemaName, int schemaVersion, @NonNull String tableId, MongoClient client) {
        DocumentDbSchemaTable documentDbSchemaTable;
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        if (tableId == null) {
            throw new NullPointerException("tableId is marked non-null but is null");
        }
        if (TABLE_MAP.containsKey(tableId)) {
            return TABLE_MAP.get(tableId);
        }
        DocumentDbSchemaReader schemaReader = new DocumentDbSchemaReader(properties, client);
        try {
            DocumentDbSchemaTable schemaTable = schemaReader.readTable(schemaName, schemaVersion, tableId);
            if (client != null) {
                DocumentDbMetadataService.setEstimatedRecordCount(properties, client, schemaTable);
            }
            documentDbSchemaTable = schemaTable;
        }
        catch (Throwable throwable) {
            DocumentDbMetadataService.closeSchemaReader(schemaReader);
            throw throwable;
        }
        DocumentDbMetadataService.closeSchemaReader(schemaReader);
        return documentDbSchemaTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, DocumentDbSchemaTable> getTables(@NonNull DocumentDbConnectionProperties properties, @NonNull String schemaName, int schemaVersion, @NonNull Set<String> remainingTableIds, MongoClient client) {
        Map map;
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        if (remainingTableIds == null) {
            throw new NullPointerException("remainingTableIds is marked non-null but is null");
        }
        LinkedHashMap map2 = remainingTableIds.stream().filter(TABLE_MAP::containsKey).collect(Collectors.toMap(tableId -> tableId, TABLE_MAP::get, (o, d) -> d, LinkedHashMap::new));
        if (map2.size() == remainingTableIds.size()) {
            return map2;
        }
        DocumentDbSchemaReader schemaReader = new DocumentDbSchemaReader(properties, client);
        try {
            Map schemaTables = schemaReader.readTables(schemaName, schemaVersion, remainingTableIds).stream().collect(Collectors.toMap(DocumentDbSchemaTable::getId, table -> table, (o, d) -> d, LinkedHashMap::new));
            if (client != null) {
                for (DocumentDbSchemaTable schemaTable : schemaTables.values()) {
                    DocumentDbMetadataService.setEstimatedRecordCount(properties, client, schemaTable);
                }
            }
            map = schemaTables;
        }
        catch (Throwable throwable) {
            DocumentDbMetadataService.closeSchemaReader(schemaReader);
            throw throwable;
        }
        DocumentDbMetadataService.closeSchemaReader(schemaReader);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(DocumentDbConnectionProperties properties, String schemaName, MongoClient client) throws SQLException {
        DocumentDbSchemaWriter schemaWriter = new DocumentDbSchemaWriter(properties, client);
        try {
            schemaWriter.remove(schemaName);
        }
        finally {
            DocumentDbMetadataService.closeSchemaWriter(schemaWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(DocumentDbConnectionProperties properties, String schemaName, int schemaVersion, MongoClient client) throws SQLException {
        DocumentDbSchemaWriter schemaWriter = new DocumentDbSchemaWriter(properties, client);
        try {
            schemaWriter.remove(schemaName, schemaVersion);
        }
        finally {
            DocumentDbMetadataService.closeSchemaWriter(schemaWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DocumentDbSchema> getSchemaList(DocumentDbConnectionProperties properties, MongoClient client) throws SQLException {
        DocumentDbSchemaReader schemaReader = new DocumentDbSchemaReader(properties, client);
        try {
            List<DocumentDbSchema> list = schemaReader.list();
            return list;
        }
        finally {
            DocumentDbMetadataService.closeSchemaReader(schemaReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(DocumentDbConnectionProperties properties, String schemaName, Collection<DocumentDbSchemaTable> schemaTables, MongoClient client) throws SQLException, DocumentDbSchemaSecurityException {
        DocumentDbSchema schema = DocumentDbMetadataService.get(properties, schemaName, -2, client);
        if (schema == null) {
            boolean schemaVersion = false;
            schema = new DocumentDbSchema(schemaName, properties.getDatabase(), 0, new LinkedHashMap<String, DocumentDbSchemaTable>());
            LOGGER.info("A new schema {} will be created.", (Object)schemaName);
        }
        DocumentDbSchemaWriter schemaWriter = new DocumentDbSchemaWriter(properties, client);
        try {
            schemaWriter.update(schema, schemaTables);
        }
        finally {
            DocumentDbMetadataService.closeSchemaWriter(schemaWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentDbSchema getNewDatabaseMetadata(DocumentDbConnectionProperties properties, String schemaName, int schemaVersion, Map<String, DocumentDbSchemaTable> tableMap, MongoClient client) throws SQLException {
        LOGGER.debug("Beginning generation of new metadata.");
        Instant beginGeneration = Instant.now();
        DocumentDbSchema schema = DocumentDbMetadataService.getCollectionMetadataDirect(schemaName, schemaVersion, properties.getDatabase(), properties, tableMap, client);
        DocumentDbSchemaWriter schemaWriter = new DocumentDbSchemaWriter(properties, client);
        try {
            schemaWriter.write(schema, tableMap.values());
        }
        catch (DocumentDbSchemaSecurityException e) {
            TABLE_MAP.putAll(DocumentDbMetadataService.buildTableMapById(tableMap));
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            DocumentDbMetadataService.closeSchemaWriter(schemaWriter);
        }
        LOGGER.info(String.format("Successfully generated metadata in %d ms.", Instant.now().toEpochMilli() - beginGeneration.toEpochMilli()));
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentDbSchema getCollectionMetadataDirect(String schemaName, int schemaVersion, String databaseName, DocumentDbConnectionProperties properties, Map<String, DocumentDbSchemaTable> tableMap, MongoClient client) throws SQLException {
        MongoClient mongoClient = client != null ? client : properties.createMongoClient();
        try {
            MongoDatabase database = mongoClient.getDatabase(databaseName);
            for (String collectionName : DocumentDbMetadataService.getFilteredCollectionNames(database)) {
                MongoCollection collection = database.getCollection(collectionName, BsonDocument.class);
                Iterator<BsonDocument> cursor = DocumentDbMetadataScanner.getIterator(properties, (MongoCollection<BsonDocument>)collection);
                Map<String, DocumentDbSchemaTable> tableSchemaMap = DocumentDbTableSchemaGenerator.generate(collectionName, cursor);
                tableMap.putAll(tableSchemaMap);
            }
            Set<String> tableReferences = tableMap.values().stream().map(DocumentDbSchemaTable::getId).collect(Collectors.toSet());
            DocumentDbSchema documentDbSchema = new DocumentDbSchema(schemaName, schemaVersion, databaseName, new Date(Instant.now().toEpochMilli()), tableReferences);
            return documentDbSchema;
        }
        finally {
            if (client == null) {
                mongoClient.close();
            }
        }
    }

    private static List<String> getFilteredCollectionNames(MongoDatabase database) {
        MongoIterable collectionNames = database.listCollectionNames();
        return StreamSupport.stream(collectionNames.spliterator(), false).filter(c -> !c.equals("_sqlSchemas") && !c.equals("_sqlTableSchemas")).collect(Collectors.toList());
    }

    private static void closeSchemaReader(DocumentDbSchemaReader schemaReader) throws SQLException {
        try {
            schemaReader.close();
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    private static void closeSchemaWriter(DocumentDbSchemaWriter schemaWriter) throws SQLException {
        try {
            schemaWriter.close();
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    private static void setEstimatedRecordCount(DocumentDbConnectionProperties properties, MongoClient client, DocumentDbSchemaTable schemaTable) {
        EstimatedDocumentCountOptions options = new EstimatedDocumentCountOptions().maxTime(1L, TimeUnit.SECONDS);
        MongoCollection collection = client.getDatabase(properties.getDatabase()).getCollection(schemaTable.getCollectionName());
        long estimatedRecordCount = collection.estimatedDocumentCount(options);
        schemaTable.setEstimatedRecordCount(estimatedRecordCount);
    }
}

