/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc;

import com.google.common.collect.ImmutableList;
import software.amazon.documentdb.jdbc.common.utilities.JdbcColumnMetaData;
import software.amazon.documentdb.jdbc.common.utilities.JdbcType;

class DocumentDbDatabaseMetaDataResultSets {
    private static ImmutableList<JdbcColumnMetaData> proceduresColumnMetaData;
    private static ImmutableList<JdbcColumnMetaData> tablesColumnMetaData;
    private static ImmutableList<JdbcColumnMetaData> schemasColumnMetaData;
    private static ImmutableList<JdbcColumnMetaData> catalogsColumnMetaData;
    private static ImmutableList<JdbcColumnMetaData> tableTypesColumnMetaData;
    private static ImmutableList<JdbcColumnMetaData> columnsColumnMetaData;
    private static ImmutableList<JdbcColumnMetaData> columnPrivilegesColumnMetaData;
    private static ImmutableList<JdbcColumnMetaData> attributesColumnMetaData;
    private static ImmutableList<JdbcColumnMetaData> primaryKeysColumnMetaData;
    private static ImmutableList<JdbcColumnMetaData> importedKeysColumnMetaData;
    private static ImmutableList<JdbcColumnMetaData> typeInfoColumnMetaData;

    DocumentDbDatabaseMetaDataResultSets() {
    }

    static ImmutableList<JdbcColumnMetaData> buildProceduresColumnMetaData(String schemaName) {
        if (proceduresColumnMetaData == null) {
            int ordinal = 0;
            proceduresColumnMetaData = ImmutableList.builder().add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "PROCEDURE_CAT", "PROCEDURE_CAT", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "PROCEDURE_SCHEM", "PROCEDURE_SCHEM", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "PROCEDURE_NAME", "PROCEDURE_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 1, false, 64, "FUTURE_USE1", "FUTURE_USE1", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 1, false, 64, "FUTURE_USE2", "FUTURE_USE2", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 1, false, 64, "FUTURE_USE3", "FUTURE_USE3", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "REMARKS", "REMARKS", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 1, false, 64, "PROCEDURE_TYPE", "PROCEDURE_TYPE", schemaName, 0, 0, 5, JdbcType.SMALLINT.name(), Short.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal, true, 1, false, 64, "SPECIFIC_NAME", "SPECIFIC_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).build();
        }
        return proceduresColumnMetaData;
    }

    static ImmutableList<JdbcColumnMetaData> buildTablesColumnMetaData(String schemaName) {
        if (tablesColumnMetaData == null) {
            int ordinal = 0;
            tablesColumnMetaData = ImmutableList.builder().add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "TABLE_CAT", "TABLE_CAT", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "TABLE_SCHEM", "TABLE_SCHEM", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 0, false, 64, "TABLE_NAME", "TABLE_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, false, 64, "TABLE_TYPE", "TABLE_TYPE", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 0, false, 64, "REMARKS", "REMARKS", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "TYPE_CAT", "TYPE_CAT", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "TYPE_SCHEM", "TYPE_SCHEM", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "TYPE_NAME", "TYPE_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "SELF_REFERENCING_COL_NAME", "SELF_REFERENCING_COL_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal, false, 1, false, 64, "REF_GENERATION", "REF_GENERATION", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).build();
        }
        return tablesColumnMetaData;
    }

    static ImmutableList<JdbcColumnMetaData> buildSchemasColumnMetaData(String schemaName) {
        if (schemasColumnMetaData == null) {
            int ordinal = 0;
            schemasColumnMetaData = ImmutableList.builder().add((Object)new JdbcColumnMetaData(ordinal++, true, 0, false, 64, "TABLE_SCHEM", "TABLE_SCHEM", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal, true, 1, false, 64, "TABLE_CATALOG", "TABLE_CATALOG", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).build();
        }
        return schemasColumnMetaData;
    }

    static ImmutableList<JdbcColumnMetaData> buildCatalogsColumnMetaData(String schemaName) {
        if (catalogsColumnMetaData == null) {
            boolean ordinal = false;
            catalogsColumnMetaData = ImmutableList.builder().add((Object)new JdbcColumnMetaData(0, true, 0, false, 64, "TABLE_CAT", "TABLE_CAT", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).build();
        }
        return catalogsColumnMetaData;
    }

    static ImmutableList<JdbcColumnMetaData> buildTableTypesColumnMetaData(String schemaName) {
        if (tableTypesColumnMetaData == null) {
            boolean ordinal = false;
            tableTypesColumnMetaData = ImmutableList.builder().add((Object)new JdbcColumnMetaData(0, true, 0, false, 64, "TABLE_TYPE", "TABLE_TYPE", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).build();
        }
        return tableTypesColumnMetaData;
    }

    static ImmutableList<JdbcColumnMetaData> buildColumnsColumnMetaData(String schemaName) {
        if (columnsColumnMetaData == null) {
            int ordinal = 0;
            columnsColumnMetaData = ImmutableList.builder().add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "TABLE_CAT", "TABLE_CAT", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "TABLE_SCHEM", "TABLE_SCHEM", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 0, false, 120, "TABLE_NAME", "TABLE_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 0, false, 255, "COLUMN_NAME", "COLUMN_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 12, "DATA_TYPE", "DATA_TYPE", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, false, 64, "TYPE_NAME", "TYPE_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 12, "COLUMN_SIZE", "COLUMN_SIZE", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 1, true, 12, "BUFFER_LENGTH", "BUFFER_LENGTH", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 1, true, 12, "DECIMAL_DIGITS", "DECIMAL_DIGITS", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 1, true, 12, "NUM_PREC_RADIX", "NUM_PREC_RADIX", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 2, "NULLABLE", "NULLABLE", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 255, "REMARKS", "REMARKS", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 255, "COLUMN_DEF", "COLUMN_DEF", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, true, 12, "SQL_DATA_TYPE", "SQL_DATA_TYPE", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, true, 12, "SQL_DATETIME_SUB", "SQL_DATETIME_SUB", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, true, 12, "CHAR_OCTET_LENGTH", "CHAR_OCTET_LENGTH", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 12, "ORDINAL_POSITION", "ORDINAL_POSITION", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, false, 12, "IS_NULLABLE", "IS_NULLABLE", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "SCOPE_CATALOG", "SCOPE_CATALOG", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "SCOPE_SCHEMA", "SCOPE_SCHEMA", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 120, "SCOPE_TABLE", "SCOPE_TABLE", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, true, 12, "SOURCE_DATA_TYPE", "SOURCE_DATA_TYPE", schemaName, 0, 0, 5, JdbcType.SMALLINT.name(), Short.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 0, false, 3, "IS_AUTOINCREMENT", "IS_AUTOINCREMENT", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal, true, 0, false, 3, "IS_GENERATEDCOLUMN", "IS_GENERATEDCOLUMN", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).build();
        }
        return columnsColumnMetaData;
    }

    static ImmutableList<JdbcColumnMetaData> buildColumnPrivilegesColumnMetaData(String schemaName) {
        if (columnPrivilegesColumnMetaData == null) {
            int ordinal = 0;
            columnPrivilegesColumnMetaData = ImmutableList.builder().add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "TABLE_CAT", "TABLE_CAT", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "TABLE_SCHEM", "TABLE_SCHEM", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 0, false, 64, "TABLE_NAME", "TABLE_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 0, false, 64, "COLUMN_NAME", "COLUMN_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "GRANTOR", "GRANTOR", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 0, false, 64, "GRANTEE", "GRANTEE", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 0, false, 64, "PRIVILEGE", "PRIVILEGE", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal, true, 1, false, 64, "IS_GRANTABLE", "IS_GRANTABLE", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).build();
        }
        return columnPrivilegesColumnMetaData;
    }

    static ImmutableList<JdbcColumnMetaData> buildAttributesColumnMetaData(String schemaName) {
        if (attributesColumnMetaData == null) {
            int ordinal = 0;
            attributesColumnMetaData = ImmutableList.builder().add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "TYPE_CAT", "TYPE_CAT", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "TYPE_SCHEM", "TYPE_SCHEM", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 0, false, 120, "TYPE_NAME", "TYPE_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 0, false, 255, "ATTR_NAME", "ATTR_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 12, "DATA_TYPE", "DATA_TYPE", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, false, 64, "ATTR_TYPE_NAME", "ATTR_TYPE_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 12, "ATTR_SIZE", "ATTR_SIZE", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 1, true, 12, "DECIMAL_DIGITS", "DECIMAL_DIGITS", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 1, true, 12, "NUM_PREC_RADIX", "NUM_PREC_RADIX", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 2, "NULLABLE", "NULLABLE", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 255, "REMARKS", "REMARKS", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 255, "ATTR_DEF", "ATTR_DEF", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, true, 12, "SQL_DATA_TYPE", "SQL_DATA_TYPE", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, true, 12, "SQL_DATETIME_SUB", "SQL_DATETIME_SUB", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, true, 12, "CHAR_OCTET_LENGTH", "CHAR_OCTET_LENGTH", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 12, "ORDINAL_POSITION", "ORDINAL_POSITION", schemaName, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, false, 12, "IS_NULLABLE", "IS_NULLABLE", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "SCOPE_CATALOG", "SCOPE_CATALOG", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "SCOPE_SCHEMA", "SCOPE_SCHEMA", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 120, "SCOPE_TABLE", "SCOPE_TABLE", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal, true, 1, true, 12, "SOURCE_DATA_TYPE", "SOURCE_DATA_TYPE", schemaName, 0, 0, 5, JdbcType.SMALLINT.name(), Short.TYPE.getName())).build();
        }
        return attributesColumnMetaData;
    }

    static ImmutableList<JdbcColumnMetaData> buildPrimaryKeysColumnMetaData(String schemaName) {
        if (primaryKeysColumnMetaData == null) {
            int ordinal = 0;
            primaryKeysColumnMetaData = ImmutableList.builder().add((Object)new JdbcColumnMetaData(ordinal++, false, true, true, false, 1, false, 64, "TABLE_CAT", "TABLE_CAT", schemaName, 0, 0, "", "", 12, JdbcType.VARCHAR.name(), true, false, false, String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, true, true, false, 1, false, 64, "TABLE_SCHEM", "TABLE_SCHEM", schemaName, 0, 0, "", "", 12, JdbcType.VARCHAR.name(), true, false, false, String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, true, true, false, 0, false, 120, "TABLE_NAME", "TABLE_NAME", schemaName, 0, 0, "", "", 12, JdbcType.VARCHAR.name(), true, false, false, String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, true, true, false, 0, false, 255, "COLUMN_NAME", "COLUMN_NAME", schemaName, 0, 0, "", "", 12, JdbcType.VARCHAR.name(), true, false, false, String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, false, true, false, 0, true, 12, "KEY_SEQ", "KEY_SEQ", schemaName, 0, 0, "", "", 5, JdbcType.SMALLINT.name(), true, false, false, Short.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal, false, false, true, false, 1, false, 64, "PK_NAME", "PK_NAME", schemaName, 0, 0, "", "", 12, JdbcType.VARCHAR.name(), true, false, false, String.class.getName())).build();
        }
        return primaryKeysColumnMetaData;
    }

    static ImmutableList<JdbcColumnMetaData> buildImportedKeysColumnMetaData(String schemaName) {
        if (importedKeysColumnMetaData == null) {
            int ordinal = 0;
            importedKeysColumnMetaData = ImmutableList.builder().add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "PKTABLE_CAT", "PKTABLE_CAT", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "PKTABLE_SCHEM", "PKTABLE_SCHEM", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 0, false, 120, "PKTABLE_NAME", "PKTABLE_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 0, false, 255, "PKCOLUMN_NAME", "PKCOLUMN_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "FKTABLE_CAT", "FKTABLE_CAT", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 1, false, 64, "FKTABLE_SCHEM", "FKTABLE_SCHEM", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 0, false, 120, "FKTABLE_NAME", "FKTABLE_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, true, 0, false, 255, "FKCOLUMN_NAME", "FKCOLUMN_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 12, "KEY_SEQ", "KEY_SEQ", schemaName, 0, 0, 5, JdbcType.SMALLINT.name(), Short.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 12, "UPDATE_RULE", "UPDATE_RULE", schemaName, 0, 0, 5, JdbcType.SMALLINT.name(), Short.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 12, "DELETE_RULE", "DELETE_RULE", schemaName, 0, 0, 5, JdbcType.SMALLINT.name(), Short.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 1, false, 64, "FK_NAME", "FK_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 1, false, 64, "PK_NAME", "PK_NAME", schemaName, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal, false, 0, true, 12, "DEFERRABILITY", "DEFERRABILITY", schemaName, 0, 0, 5, JdbcType.SMALLINT.name(), Short.TYPE.getName())).build();
        }
        return importedKeysColumnMetaData;
    }

    static ImmutableList<JdbcColumnMetaData> buildTypeInfoColumnMetaData() {
        if (typeInfoColumnMetaData == null) {
            int ordinal = 0;
            typeInfoColumnMetaData = ImmutableList.builder().add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 64, "TYPE_NAME", "TYPE_NAME", null, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 64, "DATA_TYPE", "DATA_TYPE", null, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 64, "PRECISION", "PRECISION", null, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 1, true, 64, "LITERAL_PREFIX", "LITERAL_PREFIX", null, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 1, true, 64, "LITERAL_SUFFIX", "LITERAL_SUFFIX", null, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 1, true, 64, "CREATE_PARAMS", "CREATE_PARAMS", null, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 64, "NULLABLE", "NULLABLE", null, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 64, "CASE_SENSITIVE", "CASE_SENSITIVE", null, 0, 0, 16, JdbcType.BOOLEAN.name(), Boolean.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 64, "SEARCHABLE", "SEARCHABLE", null, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 64, "UNSIGNED_ATTRIBUTE", "UNSIGNED_ATTRIBUTE", null, 0, 0, 16, JdbcType.BOOLEAN.name(), Boolean.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 64, "FIXED_PREC_SCALE", "FIXED_PREC_SCALE", null, 0, 0, 16, JdbcType.BOOLEAN.name(), Boolean.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 64, "AUTO_INCREMENT", "AUTO_INCREMENT", null, 0, 0, 16, JdbcType.BOOLEAN.name(), Boolean.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 1, true, 64, "LOCAL_TYPE_NAME", "LOCAL_TYPE_NAME", null, 0, 0, 12, JdbcType.VARCHAR.name(), String.class.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 64, "MINIMUM_SCALE", "MINIMUM_SCALE", null, 0, 0, 5, JdbcType.SMALLINT.name(), Short.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 64, "MAXIMUM_SCALE", "MAXIMUM_SCALE", null, 0, 0, 5, JdbcType.SMALLINT.name(), Short.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 64, "SQL_DATA_TYPE", "SQL_DATA_TYPE", null, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal++, false, 0, true, 64, "SQL_DATETIME_SUB", "SQL_DATETIME_SUB", null, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).add((Object)new JdbcColumnMetaData(ordinal, false, 0, true, 64, "NUM_PREC_RADIX", "NUM_PREC_RADIX", null, 0, 0, 4, JdbcType.INTEGER.name(), Integer.TYPE.getName())).build();
        }
        return typeInfoColumnMetaData;
    }
}

