/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.sshtunnel;

import java.lang.management.ManagementFactory;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DocumentDbSshTunnelTestClientRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentDbSshTunnelTestClientRunner.class);
    private static final String PROCESS_NAME = ManagementFactory.getRuntimeMXBean().getName();
    private static String connectionString;
    private static int clientRunTime;

    DocumentDbSshTunnelTestClientRunner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        boolean hasExceptions = false;
        if (args.length < 1) {
            LOGGER.error("Unexpected number of arguments. Required: connectionString [maxNumberOfClients]");
            System.exit(-1);
        }
        connectionString = args[0];
        int maxNumberOfClients = args.length > 1 ? Integer.parseInt(args[1]) : 1;
        clientRunTime = args.length > 2 ? Integer.parseInt(args[2]) : 30;
        ArrayList<Map.Entry<ClientConnectionRunner, Thread>> runners = new ArrayList<Map.Entry<ClientConnectionRunner, Thread>>();
        try {
            for (int index = 0; index < maxNumberOfClients; ++index) {
                DocumentDbSshTunnelTestClientRunner.startConnectionRunner(runners, index);
            }
        }
        catch (Exception e) {
            hasExceptions = true;
            DocumentDbSshTunnelTestClientRunner.writeException(e);
        }
        finally {
            for (Map.Entry entry : runners) {
                try {
                    DocumentDbSshTunnelTestClientRunner.waitForConnectionRunner(entry);
                }
                catch (Exception e) {
                    hasExceptions = true;
                    DocumentDbSshTunnelTestClientRunner.writeException(e);
                }
            }
            runners.clear();
        }
        System.exit(hasExceptions ? 1 : 0);
    }

    private static void waitForConnectionRunner(Map.Entry<ClientConnectionRunner, Thread> entry) throws InterruptedException {
        LOGGER.debug(PROCESS_NAME + ": Stopping entry");
        entry.getValue().join();
        if (entry.getKey().exception != null) {
            LOGGER.error("Connection failed", (Throwable)entry.getKey().exception);
        }
        LOGGER.debug(PROCESS_NAME + ": Stopped entry");
    }

    private static void startConnectionRunner(List<Map.Entry<ClientConnectionRunner, Thread>> runners, int index) {
        LOGGER.debug(PROCESS_NAME + ": Starting client " + index);
        Thread runnerThread = DocumentDbSshTunnelTestClientRunner.getRunnerThread(runners);
        runnerThread.start();
        LOGGER.debug(PROCESS_NAME + ": Started client " + index);
    }

    private static Thread getRunnerThread(List<Map.Entry<ClientConnectionRunner, Thread>> runners) {
        ClientConnectionRunner runner = new ClientConnectionRunner(connectionString, clientRunTime);
        Thread runnerThread = new Thread(runner);
        runners.add(new AbstractMap.SimpleImmutableEntry<ClientConnectionRunner, Thread>(runner, runnerThread));
        return runnerThread;
    }

    private static void writeException(Exception e) {
        LOGGER.error(PROCESS_NAME + ": Exception: " + e);
        LOGGER.error(Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining(System.lineSeparator())));
    }

    private static class ClientConnectionRunner
    implements Runnable,
    AutoCloseable {
        public static final SecureRandom RANDOM = new SecureRandom();
        private volatile Exception exception = null;
        private final String connectionString;
        private final int waitTimeoutSECS;

        public ClientConnectionRunner(String connectionString, int waitTimeoutSECS) {
            this.connectionString = connectionString;
            this.waitTimeoutSECS = waitTimeoutSECS;
        }

        @Override
        public void run() {
            try (Connection connection = DriverManager.getConnection(this.connectionString);){
                boolean connected = connection.isValid(0);
                LOGGER.debug("Connection is valid: " + connected);
                assert (connected);
                int randomExtension = RANDOM.nextInt(Math.max(1, (int)(0.25 * (double)this.waitTimeoutSECS)));
                TimeUnit.SECONDS.sleep(this.waitTimeoutSECS + randomExtension);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        @Override
        public void close() throws Exception {
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

