/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.sshtunnel;

import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperties;

public final class DocumentDbSshTunnelLock {
    static final String LOCK_BASE_FOLDER_NAME = DocumentDbSshTunnelLock.getLockBaseFolderName();
    static final String PORT_LOCK_NAME = ".sshTunnelLockPort";
    static final String STARTUP_LOCK_NAME = ".sshTunnelLockStartup";
    static final String SERVER_LOCK_NAME = ".sshTunnelLockServer";
    static final String CLIENT_LOCK_FOLDER_NAME = "clients";
    private static final String GLOBAL_LOCK_NAME = ".sshTunnelLockGlobal";
    private static final String CLIENT_LOCK_NAME = ".sshTunnelLockClient";
    private static String classPathLocationName = null;

    private DocumentDbSshTunnelLock() {
    }

    static String getHashString(String sshUser, String sshHostname, String sshPrivateKeyFile, String remoteHostname) {
        String sshPropertiesString = sshUser + "-" + sshHostname + "-" + sshPrivateKeyFile + remoteHostname;
        return Hashing.sha256().hashString((CharSequence)sshPropertiesString, StandardCharsets.UTF_8).toString();
    }

    /*
     * Exception decompiling
     */
    static <R> R runInGlobalLock(@NonNull String propertiesHashString, @NonNull Supplier<R> function) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static @NonNull Path getGlobalLockPath(@NonNull String propertiesHashString) {
        return Paths.get(LOCK_BASE_FOLDER_NAME, propertiesHashString, GLOBAL_LOCK_NAME);
    }

    static @NonNull Path getServerLockPath(@NonNull String propertiesHashString) {
        return Paths.get(LOCK_BASE_FOLDER_NAME, propertiesHashString, SERVER_LOCK_NAME);
    }

    static @NonNull Path getStartupLockPath(@NonNull String sshPropertiesHashString) {
        return Paths.get(LOCK_BASE_FOLDER_NAME, sshPropertiesHashString, STARTUP_LOCK_NAME);
    }

    static @NonNull Path getPortLockPath(@NonNull String propertiesHashString) {
        return Paths.get(LOCK_BASE_FOLDER_NAME, propertiesHashString, PORT_LOCK_NAME);
    }

    static @NonNull Path getLockDirectoryPath(@NonNull String propertiesHashString) {
        return Paths.get(LOCK_BASE_FOLDER_NAME, propertiesHashString);
    }

    static void deleteStartupAndPortLockFiles(@NonNull Path startupLockPath, @NonNull Path portLockPah) throws IOException {
        Files.deleteIfExists(portLockPah);
        Files.deleteIfExists(startupLockPath);
    }

    static void deleteLockDirectory(@NonNull String propertiesHashString) throws IOException {
        Path lockDirectoryPath = DocumentDbSshTunnelLock.getLockDirectoryPath(propertiesHashString);
        DocumentDbSshTunnelLock.deleteDirectoryRecursive(lockDirectoryPath);
    }

    private static void deleteDirectoryRecursive(@NonNull Path directoryPath) throws IOException {
        if (!Files.exists(directoryPath, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> pathStream = Files.walk(directoryPath, new FileVisitOption[0]);){
            pathStream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }

    static @NonNull Path getClientLockPath(@NonNull UUID unique, @NonNull String propertiesHashString) {
        return Paths.get(LOCK_BASE_FOLDER_NAME, propertiesHashString, CLIENT_LOCK_FOLDER_NAME, ".sshTunnelLockClient-" + unique);
    }

    static Path getClientsFolderPath(String sshPropertiesHashString) {
        return Paths.get(LOCK_BASE_FOLDER_NAME, sshPropertiesHashString, CLIENT_LOCK_FOLDER_NAME);
    }

    private static String getLockBaseFolderName() {
        return Paths.get(DocumentDbSshTunnelLock.getDocumentdbHomePathName(), "sshTunnelLocks").toString();
    }

    public static String getDocumentdbHomePathName() {
        return DocumentDbConnectionProperties.DOCUMENTDB_HOME_PATH_NAME;
    }

    public static String getClassPathLocationName() {
        if (classPathLocationName == null) {
            classPathLocationName = DocumentDbConnectionProperties.getClassPathLocation();
        }
        return classPathLocationName;
    }

    static String getUserHomePathName() {
        return DocumentDbConnectionProperties.USER_HOME_PATH_NAME;
    }
}

