/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.sshtunnel;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;

final class DocumentDbMultiThreadFileChannel
implements AutoCloseable {
    private final FileChannel fileChannel;

    private DocumentDbMultiThreadFileChannel(@NonNull FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    @Override
    public void close() throws Exception {
        this.fileChannel.close();
    }

    public static DocumentDbMultiThreadFileChannel open(Path path, OpenOption ... options) throws IOException {
        FileChannel fileChannel = FileChannel.open(path, options);
        return new DocumentDbMultiThreadFileChannel(fileChannel);
    }

    public FileLock tryLock() throws IOException {
        try {
            return this.fileChannel.tryLock();
        }
        catch (NonWritableChannelException | OverlappingFileLockException e) {
            return null;
        }
    }

    public @NonNull FileLock lock() throws IOException, InterruptedException {
        return this.lock(10);
    }

    public @NonNull FileLock lock(int pollTimeMS) throws IOException, InterruptedException {
        FileLock fileLock;
        do {
            try {
                fileLock = this.fileChannel.lock();
            }
            catch (NonWritableChannelException | OverlappingFileLockException e) {
                TimeUnit.MILLISECONDS.sleep(pollTimeMS);
                fileLock = null;
            }
        } while (fileLock == null);
        return fileLock;
    }

    public boolean isOpen() {
        return this.fileChannel.isOpen();
    }

    FileChannel getFileChannel() {
        return this.fileChannel;
    }
}

