/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.calcite.adapter;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbMethod;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbRel;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbRules;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbTable;

public class DocumentDbToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentDbToEnumerableConverter.class);

    protected DocumentDbToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DocumentDbToEnumerableConverter(this.getCluster(), traitSet, (RelNode)DocumentDbToEnumerableConverter.sole(inputs));
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost relOptCost = super.computeSelfCost(planner, mq);
        return relOptCost != null ? relOptCost.multiplyBy(0.1) : null;
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder list = new BlockBuilder();
        DocumentDbRel.Implementor mongoImplementor = new DocumentDbRel.Implementor(this.getCluster().getRexBuilder());
        mongoImplementor.visitChild(0, this.getInput());
        final RelDataType rowType = this.getRowType();
        final PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)rowType, (JavaRowFormat)pref.prefer(JavaRowFormat.ARRAY));
        Expression fields = list.append("fields", (Expression)DocumentDbToEnumerableConverter.constantArrayList(Pair.zip(DocumentDbRules.mongoFieldNames(rowType, mongoImplementor.getMetadataTable()), (List)new AbstractList<Class>(){

            @Override
            public Class get(int index) {
                return physType.fieldClass(index);
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        }), Pair.class));
        Expression paths = list.append("paths", (Expression)DocumentDbToEnumerableConverter.constantArrayList(DocumentDbRules.mongoFieldNames(rowType, mongoImplementor.getMetadataTable()), String.class));
        Expression table = list.append("table", mongoImplementor.getTable().getExpression(DocumentDbTable.DocumentDbQueryable.class));
        DocumentDbToEnumerableConverter.handleVirtualTable(mongoImplementor);
        List opList = Pair.right(mongoImplementor.getList());
        Expression ops = list.append("ops", (Expression)DocumentDbToEnumerableConverter.constantArrayList(opList, String.class));
        Expression enumerable = list.append("enumerable", (Expression)Expressions.call((Expression)table, (Method)DocumentDbMethod.MONGO_QUERYABLE_AGGREGATE.getMethod(), (Expression[])new Expression[]{fields, paths, ops}));
        if (((Boolean)CalciteSystemProperty.DEBUG.value()).booleanValue()) {
            LOGGER.info("opList: {}", (Object)opList);
        }
        Hook.QUERY_PLAN.run((Object)opList);
        list.add((Statement)Expressions.return_(null, (Expression)enumerable));
        return implementor.result(physType, list.toBlock());
    }

    private static <T> MethodCallExpression constantArrayList(List<T> values, Class clazz) {
        return Expressions.call((Method)BuiltInMethod.ARRAYS_AS_LIST.method, (Expression[])new Expression[]{Expressions.newArrayInit((Type)clazz, DocumentDbToEnumerableConverter.constantList(values))});
    }

    private static <T> List<Expression> constantList(List<T> values) {
        return Util.transform(values, Expressions::constant);
    }

    public static void handleVirtualTable(DocumentDbRel.Implementor implementor) {
        ArrayList<Pair<String, String>> stages = new ArrayList<Pair<String, String>>();
        if (implementor.isResolutionNeedsUnwind()) {
            implementor.getUnwinds().forEach(op -> stages.add(Pair.of(null, (Object)op)));
            implementor.getCollisionResolutions().forEach(op -> stages.add(Pair.of(null, (Object)op)));
        } else {
            implementor.getCollisionResolutions().forEach(op -> stages.add(Pair.of(null, (Object)op)));
            implementor.getUnwinds().forEach(op -> stages.add(Pair.of(null, (Object)op)));
        }
        if (!implementor.isNullFiltered() && implementor.getVirtualTableFilter() != null) {
            stages.add(Pair.of(null, (Object)implementor.getVirtualTableFilter()));
        }
        implementor.setNullFiltered(true);
        stages.addAll(implementor.getList());
        implementor.setList(stages);
    }
}

