/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.mongodb.DuplicateKeyException;
import com.mongodb.client.MongoClient;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperties;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperty;
import software.amazon.documentdb.jdbc.DocumentDbDriver;
import software.amazon.documentdb.jdbc.DocumentDbMetadataScanMethod;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.metadata.DocumentDbDatabaseSchemaMetadata;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchema;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaTable;
import software.amazon.documentdb.jdbc.persist.DocumentDbSchemaSecurityException;
import software.amazon.documentdb.jdbc.sshtunnel.DocumentDbSshTunnelService;

public class DocumentDbMain {
    public static final String LIBRARY_NAME;
    public static final String ARCHIVE_VERSION;
    public static final Path USER_HOME_PATH;
    @VisibleForTesting
    static final Options COMPLETE_OPTIONS;
    @VisibleForTesting
    static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ssXXX";
    static final ObjectMapper JSON_OBJECT_MAPPER;
    private static final Logger LOGGER;
    private static final Options HELP_VERSION_OPTIONS;
    private static final Option HELP_OPTION;
    private static final Option VERSION_OPTION;
    private static final Options SSH_TUNNEL_SERVICE_OPTIONS;
    private static final OptionGroup COMMAND_OPTIONS;
    private static final List<Option> REQUIRED_OPTIONS;
    private static final List<Option> OPTIONAL_OPTIONS;
    private static final String LIBRARY_NAME_DEFAULT = "documentdb-jdbc";
    private static final String DATABASE_OPTION_FLAG = "d";
    private static final String DATABASE_OPTION_NAME = "database";
    private static final String EXPORT_OPTION_FLAG = "e";
    private static final String EXPORT_OPTION_NAME = "export";
    private static final String GENERATE_NAME_OPTION_FLAG = "g";
    private static final String GENERATE_NEW_OPTION_NAME = "generate-new";
    private static final String HELP_OPTION_FLAG = "h";
    private static final String HELP_OPTION_NAME = "help";
    private static final String IMPORT_OPTION_FLAG = "i";
    private static final String IMPORT_OPTION_NAME = "import";
    private static final String LIST_OPTION_FLAG = "l";
    private static final String LIST_OPTION_NAME = "list-schema";
    private static final String LIST_TABLES_OPTION_FLAG = "b";
    private static final String LIST_TABLES_OPTION_NAME = "list-tables";
    private static final String OUTPUT_OPTION_FLAG = "o";
    private static final String OUTPUT_OPTION_NAME = "output";
    private static final String PASSWORD_OPTION_FLAG = "p";
    private static final String PASSWORD_OPTION_NAME = "password";
    private static final String REMOVE_OPTION_FLAG = "r";
    private static final String REMOVE_OPTION_NAME = "remove";
    private static final String SCAN_LIMIT_OPTION_FLAG = "x";
    private static final String SCAN_LIMIT_OPTION_NAME = "scan-limit";
    private static final String SCAN_METHOD_OPTION_FLAG = "m";
    private static final String SCAN_METHOD_OPTION_NAME = "scan-method";
    private static final String SCHEMA_NAME_OPTION_FLAG = "n";
    private static final String SCHEMA_NAME_OPTION_NAME = "schema-name";
    private static final String SERVER_OPTION_FLAG = "s";
    private static final String SERVER_OPTION_NAME = "server";
    private static final String TLS_ALLOW_INVALID_HOSTNAMES_OPTION_FLAG = "a";
    private static final String TLS_ALLOW_INVALID_HOSTNAMES_OPTION_NAME = "tls-allow-invalid-hostnames";
    private static final String TLS_OPTION_FLAG = "t";
    private static final String TLS_OPTION_NAME = "tls";
    private static final String USER_OPTION_FLAG = "u";
    private static final String USER_OPTION_NAME = "user";
    private static final String VERSION_OPTION_NAME = "version";
    public static final String SSH_TUNNEL_SERVICE_OPTION_NAME = "ssh-tunnel-service";
    private static final String DATABASE_NAME_ARG_NAME = "database-name";
    private static final String FILE_NAME_ARG_NAME = "file-name";
    private static final String HOST_NAME_ARG_NAME = "host-name";
    private static final String MAX_DOCUMENTS_ARG_NAME = "max-documents";
    private static final String METHOD_ARG_NAME = "method";
    private static final String USER_NAME_ARG_NAME = "user-name";
    private static final String TABLE_NAMES_ARG_NAME = "[table-name[,...]]";
    private static final String SSH_TUNNEL_SERVICE_ARG_NAME = "ssh-properties";
    private static final String GENERATE_NEW_OPTION_DESCRIPTION = "Generates a new schema for the database. This will have the effect of replacing an existing schema of the same name, if it exists.";
    private static final String REMOVE_OPTION_DESCRIPTION = "Removes the schema from storage for schema given by -m <schema-name>, or for schema '_default', if not provided.";
    private static final String VERSION_OPTION_DESCRIPTION = "Prints the version number of the command.";
    private static final String HELP_OPTION_DESCRIPTION = "Prints the command line syntax.";
    private static final String SERVER_OPTION_DESCRIPTION = "The hostname and optional port number (default: 27017) in the format hostname[:port]. Required.";
    private static final String DATABASE_OPTION_DESCRIPTION = "The name of the database for the schema operations. Required.";
    private static final String USER_OPTION_DESCRIPTION = "The name of the user performing the schema operations. Required. Note: the user will require readWrite role on the <database-name> where the schema are stored if creating or modifying schema.";
    private static final String PASSWORD_OPTION_DESCRIPTION = "The password for the user performing the schema operations. Optional. If this option is not provided, the end-user will be prompted to enter the password directly.";
    private static final String SCHEMA_NAME_OPTION_DESCRIPTION = "The name of the schema. Default: _default.";
    private static final String SCAN_METHOD_OPTION_DESCRIPTION = "The scan method to sample documents from the collections. One of: random, idForward, idReverse, or all. Used in conjunction with the --generate-new command. Default: random.";
    private static final String SCAN_LIMIT_OPTION_DESCRIPTION = "The maximum number of documents to sample in each collection. Used in conjunction with the --generate-new command. Default: 1000.";
    private static final String TLS_OPTION_DESCRIPTION = "The indicator of whether to use TLS encryption when connecting to DocumentDB. Default: false.";
    private static final String TLS_ALLOW_INVALID_HOSTNAMES_OPTION_DESCRIPTION = "The indicator of whether to allow invalid hostnames when connecting to DocumentDB. Default: false.";
    private static final String LIST_OPTION_DESCRIPTION = "Lists the schema names, version and table names available in the schema repository.";
    private static final String LIST_TABLES_OPTION_DESCRIPTION = "Lists the SQL table names in a schema.";
    private static final String EXPORT_OPTION_DESCRIPTION = "Exports the schema to for SQL tables named [<table-name>[,<table-name>[\u2026]]]. If no <table-name> are given, all table schema will be exported. By default, the schema is written to stdout. Use the --output option to write to a file. The output format is JSON.";
    private static final String IMPORT_OPTION_DESCRIPTION = "Imports the schema from <file-name> in your home directory. The schema will be imported using the <schema-name> and a new version will be added - replacing the existing schema. The expected input format is JSON.";
    private static final String OUTPUT_OPTION_DESCRIPTION = "Write the exported schema to <file-name> in your home directory (instead of stdout). This will overwrite any existing file with the same name";
    private static final String SSH_TUNNEL_SERVICE_OPTION_DESCRIPTION = "Starts an SSH Tunnel service.";
    public static final String DUPLICATE_COLUMN_KEY_DETECTED_FOR_TABLE_SCHEMA = "Duplicate column key '%s' detected for table schema '%s'. Original column '%s'. Duplicate column '%s'.";
    private static final String NEW_SCHEMA_VERSION_GENERATED_MESSAGE = "New schema '%s', version '%s' generated.";
    private static final String REMOVED_SCHEMA_MESSAGE = "Removed schema '%s'.";
    private static MongoClient client;

    public static void main(String[] args) {
        try {
            StringBuilder output = new StringBuilder();
            DocumentDbMain.handleCommandLine(args, output);
            if (output.length() > 0) {
                LOGGER.error("{}", (Object)output);
            }
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception: '{}'", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void handleCommandLine(String[] args, StringBuilder output) throws SQLException {
        if (DocumentDbMain.handledHelpOrVersionOption(args, output)) {
            return;
        }
        try {
            DocumentDbConnectionProperties properties;
            DefaultParser parser = new DefaultParser();
            CommandLine commandLineSshTunnelService = parser.parse(SSH_TUNNEL_SERVICE_OPTIONS, args, true);
            if (commandLineSshTunnelService.hasOption(SSH_TUNNEL_SERVICE_OPTION_NAME)) {
                DocumentDbMain.performSshTunnelService(commandLineSshTunnelService, output);
                return;
            }
            CommandLine commandLine = parser.parse(COMPLETE_OPTIONS, args);
            if (!DocumentDbMain.tryGetConnectionProperties(commandLine, properties = new DocumentDbConnectionProperties(), output)) {
                return;
            }
            DocumentDbMain.performCommand(commandLine, properties, output);
        }
        catch (MissingOptionException e) {
            output.append(e.getMessage()).append(String.format("%n", new Object[0]));
            DocumentDbMain.printHelp(output);
        }
        catch (ParseException e) {
            output.append(e.getMessage());
        }
        catch (Exception e) {
            output.append(e.getClass().getSimpleName()).append(": ").append(e.getMessage());
        }
        finally {
            DocumentDbMain.closeClient();
        }
    }

    private static void performCommand(CommandLine commandLine, DocumentDbConnectionProperties properties, StringBuilder output) throws SQLException {
        switch (COMMAND_OPTIONS.getSelected()) {
            case "g": {
                DocumentDbMain.performGenerateNew(properties, output);
                break;
            }
            case "r": {
                DocumentDbMain.performRemove(properties, output);
                break;
            }
            case "l": {
                DocumentDbMain.performListSchema(properties, output);
                break;
            }
            case "b": {
                DocumentDbMain.performListTables(properties, output);
                break;
            }
            case "e": {
                DocumentDbMain.performExport(commandLine, properties, output);
                break;
            }
            case "i": {
                DocumentDbMain.performImport(commandLine, properties, output);
                break;
            }
            default: {
                output.append(SqlError.lookup(SqlError.UNSUPPORTED_PROPERTY, COMMAND_OPTIONS.getSelected()));
            }
        }
    }

    private static MongoClient getMongoClient(DocumentDbConnectionProperties properties) {
        if (client == null) {
            client = properties.createMongoClient();
        }
        return client;
    }

    private static void closeClient() {
        if (client != null) {
            client.close();
            client = null;
        }
    }

    private static void performSshTunnelService(CommandLine commandLine, StringBuilder output) throws DuplicateKeyException {
        try (DocumentDbSshTunnelService service = new DocumentDbSshTunnelService(commandLine.getOptionValue(SSH_TUNNEL_SERVICE_OPTION_NAME));){
            Thread serviceThread = new Thread(service);
            serviceThread.setDaemon(true);
            serviceThread.start();
            do {
                serviceThread.join(1000L);
            } while (serviceThread.isAlive());
            service.getExceptions().forEach(e -> output.append(e.getMessage()).append(System.lineSeparator()).append(Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining(System.lineSeparator()))).append(System.lineSeparator()));
        }
        catch (Exception e2) {
            output.append(e2.getMessage());
        }
    }

    private static void performImport(CommandLine commandLine, DocumentDbConnectionProperties properties, StringBuilder output) throws DuplicateKeyException {
        File importFile = DocumentDbMain.tryGetImportFile(commandLine, output);
        if (importFile == null) {
            return;
        }
        List<TableSchema> tableSchemaList = DocumentDbMain.tryReadTableSchemaList(importFile, output);
        if (tableSchemaList == null) {
            return;
        }
        List<DocumentDbSchemaTable> schemaTableList = DocumentDbMain.tryGetSchemaTableList(tableSchemaList, output);
        if (schemaTableList == null) {
            return;
        }
        DocumentDbMain.updateTableSchema(properties, schemaTableList, output);
    }

    private static void updateTableSchema(DocumentDbConnectionProperties properties, List<DocumentDbSchemaTable> schemaTableList, StringBuilder output) {
        try {
            DocumentDbDatabaseSchemaMetadata.update(properties, properties.getSchemaName(), schemaTableList, DocumentDbMain.getMongoClient(properties));
        }
        catch (SQLException | DocumentDbSchemaSecurityException e) {
            output.append(e.getClass().getSimpleName()).append(" ").append(e.getMessage());
        }
    }

    private static List<TableSchema> tryReadTableSchemaList(File importFile, StringBuilder output) {
        List tableSchemaList;
        try {
            tableSchemaList = (List)JSON_OBJECT_MAPPER.readValue(importFile, (TypeReference)new TypeReference<List<TableSchema>>(){});
        }
        catch (IOException e) {
            output.append(e.getClass().getSimpleName()).append(" ").append(e.getMessage());
            return null;
        }
        return tableSchemaList;
    }

    private static List<DocumentDbSchemaTable> tryGetSchemaTableList(List<TableSchema> tableSchemaList, StringBuilder output) {
        List<DocumentDbSchemaTable> schemaTableList;
        try {
            schemaTableList = tableSchemaList.stream().map(tableSchema -> new DocumentDbSchemaTable(tableSchema.getSqlName(), tableSchema.getCollectionName(), tableSchema.getColumns().stream().collect(Collectors.toMap(DocumentDbSchemaColumn::getSqlName, c -> c, (c1, c2) -> DocumentDbMain.throwingDuplicateMergeOnColumn(c1, c2, tableSchema.getSqlName()), LinkedHashMap::new)))).collect(Collectors.toList());
        }
        catch (IllegalStateException e) {
            output.append(e.getMessage());
            return null;
        }
        return schemaTableList;
    }

    private static DocumentDbSchemaColumn throwingDuplicateMergeOnColumn(DocumentDbSchemaColumn c1, DocumentDbSchemaColumn c2, String sqlName) {
        throw new IllegalStateException(String.format(DUPLICATE_COLUMN_KEY_DETECTED_FOR_TABLE_SCHEMA, c1.getSqlName(), sqlName, c1, c2));
    }

    private static File tryGetImportFile(CommandLine commandLine, StringBuilder output) {
        String importFileName = commandLine.getOptionValue(IMPORT_OPTION_FLAG, null);
        if (Strings.isNullOrEmpty((String)importFileName)) {
            output.append(String.format("Option '-%s' requires a file name argument.", IMPORT_OPTION_FLAG));
            return null;
        }
        Path importFilePath = USER_HOME_PATH.resolve(importFileName);
        if (!importFilePath.toFile().exists()) {
            output.append(String.format("Import file '%s' not found in your user's home folder.", importFileName));
            return null;
        }
        return importFilePath.toFile();
    }

    private static void performExport(CommandLine commandLine, DocumentDbConnectionProperties properties, StringBuilder output) throws SQLException {
        String[] requestedTableNames;
        File outputFile;
        if (commandLine.hasOption(OUTPUT_OPTION_FLAG)) {
            outputFile = DocumentDbMain.tryGetOutputFile(commandLine, output);
            if (outputFile == null) {
                return;
            }
        } else {
            outputFile = null;
        }
        ArrayList<String> requestedTableList = (requestedTableNames = commandLine.getOptionValues(EXPORT_OPTION_FLAG)) != null ? Arrays.asList(requestedTableNames) : new ArrayList<String>();
        DocumentDbDatabaseSchemaMetadata schema = DocumentDbDatabaseSchemaMetadata.get(properties, properties.getSchemaName(), -2, DocumentDbMain.getMongoClient(properties));
        if (schema == null) {
            return;
        }
        Set<String> availTableSet = schema.getTableSchemaMap().keySet();
        if (requestedTableList.isEmpty()) {
            requestedTableList.addAll(availTableSet);
        } else if (DocumentDbMain.verifyRequestedTablesExist(requestedTableList, availTableSet, output)) {
            return;
        }
        List<TableSchema> tableSchemaList = requestedTableList.stream().map(tableName -> new TableSchema(schema.getTableSchemaMap().get(tableName))).sorted(Comparator.comparing(TableSchema::getSqlName)).collect(Collectors.toList());
        try {
            DocumentDbMain.writeTableSchemas(tableSchemaList, outputFile, output);
        }
        catch (IOException e) {
            output.append(e.getClass().getSimpleName()).append(" ").append(e.getMessage());
        }
    }

    private static boolean verifyRequestedTablesExist(List<String> requestedTableList, Set<String> availTableNames, StringBuilder output) {
        if (!availTableNames.containsAll(requestedTableList)) {
            List unknownTables = requestedTableList.stream().filter(name -> !availTableNames.contains(name)).collect(Collectors.toList());
            output.append("Requested table name(s) are not recognized in schema: ").append(org.apache.logging.log4j.util.Strings.join(unknownTables, (char)',')).append(String.format("%n", new Object[0])).append("Available table names: ").append(org.apache.logging.log4j.util.Strings.join(availTableNames, (char)','));
            return true;
        }
        return false;
    }

    private static void writeTableSchemas(List<TableSchema> tables, File outputFile, StringBuilder output) throws IOException {
        try (Writer writer = outputFile != null ? new OutputStreamWriter(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8) : new StringBuilderWriter(output);){
            JSON_OBJECT_MAPPER.writeValue(writer, tables);
        }
    }

    private static File tryGetOutputFile(CommandLine commandLine, StringBuilder output) {
        if (!USER_HOME_PATH.toFile().exists()) {
            output.append("User's home directory does not exist.");
            return null;
        }
        String outputFileName = commandLine.getOptionValue(OUTPUT_OPTION_FLAG, null);
        if (Strings.isNullOrEmpty((String)outputFileName)) {
            output.append("Output file name argument must not be empty.");
            return null;
        }
        Path fileNamePath = Paths.get(outputFileName, new String[0]).getFileName();
        File outputFile = USER_HOME_PATH.resolve(fileNamePath).toAbsolutePath().toFile();
        if (outputFile.isDirectory()) {
            output.append("Output file name must not be a directory.");
            return null;
        }
        return outputFile;
    }

    private static void performListSchema(DocumentDbConnectionProperties properties, StringBuilder output) throws SQLException {
        List<DocumentDbSchema> schemas = DocumentDbDatabaseSchemaMetadata.getSchemaList(properties, DocumentDbMain.getMongoClient(properties));
        for (DocumentDbSchema schema : schemas) {
            output.append(String.format("Name=%s, Version=%d, SQL Name=%s, Modified=%s%n", DocumentDbMain.maybeQuote(schema.getSchemaName()), schema.getSchemaVersion(), DocumentDbMain.maybeQuote(schema.getSqlName()), new SimpleDateFormat(DATE_FORMAT_PATTERN).format(schema.getModifyDate())));
        }
    }

    private static void performListTables(DocumentDbConnectionProperties properties, StringBuilder output) throws SQLException {
        DocumentDbDatabaseSchemaMetadata schema = DocumentDbDatabaseSchemaMetadata.get(properties, properties.getSchemaName(), -2, DocumentDbMain.getMongoClient(properties));
        if (schema != null) {
            List sortedTableNames = schema.getTableSchemaMap().keySet().stream().sorted().collect(Collectors.toList());
            for (String tableName : sortedTableNames) {
                output.append(String.format("%s%n", tableName));
            }
        }
    }

    @VisibleForTesting
    static String maybeQuote(String value) {
        return StringEscapeUtils.escapeCsv((String)value);
    }

    private static void performRemove(DocumentDbConnectionProperties properties, StringBuilder output) throws SQLException {
        DocumentDbDatabaseSchemaMetadata.remove(properties, properties.getSchemaName(), DocumentDbMain.getMongoClient(properties));
        output.append(String.format(REMOVED_SCHEMA_MESSAGE, properties.getSchemaName()));
    }

    private static void performGenerateNew(DocumentDbConnectionProperties properties, StringBuilder output) throws SQLException {
        DocumentDbDatabaseSchemaMetadata schema = DocumentDbDatabaseSchemaMetadata.get(properties, properties.getSchemaName(), -1, DocumentDbMain.getMongoClient(properties));
        if (schema != null) {
            output.append(String.format(NEW_SCHEMA_VERSION_GENERATED_MESSAGE, schema.getSchemaName(), schema.getSchemaVersion()));
        }
    }

    @VisibleForTesting
    static boolean tryGetConnectionProperties(CommandLine commandLine, DocumentDbConnectionProperties properties, StringBuilder output) {
        properties.setHostname(commandLine.getOptionValue(SERVER_OPTION_FLAG));
        properties.setDatabase(commandLine.getOptionValue(DATABASE_OPTION_FLAG));
        properties.setUser(commandLine.getOptionValue(USER_OPTION_FLAG));
        if (!DocumentDbMain.trySetPassword(commandLine, properties, output)) {
            return false;
        }
        properties.setTlsEnabled(String.valueOf(commandLine.hasOption(TLS_OPTION_FLAG)));
        properties.setTlsAllowInvalidHostnames(String.valueOf(commandLine.hasOption(TLS_ALLOW_INVALID_HOSTNAMES_OPTION_FLAG)));
        properties.setMetadataScanMethod(commandLine.getOptionValue(SCAN_METHOD_OPTION_FLAG, DocumentDbConnectionProperty.METADATA_SCAN_METHOD.getDefaultValue()));
        properties.setMetadataScanLimit(commandLine.getOptionValue(SCAN_LIMIT_OPTION_FLAG, DocumentDbConnectionProperty.METADATA_SCAN_LIMIT.getDefaultValue()));
        properties.setSchemaName(commandLine.getOptionValue(SCHEMA_NAME_OPTION_FLAG, DocumentDbConnectionProperty.SCHEMA_NAME.getDefaultValue()));
        return true;
    }

    private static boolean trySetPassword(CommandLine commandLine, DocumentDbConnectionProperties properties, StringBuilder output) {
        if (!commandLine.hasOption(PASSWORD_OPTION_FLAG)) {
            return DocumentDbMain.trySetPasswordFromPromptInput(properties, output);
        }
        properties.setPassword(commandLine.getOptionValue(PASSWORD_OPTION_FLAG));
        return true;
    }

    private static boolean trySetPasswordFromPromptInput(DocumentDbConnectionProperties properties, StringBuilder output) {
        String passwordPrompt = SqlError.lookup(SqlError.PASSWORD_PROMPT, new Object[0]);
        Console console = System.console();
        char[] password = null;
        if (console != null) {
            password = console.readPassword(passwordPrompt, new Object[0]);
        } else {
            output.append("No console available.");
        }
        if (password == null || password.length == 0) {
            output.append(SqlError.lookup(SqlError.MISSING_PASSWORD, new Object[0]));
            return false;
        }
        properties.setPassword(new String(password));
        return true;
    }

    private static boolean handledHelpOrVersionOption(String[] args, StringBuilder output) throws SQLException {
        CommandLine commandLine;
        DefaultParser parser = new DefaultParser();
        try {
            commandLine = parser.parse(HELP_VERSION_OPTIONS, args, true);
        }
        catch (ParseException e) {
            throw new SQLException(e.getMessage(), e);
        }
        if (commandLine.hasOption(HELP_OPTION_NAME)) {
            DocumentDbMain.printHelp(output);
            return true;
        }
        if (commandLine.hasOption(VERSION_OPTION_NAME)) {
            output.append(String.format("%s: version %s", LIBRARY_NAME, ARCHIVE_VERSION));
            return true;
        }
        return false;
    }

    private static void printHelp(StringBuilder output) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        HelpFormatter formatter = new HelpFormatter();
        String cmdLineSyntax = DocumentDbMain.formatCommandLineSyntax();
        formatter.printHelp(printWriter, 80, cmdLineSyntax, null, COMPLETE_OPTIONS, 1, 2, null, false);
        output.append(stringWriter);
    }

    private static String formatCommandLineSyntax() {
        StringBuilder cmdLineSyntax = new StringBuilder();
        cmdLineSyntax.append(LIBRARY_NAME);
        DocumentDbMain.formatOptionGroup(cmdLineSyntax);
        DocumentDbMain.formatOptions(cmdLineSyntax, REQUIRED_OPTIONS);
        DocumentDbMain.formatOptions(cmdLineSyntax, OPTIONAL_OPTIONS);
        return cmdLineSyntax.toString();
    }

    private static void formatOptions(StringBuilder cmdLineSyntax, Collection<Option> options) {
        for (Option option : options) {
            cmdLineSyntax.append(" ");
            if (!option.isRequired()) {
                cmdLineSyntax.append("[");
            }
            if (option.getOpt() != null) {
                cmdLineSyntax.append("-").append(option.getOpt());
            } else {
                cmdLineSyntax.append("--").append(option.getLongOpt());
            }
            if (option.hasArg()) {
                cmdLineSyntax.append(String.format(" <%s>", option.getArgName()));
            } else if (option.hasOptionalArg()) {
                cmdLineSyntax.append(String.format(" [<%s>]", option.getArgName()));
            }
            if (option.isRequired()) continue;
            cmdLineSyntax.append("]");
        }
    }

    private static void formatOptionGroup(StringBuilder cmdLineSyntax) {
        cmdLineSyntax.append(" [");
        boolean isFirst = true;
        for (Option option : COMMAND_OPTIONS.getOptions()) {
            if (!isFirst) {
                cmdLineSyntax.append(" | ");
            }
            if (!COMMAND_OPTIONS.isRequired()) {
                cmdLineSyntax.append("[");
            }
            if (option.getOpt() != null) {
                cmdLineSyntax.append("-").append(option.getOpt());
            } else {
                cmdLineSyntax.append("--").append(option.getLongOpt());
            }
            if (option.hasArg()) {
                cmdLineSyntax.append(String.format(" <%s>", option.getArgName()));
            } else if (option.hasOptionalArg()) {
                cmdLineSyntax.append(String.format(" [<%s>]", option.getArgName()));
            }
            if (!COMMAND_OPTIONS.isRequired()) {
                cmdLineSyntax.append("]");
            }
            isFirst = false;
        }
        cmdLineSyntax.append("]");
    }

    private static List<Option> buildOptionalOptions() {
        ArrayList<Option> optionalOptions = new ArrayList<Option>();
        Option currOption = Option.builder((String)PASSWORD_OPTION_FLAG).longOpt(PASSWORD_OPTION_NAME).numberOfArgs(1).argName(PASSWORD_OPTION_NAME).desc(PASSWORD_OPTION_DESCRIPTION).required(false).build();
        optionalOptions.add(currOption);
        currOption = Option.builder((String)SCHEMA_NAME_OPTION_FLAG).longOpt(SCHEMA_NAME_OPTION_NAME).numberOfArgs(1).argName(SCHEMA_NAME_OPTION_NAME).desc(SCHEMA_NAME_OPTION_DESCRIPTION).required(false).build();
        optionalOptions.add(currOption);
        currOption = Option.builder((String)SCAN_METHOD_OPTION_FLAG).longOpt(SCAN_METHOD_OPTION_NAME).numberOfArgs(1).argName(METHOD_ARG_NAME).desc(SCAN_METHOD_OPTION_DESCRIPTION).required(false).type(DocumentDbMetadataScanMethod.class).build();
        optionalOptions.add(currOption);
        currOption = Option.builder((String)SCAN_LIMIT_OPTION_FLAG).longOpt(SCAN_LIMIT_OPTION_NAME).numberOfArgs(1).argName(MAX_DOCUMENTS_ARG_NAME).desc(SCAN_LIMIT_OPTION_DESCRIPTION).required(false).type(Integer.class).build();
        optionalOptions.add(currOption);
        currOption = Option.builder((String)TLS_OPTION_FLAG).longOpt(TLS_OPTION_NAME).desc(TLS_OPTION_DESCRIPTION).required(false).build();
        optionalOptions.add(currOption);
        currOption = Option.builder((String)TLS_ALLOW_INVALID_HOSTNAMES_OPTION_FLAG).longOpt(TLS_ALLOW_INVALID_HOSTNAMES_OPTION_NAME).desc(TLS_ALLOW_INVALID_HOSTNAMES_OPTION_DESCRIPTION).required(false).build();
        optionalOptions.add(currOption);
        currOption = Option.builder((String)OUTPUT_OPTION_FLAG).longOpt(OUTPUT_OPTION_NAME).desc(OUTPUT_OPTION_DESCRIPTION).numberOfArgs(1).argName(FILE_NAME_ARG_NAME).required(false).build();
        optionalOptions.add(currOption);
        optionalOptions.add(HELP_OPTION);
        optionalOptions.add(VERSION_OPTION);
        return optionalOptions;
    }

    private static List<Option> buildRequiredOptions() {
        ArrayList<Option> requiredOptions = new ArrayList<Option>();
        Option currOption = Option.builder((String)SERVER_OPTION_FLAG).longOpt(SERVER_OPTION_NAME).numberOfArgs(1).argName(HOST_NAME_ARG_NAME).desc(SERVER_OPTION_DESCRIPTION).required().build();
        requiredOptions.add(currOption);
        currOption = Option.builder((String)DATABASE_OPTION_FLAG).longOpt(DATABASE_OPTION_NAME).numberOfArgs(1).argName(DATABASE_NAME_ARG_NAME).desc(DATABASE_OPTION_DESCRIPTION).required().build();
        requiredOptions.add(currOption);
        currOption = Option.builder((String)USER_OPTION_FLAG).longOpt(USER_OPTION_NAME).numberOfArgs(1).argName(USER_NAME_ARG_NAME).desc(USER_OPTION_DESCRIPTION).required().build();
        requiredOptions.add(currOption);
        return requiredOptions;
    }

    private static OptionGroup buildCommandOptions() {
        OptionGroup commandOptions = new OptionGroup();
        Option currOption = Option.builder((String)GENERATE_NAME_OPTION_FLAG).longOpt(GENERATE_NEW_OPTION_NAME).desc(GENERATE_NEW_OPTION_DESCRIPTION).build();
        commandOptions.addOption(currOption);
        currOption = Option.builder((String)REMOVE_OPTION_FLAG).longOpt(REMOVE_OPTION_NAME).desc(REMOVE_OPTION_DESCRIPTION).build();
        commandOptions.addOption(currOption);
        currOption = Option.builder((String)LIST_OPTION_FLAG).longOpt(LIST_OPTION_NAME).desc(LIST_OPTION_DESCRIPTION).build();
        commandOptions.addOption(currOption);
        currOption = Option.builder((String)LIST_TABLES_OPTION_FLAG).longOpt(LIST_TABLES_OPTION_NAME).desc(LIST_TABLES_OPTION_DESCRIPTION).build();
        commandOptions.addOption(currOption);
        currOption = Option.builder((String)EXPORT_OPTION_FLAG).longOpt(EXPORT_OPTION_NAME).desc(EXPORT_OPTION_DESCRIPTION).argName(TABLE_NAMES_ARG_NAME).optionalArg(true).hasArgs().valueSeparator(',').build();
        commandOptions.addOption(currOption);
        currOption = Option.builder((String)IMPORT_OPTION_FLAG).longOpt(IMPORT_OPTION_NAME).desc(IMPORT_OPTION_DESCRIPTION).numberOfArgs(1).argName(FILE_NAME_ARG_NAME).build();
        commandOptions.addOption(currOption);
        commandOptions.setRequired(true);
        return commandOptions;
    }

    protected static String getLibraryName() {
        String libraryName = null;
        try {
            Path path = Paths.get(DocumentDbMain.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            Path fileName = path.getFileName();
            libraryName = fileName != null ? fileName.toString() : LIBRARY_NAME_DEFAULT;
        }
        catch (URISyntaxException e) {
            libraryName = LIBRARY_NAME_DEFAULT;
        }
        finally {
            if (libraryName == null) {
                libraryName = LIBRARY_NAME_DEFAULT;
            }
        }
        return libraryName;
    }

    private static String getArchiveVersion() {
        return DocumentDbDriver.DRIVER_VERSION;
    }

    private static Option buildVersionOption() {
        return Option.builder().longOpt(VERSION_OPTION_NAME).desc(VERSION_OPTION_DESCRIPTION).build();
    }

    private static Options buildSshTunnelServiceOption() {
        return new Options().addOption(Option.builder().longOpt(SSH_TUNNEL_SERVICE_OPTION_NAME).desc(SSH_TUNNEL_SERVICE_OPTION_DESCRIPTION).numberOfArgs(1).argName(SSH_TUNNEL_SERVICE_ARG_NAME).build());
    }

    private static Option buildHelpOption() {
        return Option.builder((String)HELP_OPTION_FLAG).longOpt(HELP_OPTION_NAME).desc(HELP_OPTION_DESCRIPTION).build();
    }

    @NonNull
    private static SimpleModule buildEnumLowerCaseSerializerModule() {
        SimpleModule module = new SimpleModule();
        StdSerializer serializer = new StdSerializer<Enum<?>>(Enum.class, true){

            public void serialize(Enum value, JsonGenerator jGen, SerializerProvider provider) throws IOException {
                jGen.writeString(value.name().toLowerCase());
            }
        };
        module.addSerializer((JsonSerializer)serializer);
        return module;
    }

    static {
        USER_HOME_PATH = Paths.get(System.getProperty("user.home"), new String[0]);
        JSON_OBJECT_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().defaultDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true))).serializationInclusion(JsonInclude.Include.NON_NULL)).serializationInclusion(JsonInclude.Include.NON_EMPTY)).serializationInclusion(JsonInclude.Include.NON_DEFAULT)).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).addModule((Module)DocumentDbMain.buildEnumLowerCaseSerializerModule())).addModule((Module)new GuavaModule())).build();
        LOGGER = LoggerFactory.getLogger(DocumentDbMain.class);
        ARCHIVE_VERSION = DocumentDbMain.getArchiveVersion();
        LIBRARY_NAME = DocumentDbMain.getLibraryName();
        HELP_OPTION = DocumentDbMain.buildHelpOption();
        VERSION_OPTION = DocumentDbMain.buildVersionOption();
        SSH_TUNNEL_SERVICE_OPTIONS = DocumentDbMain.buildSshTunnelServiceOption();
        COMMAND_OPTIONS = DocumentDbMain.buildCommandOptions();
        REQUIRED_OPTIONS = DocumentDbMain.buildRequiredOptions();
        OPTIONAL_OPTIONS = DocumentDbMain.buildOptionalOptions();
        COMPLETE_OPTIONS = new Options();
        COMPLETE_OPTIONS.addOptionGroup(COMMAND_OPTIONS);
        REQUIRED_OPTIONS.forEach(arg_0 -> ((Options)COMPLETE_OPTIONS).addOption(arg_0));
        OPTIONAL_OPTIONS.forEach(arg_0 -> ((Options)COMPLETE_OPTIONS).addOption(arg_0));
        HELP_VERSION_OPTIONS = new Options().addOption(HELP_OPTION).addOption(VERSION_OPTION);
    }

    private static class StringBuilderWriter
    extends Writer {
        private final StringBuilder stringBuilder;

        public StringBuilderWriter(StringBuilder stringBuilder) {
            this.stringBuilder = stringBuilder;
        }

        @Override
        public void write(char[] cBuf, int off, int len) {
            this.stringBuilder.append(cBuf, off, len);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    private static class TableSchema {
        @JsonProperty(value="sqlName")
        private final String sqlName;
        @JsonProperty(value="collectionName")
        private final String collectionName;
        @JsonProperty(value="columns")
        private final List<DocumentDbSchemaColumn> columns;

        public TableSchema(DocumentDbSchemaTable table) {
            this.sqlName = table.getSqlName();
            this.collectionName = table.getCollectionName();
            this.columns = ImmutableList.copyOf(table.getColumns());
        }

        @JsonCreator
        public TableSchema(@JsonProperty(value="sqlName") String sqlName, @JsonProperty(value="collectionName") String collectionName, @JsonProperty(value="columns") List<DocumentDbSchemaColumn> columns) {
            this.sqlName = sqlName;
            this.collectionName = collectionName;
            this.columns = columns;
        }

        public String getSqlName() {
            return this.sqlName;
        }

        public String getCollectionName() {
            return this.collectionName;
        }

        public List<DocumentDbSchemaColumn> getColumns() {
            return this.columns;
        }
    }
}

