/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.common;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;

public abstract class ResultSet
implements java.sql.ResultSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultSet.class);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final Statement statement;
    private SQLWarning warnings = null;

    protected ResultSet(Statement statement) {
        this.statement = statement;
    }

    protected abstract void doClose() throws SQLException;

    protected abstract int getDriverFetchSize() throws SQLException;

    protected abstract void setDriverFetchSize(int var1) throws SQLException;

    protected abstract int getRowIndex() throws SQLException;

    protected abstract int getRowCount() throws SQLException;

    protected void verifyOpen() throws SQLException {
        if (this.isClosed.get()) {
            throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.RESULT_SET_CLOSED, new Object[0]);
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        this.doClose();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.verifyOpen();
        return this.warnings;
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    protected void addWarning(SQLWarning warning) {
        LOGGER.warn(warning.getMessage());
        if (this.warnings == null) {
            this.warnings = warning;
            return;
        }
        this.warnings.setNextWarning(warning);
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.CANNOT_UNWRAP, iface.toString());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return null != iface && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.verifyOpen();
        return this.getRowIndex() == -1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.getRowIndex() >= this.getRowCount();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.verifyOpen();
        return this.getRowIndex() == 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.verifyOpen();
        return this.getDriverFetchSize();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.verifyOpen();
        if (rows < 0) {
            throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.INVALID_FETCH_SIZE, rows);
        }
        this.setDriverFetchSize(rows);
    }

    @Override
    public boolean isLast() throws SQLException {
        this.verifyOpen();
        return this.getRowIndex() == this.getRowCount() - 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.RESULT_FORWARD_ONLY, new Object[0]);
    }

    @Override
    public void afterLast() throws SQLException {
        this.verifyOpen();
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.RESULT_FORWARD_ONLY, new Object[0]);
    }

    @Override
    public boolean first() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.RESULT_FORWARD_ONLY, new Object[0]);
    }

    @Override
    public boolean last() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.RESULT_FORWARD_ONLY, new Object[0]);
    }

    @Override
    public int getRow() throws SQLException {
        return this.isBeforeFirst() || this.isAfterLast() ? 0 : this.getRowIndex() + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.verifyOpen();
        if (row < 1) {
            throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.INVALID_ROW_VALUE, new Object[0]);
        }
        if (this.getRow() > row) {
            throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.RESULT_FORWARD_ONLY, new Object[0]);
        }
        while (this.getRow() < row && this.next()) {
        }
        return !this.isBeforeFirst() && !this.isAfterLast();
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.RESULT_FORWARD_ONLY, new Object[0]);
        }
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, String.class.toString());
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Boolean.class.toString());
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Byte.class.toString());
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Short.class.toString());
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Integer.class.toString());
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Long.class.toString());
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Float.class.toString());
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, BigDecimal.class.toString());
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, String.class.toString());
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, BigDecimal.class.toString());
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Byte.class.toString());
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Date.class.toString());
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Time.class.toString());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Timestamp.class.toString());
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, InputStream.class.toString());
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, InputStream.class.toString());
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, InputStream.class.toString());
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Object.class.toString());
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, String.class.toString());
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Ref.class.toString());
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Blob.class.toString());
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Clob.class.toString());
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Array.class.toString());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Timestamp.class.toString());
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, URL.class.toString());
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, RowId.class.toString());
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, NClob.class.toString());
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Array.class.toString());
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, String.class.toString());
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Date.class.toString());
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Time.class.toString());
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Reader.class.toString());
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, Object.class.toString());
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_TYPE, String.class.toString());
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.findColumn(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.verifyOpen();
        if (rows < 0) {
            throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.RESULT_FORWARD_ONLY, new Object[0]);
        }
        int rowCopy = rows;
        while (rowCopy-- > 0) {
            if (this.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.RESULT_FORWARD_ONLY, new Object[0]);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_REFRESH_ROW, new Object[0]);
    }

    @Override
    public boolean previous() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.RESULT_FORWARD_ONLY, new Object[0]);
    }

    @Override
    public void insertRow() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void deleteRow() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int i1) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int i) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, int length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateClob(String columnLabel, Reader x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateClob(int columnIndex, Reader x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateClob(String columnLabel, Reader x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateLong(int columnIndex, long l) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateLong(String columnLabel, long l) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNClob(String columnLabel, Reader x, long length) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNClob(int columnIndex, Reader x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNClob(String columnLabel, Reader x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNString(int columnIndex, String x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNString(String columnLabel, String x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateRow() throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.READ_ONLY, new Object[0]);
    }
}

