/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.connection.SslSettings;
import com.mongodb.event.ServerMonitorListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.Certificate;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.util.CertificateUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.DocumentDbAllowDiskUseOption;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperty;
import software.amazon.documentdb.jdbc.DocumentDbMetadataScanMethod;
import software.amazon.documentdb.jdbc.DocumentDbReadPreference;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;

public class DocumentDbConnectionProperties
extends Properties {
    public static final String DOCUMENT_DB_SCHEME = "jdbc:documentdb:";
    public static final String USER_HOME_PROPERTY = "user.home";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DocumentDbConnectionProperties.class.getName());
    private static final String USER_HOME_PATH_NAME = System.getProperty("user.home");
    private static final String DOCUMENTDB_HOME_PATH_NAME = Paths.get(USER_HOME_PATH_NAME, ".documentdb").toString();
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("^\\s*$");
    private static final String ROOT_PEM_RESOURCE_FILE_NAME = "/rds-ca-2019-root.pem";
    public static final String HOME_PATH_PREFIX_REG_EXPR = "^~[/\\\\].*$";
    public static final int FETCH_SIZE_DEFAULT = 2000;
    public static final String DOCUMENTDB_CUSTOM_OPTIONS = "DOCUMENTDB_CUSTOM_OPTIONS";
    private static String classPathLocationName = null;
    private static String[] documentDbSearchPaths = null;
    private static final String DEFAULT_APPLICATION_NAME_KEY = "default.application.name";
    private static final String PROPERTIES_FILE_PATH = "/documentdb-jdbc.properties";
    static final String DEFAULT_APPLICATION_NAME;

    public DocumentDbConnectionProperties(Properties properties) {
        this.putAll((Map<?, ?>)properties);
    }

    public DocumentDbConnectionProperties() {
    }

    public static String[] getDocumentDbSearchPaths() {
        if (documentDbSearchPaths == null) {
            documentDbSearchPaths = new String[]{USER_HOME_PATH_NAME, DOCUMENTDB_HOME_PATH_NAME, DocumentDbConnectionProperties.getClassPathLocation()};
        }
        return (String[])documentDbSearchPaths.clone();
    }

    static String getUserHomePathName() {
        return USER_HOME_PATH_NAME;
    }

    static String getDocumentdbHomePathName() {
        return DOCUMENTDB_HOME_PATH_NAME;
    }

    static String getClassPathLocationName() {
        if (classPathLocationName == null) {
            classPathLocationName = DocumentDbConnectionProperties.getClassPathLocation();
        }
        return classPathLocationName;
    }

    private static String getClassPathLocation() {
        Path classParentPath;
        String classPathLocation = null;
        URL classPathLocationUrl = DocumentDbConnectionProperties.class.getProtectionDomain().getCodeSource().getLocation();
        Path classPath = null;
        try {
            classPath = Paths.get(classPathLocationUrl.getPath(), new String[0]);
        }
        catch (InvalidPathException e) {
            try {
                classPath = Paths.get(classPathLocationUrl.toURI());
            }
            catch (IllegalArgumentException | URISyntaxException ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (classPath != null && (classParentPath = classPath.getParent()) != null) {
            classPathLocation = classParentPath.toString();
        }
        return classPathLocation;
    }

    public String getHostname() {
        return this.getProperty(DocumentDbConnectionProperty.HOSTNAME.getName());
    }

    public void setHostname(String hostname) {
        this.setProperty(DocumentDbConnectionProperty.HOSTNAME.getName(), hostname);
    }

    public String getUser() {
        return this.getProperty(DocumentDbConnectionProperty.USER.getName());
    }

    public void setUser(String user) {
        this.setProperty(DocumentDbConnectionProperty.USER.getName(), user);
    }

    public String getPassword() {
        return this.getProperty(DocumentDbConnectionProperty.PASSWORD.getName());
    }

    public void setPassword(String password) {
        this.setProperty(DocumentDbConnectionProperty.PASSWORD.getName(), password);
    }

    public String getDatabase() {
        return this.getProperty(DocumentDbConnectionProperty.DATABASE.getName());
    }

    public void setDatabase(String database) {
        this.setProperty(DocumentDbConnectionProperty.DATABASE.getName(), database);
    }

    public String getApplicationName() {
        return this.getProperty(DocumentDbConnectionProperty.APPLICATION_NAME.getName(), DocumentDbConnectionProperty.APPLICATION_NAME.getDefaultValue());
    }

    public void setApplicationName(String applicationName) {
        this.setProperty(DocumentDbConnectionProperty.APPLICATION_NAME.getName(), applicationName);
    }

    public String getReplicaSet() {
        return this.getProperty(DocumentDbConnectionProperty.REPLICA_SET.getName());
    }

    public void setReplicaSet(String replicaSet) {
        this.setProperty(DocumentDbConnectionProperty.REPLICA_SET.getName(), replicaSet);
    }

    public boolean getTlsEnabled() {
        return Boolean.parseBoolean(this.getProperty(DocumentDbConnectionProperty.TLS_ENABLED.getName(), DocumentDbConnectionProperty.TLS_ENABLED.getDefaultValue()));
    }

    public void setTlsEnabled(String tlsEnabled) {
        this.setProperty(DocumentDbConnectionProperty.TLS_ENABLED.getName(), tlsEnabled);
    }

    public boolean getTlsAllowInvalidHostnames() {
        return Boolean.parseBoolean(this.getProperty(DocumentDbConnectionProperty.TLS_ALLOW_INVALID_HOSTNAMES.getName(), DocumentDbConnectionProperty.TLS_ALLOW_INVALID_HOSTNAMES.getDefaultValue()));
    }

    public void setTlsAllowInvalidHostnames(String allowInvalidHostnames) {
        this.setProperty(DocumentDbConnectionProperty.TLS_ALLOW_INVALID_HOSTNAMES.getName(), allowInvalidHostnames);
    }

    public Boolean getRetryReadsEnabled() {
        return Boolean.parseBoolean(this.getProperty(DocumentDbConnectionProperty.RETRY_READS_ENABLED.getName(), DocumentDbConnectionProperty.RETRY_READS_ENABLED.getDefaultValue()));
    }

    public void setRetryReadsEnabled(String retryReadsEnabled) {
        this.setProperty(DocumentDbConnectionProperty.RETRY_READS_ENABLED.getName(), retryReadsEnabled);
    }

    public Integer getLoginTimeout() {
        return this.getPropertyAsInteger(DocumentDbConnectionProperty.LOGIN_TIMEOUT_SEC.getName());
    }

    public void setLoginTimeout(String timeout) {
        this.setProperty(DocumentDbConnectionProperty.LOGIN_TIMEOUT_SEC.getName(), timeout);
    }

    public DocumentDbReadPreference getReadPreference() {
        return this.getPropertyAsReadPreference(DocumentDbConnectionProperty.READ_PREFERENCE.getName());
    }

    public void setReadPreference(String readPreference) {
        this.setProperty(DocumentDbConnectionProperty.READ_PREFERENCE.getName(), readPreference);
    }

    public DocumentDbMetadataScanMethod getMetadataScanMethod() {
        return this.getPropertyAsScanMethod(DocumentDbConnectionProperty.METADATA_SCAN_METHOD.getName());
    }

    public void setMetadataScanMethod(String method) {
        this.setProperty(DocumentDbConnectionProperty.METADATA_SCAN_METHOD.getName(), method);
    }

    public int getMetadataScanLimit() {
        return this.getPropertyAsInteger(DocumentDbConnectionProperty.METADATA_SCAN_LIMIT.getName());
    }

    public void setMetadataScanLimit(String limit) {
        this.setProperty(DocumentDbConnectionProperty.METADATA_SCAN_LIMIT.getName(), limit);
    }

    public String getSchemaName() {
        return this.getProperty(DocumentDbConnectionProperty.SCHEMA_NAME.getName(), DocumentDbConnectionProperty.SCHEMA_NAME.getDefaultValue());
    }

    public void setSchemaName(String schemaName) {
        this.setProperty(DocumentDbConnectionProperty.SCHEMA_NAME.getName(), schemaName);
    }

    public void setTlsCAFilePath(String tlsCAFilePath) {
        this.setProperty(DocumentDbConnectionProperty.TLS_CA_FILE.getName(), tlsCAFilePath);
    }

    public String getTlsCAFilePath() {
        return this.getProperty(DocumentDbConnectionProperty.TLS_CA_FILE.getName());
    }

    public void setSshUser(String sshUser) {
        this.setProperty(DocumentDbConnectionProperty.SSH_USER.getName(), sshUser);
    }

    public String getSshUser() {
        return this.getProperty(DocumentDbConnectionProperty.SSH_USER.getName());
    }

    public void setSshHostname(String sshHostname) {
        this.setProperty(DocumentDbConnectionProperty.SSH_HOSTNAME.getName(), sshHostname);
    }

    public String getSshHostname() {
        return this.getProperty(DocumentDbConnectionProperty.SSH_HOSTNAME.getName());
    }

    public void setSshPrivateKeyFile(String sshPrivateKeyFile) {
        this.setProperty(DocumentDbConnectionProperty.SSH_PRIVATE_KEY_FILE.getName(), sshPrivateKeyFile);
    }

    public String getSshPrivateKeyFile() {
        return this.getProperty(DocumentDbConnectionProperty.SSH_PRIVATE_KEY_FILE.getName());
    }

    public void setSshPrivateKeyPassphrase(String sshPrivateKeyPassphrase) {
        this.setProperty(DocumentDbConnectionProperty.SSH_PRIVATE_KEY_PASSPHRASE.getName(), sshPrivateKeyPassphrase);
    }

    public String getSshPrivateKeyPassphrase() {
        return this.getProperty(DocumentDbConnectionProperty.SSH_PRIVATE_KEY_PASSPHRASE.getName());
    }

    public void setSshStrictHostKeyChecking(String sshStrictHostKeyChecking) {
        this.setProperty(DocumentDbConnectionProperty.SSH_STRICT_HOST_KEY_CHECKING.getName(), String.valueOf(Boolean.parseBoolean(sshStrictHostKeyChecking)));
    }

    public boolean getSshStrictHostKeyChecking() {
        return Boolean.parseBoolean(this.getProperty(DocumentDbConnectionProperty.SSH_STRICT_HOST_KEY_CHECKING.getName(), DocumentDbConnectionProperty.SSH_STRICT_HOST_KEY_CHECKING.getDefaultValue()));
    }

    public void setSshKnownHostsFile(String sshKnownHostsFile) {
        this.setProperty(DocumentDbConnectionProperty.SSH_KNOWN_HOSTS_FILE.getName(), sshKnownHostsFile);
    }

    public String getSshKnownHostsFile() {
        return this.getProperty(DocumentDbConnectionProperty.SSH_KNOWN_HOSTS_FILE.getName());
    }

    public void setDefaultFetchSize(String defaultFetchSize) {
        this.setProperty(DocumentDbConnectionProperty.DEFAULT_FETCH_SIZE.getName(), defaultFetchSize);
    }

    public Integer getDefaultFetchSize() {
        return this.getPropertyAsInteger(DocumentDbConnectionProperty.DEFAULT_FETCH_SIZE.getName());
    }

    public void setRefreshSchema(String refreshSchema) {
        this.setProperty(DocumentDbConnectionProperty.REFRESH_SCHEMA.getName(), refreshSchema);
    }

    public Boolean getRefreshSchema() {
        return Boolean.parseBoolean(this.getProperty(DocumentDbConnectionProperty.REFRESH_SCHEMA.getName(), DocumentDbConnectionProperty.REFRESH_SCHEMA.getDefaultValue()));
    }

    public void setDefaultAuthenticationDatabase(String databaseName) {
        this.setProperty(DocumentDbConnectionProperty.DEFAULT_AUTH_DB.getName(), databaseName);
    }

    public String getDefaultAuthenticationDatabase() {
        return this.getProperty(DocumentDbConnectionProperty.DEFAULT_AUTH_DB.getName(), DocumentDbConnectionProperty.DEFAULT_AUTH_DB.getDefaultValue());
    }

    public void setAllowDiskUseOption(String allowDiskUseOption) {
        this.setProperty(DocumentDbConnectionProperty.ALLOW_DISK_USE.getName(), allowDiskUseOption);
    }

    public DocumentDbAllowDiskUseOption getAllowDiskUseOption() {
        return this.getPropertyAsAllowDiskUseOption(DocumentDbConnectionProperty.ALLOW_DISK_USE.getName());
    }

    public MongoClientSettings buildMongoClientSettings() {
        return this.buildMongoClientSettings(null);
    }

    public MongoClientSettings buildMongoClientSettings(int sshLocalPort) {
        return this.buildMongoClientSettings(null, sshLocalPort);
    }

    public MongoClientSettings buildMongoClientSettings(ServerMonitorListener serverMonitorListener) {
        return this.buildMongoClientSettings(serverMonitorListener, 0);
    }

    public MongoClientSettings buildMongoClientSettings(ServerMonitorListener serverMonitorListener, int sshLocalPort) {
        MongoClientSettings.Builder clientSettingsBuilder = MongoClientSettings.builder();
        String user = this.getUser();
        String password = this.getPassword();
        if (user != null && password != null) {
            MongoCredential credential = MongoCredential.createCredential((String)user, (String)this.getDefaultAuthenticationDatabase(), (char[])password.toCharArray());
            clientSettingsBuilder.credential(credential);
        }
        this.applyServerSettings(clientSettingsBuilder, serverMonitorListener);
        this.applyClusterSettings(clientSettingsBuilder, sshLocalPort);
        this.applySocketSettings(clientSettingsBuilder);
        this.applyTlsSettings(clientSettingsBuilder);
        DocumentDbReadPreference readPreference = this.getReadPreference();
        if (readPreference != null) {
            clientSettingsBuilder.readPreference(ReadPreference.valueOf((String)readPreference.getName()));
        }
        boolean retryReads = this.getRetryReadsEnabled();
        clientSettingsBuilder.applicationName(this.getApplicationName()).retryReads(retryReads).retryWrites(false).build();
        return clientSettingsBuilder.build();
    }

    public String buildSanitizedConnectionString() {
        String connectionStringTemplate = "//%s%s/%s%s";
        String loginInfo = DocumentDbConnectionProperties.isNullOrWhitespace(this.getUser()) ? "" : this.getUser() + "@";
        String hostInfo = DocumentDbConnectionProperties.isNullOrWhitespace(this.getHostname()) ? "" : this.getHostname();
        String databaseInfo = DocumentDbConnectionProperties.isNullOrWhitespace(this.getDatabase()) ? "" : this.getDatabase();
        StringBuilder optionalInfo = new StringBuilder();
        if (!this.getApplicationName().equals(DocumentDbConnectionProperty.APPLICATION_NAME.getDefaultValue())) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.APPLICATION_NAME, this.getApplicationName());
        }
        if (this.getLoginTimeout() != Integer.parseInt(DocumentDbConnectionProperty.LOGIN_TIMEOUT_SEC.getDefaultValue())) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.LOGIN_TIMEOUT_SEC, this.getLoginTimeout());
        }
        if (this.getMetadataScanLimit() != Integer.parseInt(DocumentDbConnectionProperty.METADATA_SCAN_LIMIT.getDefaultValue())) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.METADATA_SCAN_LIMIT, this.getMetadataScanLimit());
        }
        if (this.getMetadataScanMethod() != DocumentDbMetadataScanMethod.fromString(DocumentDbConnectionProperty.METADATA_SCAN_METHOD.getDefaultValue())) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.METADATA_SCAN_METHOD, this.getMetadataScanMethod().getName());
        }
        if (this.getRetryReadsEnabled() != Boolean.parseBoolean(DocumentDbConnectionProperty.RETRY_READS_ENABLED.getDefaultValue())) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.RETRY_READS_ENABLED, this.getRetryReadsEnabled());
        }
        if (this.getReadPreference() != null) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.READ_PREFERENCE, this.getReadPreference().getName());
        }
        if (this.getReplicaSet() != null) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.REPLICA_SET, this.getReplicaSet());
        }
        if (this.getTlsEnabled() != Boolean.parseBoolean(DocumentDbConnectionProperty.TLS_ENABLED.getDefaultValue())) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.TLS_ENABLED, this.getTlsEnabled());
        }
        if (this.getTlsAllowInvalidHostnames() != Boolean.parseBoolean(DocumentDbConnectionProperty.TLS_ALLOW_INVALID_HOSTNAMES.getDefaultValue())) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.TLS_ALLOW_INVALID_HOSTNAMES, this.getTlsAllowInvalidHostnames());
        }
        if (this.getTlsCAFilePath() != null) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.TLS_CA_FILE, this.getTlsCAFilePath());
        }
        if (!DocumentDbConnectionProperty.SCHEMA_NAME.getDefaultValue().equals(this.getSchemaName())) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.SCHEMA_NAME, this.getSchemaName());
        }
        if (this.getSshUser() != null) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.SSH_USER, this.getSshUser());
        }
        if (this.getSshHostname() != null) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.SSH_HOSTNAME, this.getSshHostname());
        }
        if (this.getSshPrivateKeyFile() != null) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.SSH_PRIVATE_KEY_FILE, this.getSshPrivateKeyFile());
        }
        if (this.getSshStrictHostKeyChecking() != Boolean.parseBoolean(DocumentDbConnectionProperty.SSH_STRICT_HOST_KEY_CHECKING.getDefaultValue())) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.SSH_STRICT_HOST_KEY_CHECKING, this.getSshStrictHostKeyChecking());
        }
        if (this.getSshKnownHostsFile() != null && !DocumentDbConnectionProperty.SSH_KNOWN_HOSTS_FILE.getDefaultValue().equals(this.getSshKnownHostsFile())) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.SSH_KNOWN_HOSTS_FILE, this.getSshKnownHostsFile());
        }
        if (this.getDefaultFetchSize() != Integer.parseInt(DocumentDbConnectionProperty.DEFAULT_FETCH_SIZE.getDefaultValue())) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.DEFAULT_FETCH_SIZE, this.getDefaultFetchSize());
        }
        if (this.getRefreshSchema() != Boolean.parseBoolean(DocumentDbConnectionProperty.REFRESH_SCHEMA.getDefaultValue())) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.REFRESH_SCHEMA, this.getRefreshSchema());
        }
        if (this.getDefaultAuthenticationDatabase() != null && !DocumentDbConnectionProperty.DEFAULT_AUTH_DB.getDefaultValue().equals(this.getDefaultAuthenticationDatabase())) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.DEFAULT_AUTH_DB, this.getDefaultAuthenticationDatabase());
        }
        if (this.getAllowDiskUseOption() != DocumentDbAllowDiskUseOption.fromString(DocumentDbConnectionProperty.ALLOW_DISK_USE.getDefaultValue())) {
            this.appendOption(optionalInfo, DocumentDbConnectionProperty.ALLOW_DISK_USE, this.getAllowDiskUseOption().getName());
        }
        return String.format("//%s%s/%s%s", loginInfo, hostInfo, databaseInfo, optionalInfo);
    }

    private void appendOption(StringBuilder optionInfo, DocumentDbConnectionProperty option, Object optionValue) {
        optionInfo.append(optionInfo.length() == 0 ? "?" : "&");
        optionInfo.append(option.getName()).append("=").append(optionValue);
    }

    public void validateRequiredProperties() throws SQLException {
        if (DocumentDbConnectionProperties.isNullOrWhitespace(this.getUser()) || DocumentDbConnectionProperties.isNullOrWhitespace(this.getPassword())) {
            throw SqlError.createSQLException(LOGGER, SqlState.INVALID_PARAMETER_VALUE, SqlError.MISSING_USER_PASSWORD, new Object[0]);
        }
        if (DocumentDbConnectionProperties.isNullOrWhitespace(this.getDatabase())) {
            throw SqlError.createSQLException(LOGGER, SqlState.INVALID_PARAMETER_VALUE, SqlError.MISSING_DATABASE, new Object[0]);
        }
        if (DocumentDbConnectionProperties.isNullOrWhitespace(this.getHostname())) {
            throw SqlError.createSQLException(LOGGER, SqlState.INVALID_PARAMETER_VALUE, SqlError.MISSING_HOSTNAME, new Object[0]);
        }
    }

    public static DocumentDbConnectionProperties getPropertiesFromConnectionString(String documentDbUrl) throws SQLException {
        return DocumentDbConnectionProperties.getPropertiesFromConnectionString(new Properties(), documentDbUrl, DOCUMENT_DB_SCHEME);
    }

    public static DocumentDbConnectionProperties getPropertiesFromConnectionString(Properties info, String documentDbUrl, String connectionStringPrefix) throws SQLException {
        DocumentDbConnectionProperties properties = new DocumentDbConnectionProperties(info);
        String postSchemeSuffix = documentDbUrl.substring(connectionStringPrefix.length());
        if (!DocumentDbConnectionProperties.isNullOrWhitespace(postSchemeSuffix)) {
            try {
                URI uri = new URI(postSchemeSuffix);
                DocumentDbConnectionProperties.setHostName(properties, uri);
                DocumentDbConnectionProperties.setUserPassword(properties, uri);
                DocumentDbConnectionProperties.setDatabase(properties, uri);
                DocumentDbConnectionProperties.setOptionalProperties(properties, uri);
                DocumentDbConnectionProperties.setCustomOptions(properties);
            }
            catch (URISyntaxException e) {
                throw SqlError.createSQLException(LOGGER, SqlState.CONNECTION_FAILURE, SqlError.INVALID_CONNECTION_PROPERTIES, documentDbUrl);
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException(e.getMessage(), e);
            }
        }
        properties.validateRequiredProperties();
        return properties;
    }

    static void setCustomOptions(DocumentDbConnectionProperties properties) {
        String[] propertyPairs;
        String customOptions = System.getenv(DOCUMENTDB_CUSTOM_OPTIONS);
        if (customOptions == null) {
            return;
        }
        for (String pair : propertyPairs = customOptions.split(";")) {
            int splitIndex = pair.indexOf("=");
            String key = pair.substring(0, splitIndex);
            String value = pair.substring(1 + splitIndex);
            DocumentDbConnectionProperties.addPropertyIfValid(properties, key, value, true, true);
        }
    }

    private static void setDatabase(Properties properties, URI mongoUri) throws SQLException {
        if (DocumentDbConnectionProperties.isNullOrWhitespace(mongoUri.getPath())) {
            if (properties.getProperty(DocumentDbConnectionProperty.DATABASE.getName(), null) == null) {
                throw SqlError.createSQLException(LOGGER, SqlState.CONNECTION_FAILURE, SqlError.MISSING_DATABASE, new Object[0]);
            }
            return;
        }
        String database = mongoUri.getPath().substring(1);
        DocumentDbConnectionProperties.addPropertyIfNotSet(properties, DocumentDbConnectionProperty.DATABASE.getName(), database);
    }

    private static void setOptionalProperties(Properties properties, URI mongoUri) throws UnsupportedEncodingException {
        String[] propertyPairs;
        String query = mongoUri.getQuery();
        if (DocumentDbConnectionProperties.isNullOrWhitespace(query)) {
            return;
        }
        for (String pair : propertyPairs = query.split("&")) {
            int splitIndex = pair.indexOf("=");
            String key = pair.substring(0, splitIndex);
            String value = pair.substring(1 + splitIndex);
            DocumentDbConnectionProperties.addPropertyIfValid(properties, key, value, false, false);
        }
    }

    private static void setUserPassword(Properties properties, URI mongoUri) throws UnsupportedEncodingException, SQLException {
        if (mongoUri.getUserInfo() == null) {
            if (properties.getProperty(DocumentDbConnectionProperty.USER.getName(), null) == null || properties.getProperty(DocumentDbConnectionProperty.PASSWORD.getName(), null) == null) {
                throw SqlError.createSQLException(LOGGER, SqlState.CONNECTION_FAILURE, SqlError.MISSING_USER_PASSWORD, new Object[0]);
            }
            return;
        }
        String userPassword = mongoUri.getUserInfo();
        int userPasswordSeparatorIndex = userPassword.indexOf(":");
        if (userPasswordSeparatorIndex >= 0) {
            DocumentDbConnectionProperties.addPropertyIfNotSet(properties, DocumentDbConnectionProperty.USER.getName(), userPassword.substring(0, userPasswordSeparatorIndex));
            DocumentDbConnectionProperties.addPropertyIfNotSet(properties, DocumentDbConnectionProperty.PASSWORD.getName(), userPassword.substring(userPasswordSeparatorIndex + 1));
        } else {
            DocumentDbConnectionProperties.addPropertyIfNotSet(properties, DocumentDbConnectionProperty.USER.getName(), userPassword);
        }
    }

    private static void setHostName(Properties properties, URI mongoUri) throws SQLException {
        String hostName = mongoUri.getHost();
        if (hostName == null) {
            if (properties.getProperty(DocumentDbConnectionProperty.HOSTNAME.getName(), null) == null) {
                throw SqlError.createSQLException(LOGGER, SqlState.CONNECTION_FAILURE, SqlError.MISSING_HOSTNAME, new Object[0]);
            }
            return;
        }
        if (mongoUri.getPort() > 0) {
            hostName = hostName + ":" + mongoUri.getPort();
        }
        DocumentDbConnectionProperties.addPropertyIfNotSet(properties, DocumentDbConnectionProperty.HOSTNAME.getName(), hostName);
    }

    private static void addPropertyIfValid(Properties info, String propertyKey, String propertyValue, boolean allowUnsupported, boolean allowUnknown) {
        if (DocumentDbConnectionProperty.isSupportedProperty(propertyKey)) {
            DocumentDbConnectionProperties.addPropertyIfNotSet(info, propertyKey, propertyValue);
        } else if (DocumentDbConnectionProperty.isUnsupportedMongoDBProperty(propertyKey)) {
            if (allowUnsupported) {
                LOGGER.warn("Adding unsupported MongoDB property: {{}} it may not supported by the driver or server.", (Object)propertyKey);
                DocumentDbConnectionProperties.addPropertyIfNotSet(info, propertyKey, propertyValue);
            } else {
                LOGGER.warn("Ignored MongoDB property: {{}} as it not supported by the driver.", (Object)propertyKey);
            }
        } else if (allowUnknown) {
            LOGGER.warn("Adding unknown MongoDB property: {{}} it may not supported by the driver or server.", (Object)propertyKey);
            DocumentDbConnectionProperties.addPropertyIfNotSet(info, propertyKey, propertyValue);
        } else {
            LOGGER.warn("Ignored invalid property: {{}}", (Object)propertyKey);
        }
    }

    private static void addPropertyIfNotSet(@NonNull Properties info, @NonNull String key, @Nullable String value) {
        if (!DocumentDbConnectionProperties.isNullOrWhitespace(value)) {
            info.putIfAbsent(key, value);
        }
    }

    private void applyServerSettings(MongoClientSettings.Builder clientSettingsBuilder, ServerMonitorListener serverMonitorListener) {
        clientSettingsBuilder.applyToServerSettings(b -> {
            if (serverMonitorListener != null) {
                b.addServerMonitorListener(serverMonitorListener);
            }
        });
    }

    private void applyClusterSettings(MongoClientSettings.Builder clientSettingsBuilder, int sshLocalPort) {
        String host = this.enableSshTunnel() && this.isSshPrivateKeyFileExists() && sshLocalPort > 0 ? String.format("localhost:%d", sshLocalPort) : this.getHostname();
        String replicaSetName = this.getReplicaSet();
        clientSettingsBuilder.applyToClusterSettings(b -> {
            if (host != null) {
                b.hosts(Collections.singletonList(new ServerAddress(host)));
            }
            if (replicaSetName != null) {
                b.requiredReplicaSetName(replicaSetName);
            }
        });
    }

    public boolean enableSshTunnel() {
        return !DocumentDbConnectionProperties.isNullOrWhitespace(this.getSshUser()) && !DocumentDbConnectionProperties.isNullOrWhitespace(this.getSshHostname()) && !DocumentDbConnectionProperties.isNullOrWhitespace(this.getSshPrivateKeyFile());
    }

    public boolean isSshPrivateKeyFileExists() {
        return Files.exists(DocumentDbConnectionProperties.getPath(this.getSshPrivateKeyFile(), DocumentDbConnectionProperties.getDocumentDbSearchPaths()), new LinkOption[0]);
    }

    private void applySocketSettings(MongoClientSettings.Builder clientSettingsBuilder) {
        Integer connectTimeout = this.getLoginTimeout();
        clientSettingsBuilder.applyToSocketSettings(b -> {
            if (connectTimeout != null) {
                b.connectTimeout(connectTimeout.intValue(), TimeUnit.SECONDS);
            }
        });
    }

    private void applyTlsSettings(MongoClientSettings.Builder clientSettingsBuilder) {
        clientSettingsBuilder.applyToSslSettings(this::applyToSslSettings);
    }

    private void applyToSslSettings(SslSettings.Builder builder) {
        boolean tlsEnabled = this.getTlsEnabled();
        boolean tlsAllowInvalidHostnames = this.getTlsAllowInvalidHostnames();
        builder.enabled(tlsEnabled).invalidHostNameAllowed(tlsAllowInvalidHostnames);
        if (!tlsEnabled) {
            return;
        }
        this.applyCertificateAuthorities(builder);
    }

    private void applyCertificateAuthorities(SslSettings.Builder builder) throws IOException, SQLException {
        ArrayList<Certificate> caCertificates = new ArrayList<Certificate>();
        this.appendEmbeddedAndOptionalCaCertificates(caCertificates);
        caCertificates.addAll(CertificateUtils.getSystemTrustedCertificates());
        caCertificates.addAll(CertificateUtils.getJdkTrustedCertificates());
        SSLContext sslContext = SSLFactory.builder().withTrustMaterial(caCertificates).build().getSslContext();
        builder.context(sslContext);
    }

    @VisibleForTesting
    void appendEmbeddedAndOptionalCaCertificates(List<Certificate> caCertificates) throws IOException, SQLException {
        if (!Strings.isNullOrEmpty((String)this.getTlsCAFilePath())) {
            String tlsCAFileName = this.getTlsCAFilePath();
            Path tlsCAFileNamePath = DocumentDbConnectionProperties.getPath(tlsCAFileName, DocumentDbConnectionProperties.getDocumentDbSearchPaths());
            if (tlsCAFileNamePath.toFile().exists()) {
                try (InputStream inputStream = Files.newInputStream(tlsCAFileNamePath, new OpenOption[0]);){
                    caCertificates.addAll(CertificateUtils.loadCertificate((InputStream[])new InputStream[]{inputStream}));
                }
            } else {
                throw SqlError.createSQLException(LOGGER, SqlState.INVALID_PARAMETER_VALUE, SqlError.TLS_CA_FILE_NOT_FOUND, tlsCAFileNamePath);
            }
        }
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream(ROOT_PEM_RESOURCE_FILE_NAME);){
            caCertificates.addAll(CertificateUtils.loadCertificate((InputStream[])new InputStream[]{resourceAsStream}));
        }
    }

    public static Path getPath(String filePath, String ... searchFolders) {
        if (filePath.matches(HOME_PATH_PREFIX_REG_EXPR)) {
            String fromHomePath = filePath.replaceFirst("~", Matcher.quoteReplacement(USER_HOME_PATH_NAME));
            return Paths.get(fromHomePath, new String[0]).toAbsolutePath();
        }
        Path origFilePath = Paths.get(filePath, new String[0]);
        if (origFilePath.isAbsolute()) {
            return origFilePath;
        }
        for (String searchFolder : searchFolders) {
            if (searchFolder == null) continue;
            Path testPath = Paths.get(searchFolder, filePath);
            if (!testPath.toAbsolutePath().toFile().exists()) continue;
            return testPath;
        }
        return Paths.get(filePath, new String[0]).toAbsolutePath();
    }

    private DocumentDbReadPreference getPropertyAsReadPreference(@NonNull String key) {
        DocumentDbReadPreference property = null;
        try {
            if (this.getProperty(key) != null) {
                property = DocumentDbReadPreference.fromString(this.getProperty(key));
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Property {{}} was ignored as it was not a valid read preference.", (Object)key, (Object)e);
        }
        return property;
    }

    private DocumentDbMetadataScanMethod getPropertyAsScanMethod(@NonNull String key) {
        DocumentDbMetadataScanMethod property = null;
        try {
            if (this.getProperty(key) != null) {
                property = DocumentDbMetadataScanMethod.fromString(this.getProperty(key));
            } else if (DocumentDbConnectionProperty.getPropertyFromKey(key) != null) {
                property = DocumentDbMetadataScanMethod.fromString(DocumentDbConnectionProperty.getPropertyFromKey(key).getDefaultValue());
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Property {{}} was ignored as it was not a valid read preference.", (Object)key, (Object)e);
        }
        return property;
    }

    private DocumentDbAllowDiskUseOption getPropertyAsAllowDiskUseOption(@NonNull String key) {
        DocumentDbAllowDiskUseOption property = null;
        try {
            if (this.getProperty(key) != null) {
                property = DocumentDbAllowDiskUseOption.fromString(this.getProperty(key));
            } else if (DocumentDbConnectionProperty.getPropertyFromKey(key) != null) {
                property = DocumentDbAllowDiskUseOption.fromString(DocumentDbConnectionProperty.getPropertyFromKey(key).getDefaultValue());
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Property {{}} was ignored as it was not a valid allow disk use option.", (Object)key, (Object)e);
        }
        return property;
    }

    private Long getPropertyAsLong(@NonNull String key) {
        Long property = null;
        try {
            if (this.getProperty(key) != null) {
                property = Long.parseLong(this.getProperty(key));
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Property {{}} was ignored as it was not of type long.", (Object)key, (Object)e);
        }
        return property;
    }

    private Integer getPropertyAsInteger(@NonNull String key) {
        Integer property = null;
        try {
            if (this.getProperty(key) != null) {
                property = Integer.parseInt(this.getProperty(key));
            } else if (DocumentDbConnectionProperty.getPropertyFromKey(key) != null) {
                property = Integer.parseInt(DocumentDbConnectionProperty.getPropertyFromKey(key).getDefaultValue());
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Property {{}} was ignored as it was not of type integer.", (Object)key, (Object)e);
        }
        return property;
    }

    public static boolean isNullOrWhitespace(@Nullable String value) {
        return value == null || WHITE_SPACE_PATTERN.matcher(value).matches();
    }

    static {
        String defaultAppName = "";
        try (InputStream is = DocumentDbConnectionProperties.class.getResourceAsStream(PROPERTIES_FILE_PATH);){
            Properties p = new Properties();
            p.load(is);
            defaultAppName = p.getProperty(DEFAULT_APPLICATION_NAME_KEY);
        }
        catch (Exception e) {
            LOGGER.error("Error loading default application name: " + e.getMessage());
        }
        DEFAULT_APPLICATION_NAME = defaultAppName;
    }
}

