/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.common;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Driver
implements java.sql.Driver {
    static final int DRIVER_MAJOR_VERSION;
    static final int DRIVER_MINOR_VERSION;
    static final String DRIVER_VERSION;
    static final String APP_NAME_SUFFIX;
    static final String APPLICATION_NAME;
    private static final Logger LOGGER;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getApplicationName() {
        try {
            String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
            boolean isWindows = System.getProperty("os.name").startsWith("Windows");
            if (isWindows) {
                Process process = Runtime.getRuntime().exec("tasklist /fi \"PID eq " + pid + "\" /fo csv /nh");
                try (BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                    String line = input.readLine();
                    if (line == null) return "Unknown";
                    String string = line.substring(1, line.indexOf(",") - 1);
                    return string;
                }
            }
            Process process = Runtime.getRuntime().exec("ps -eo pid,comm");
            try (BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                do {
                    if ((line = input.readLine()) == null) return "Unknown";
                } while (!(line = line.trim()).startsWith(pid));
                String string = line.substring(line.indexOf(" ") + 1);
                return string;
            }
        }
        catch (Exception err) {
            LOGGER.info("An exception has occurred and ignored while retrieving the caller application name: " + err.getLocalizedMessage());
        }
        return "Unknown";
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        LOGGER = LoggerFactory.getLogger(Driver.class);
        APPLICATION_NAME = Driver.getApplicationName();
        DRIVER_MAJOR_VERSION = 1;
        DRIVER_MINOR_VERSION = 1;
        APP_NAME_SUFFIX = "TODO";
        DRIVER_VERSION = "0.0.0";
    }
}

