/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.calcite.adapter;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.linq4j.tree.Types;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbTable;

public enum DocumentDbMethod {
    MONGO_QUERYABLE_AGGREGATE(DocumentDbTable.DocumentDbQueryable.class, "aggregate", List.class, List.class, List.class);

    private final Method method;
    public static final ImmutableMap<Method, DocumentDbMethod> MAP;

    public Method getMethod() {
        return this.method;
    }

    private DocumentDbMethod(Class clazz, String methodName, Class ... argumentTypes) {
        this.method = Types.lookupMethod((Class)clazz, (String)methodName, (Class[])argumentTypes);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DocumentDbMethod value : DocumentDbMethod.values()) {
            builder.put((Object)value.method, (Object)value);
        }
        MAP = builder.build();
    }
}

