/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.calcite.adapter;

import com.google.common.io.BaseEncoding;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.Month;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.bson.BsonType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperties;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbAggregate;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbFilter;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbJoin;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbProject;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbRel;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbSort;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;
import software.amazon.documentdb.jdbc.metadata.DocumentDbMetadataColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaTable;

public final class DocumentDbRules {
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    private static final Pattern OBJECT_ID_PATTERN = Pattern.compile("^[0-9a-zA-Z]{24}$");
    static final RelOptRule[] RULES = new RelOptRule[]{DocumentDbSortRule.INSTANCE, DocumentDbFilterRule.INSTANCE, DocumentDbProjectRule.INSTANCE, DocumentDbAggregateRule.INSTANCE, DocumentDbJoinRule.access$000()};
    public static final double PROJECT_COST_FACTOR = 0.1;
    public static final double FILTER_COST_FACTOR = 0.1;
    public static final double JOIN_COST_FACTOR = 0.1;
    public static final double SORT_COST_FACTOR = 0.05;
    public static final double ENUMERABLE_COST_FACTOR = 0.1;
    public static final int MAX_PROJECT_FIELDS = 50;

    private DocumentDbRules() {
    }

    static String isItem(RexCall call) {
        if (call.getOperator() != SqlStdOperatorTable.ITEM) {
            return null;
        }
        RexNode op0 = (RexNode)call.operands.get(0);
        RexNode op1 = (RexNode)call.operands.get(1);
        if (op0 instanceof RexInputRef && ((RexInputRef)op0).getIndex() == 0 && op1 instanceof RexLiteral && ((RexLiteral)op1).getValue2() instanceof String) {
            return (String)((RexLiteral)op1).getValue2();
        }
        return null;
    }

    static List<String> mongoFieldNames(final RelDataType rowType, final DocumentDbSchemaTable metadataTable, final boolean useOriginalPaths) {
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                String name = ((RelDataTypeField)rowType.getFieldList().get(index)).getName();
                DocumentDbSchemaColumn column = (DocumentDbSchemaColumn)metadataTable.getColumnMap().get((Object)name);
                if (column == null) {
                    return DocumentDbRules.getNormalizedIdentifier(name);
                }
                return DocumentDbRules.getPath(column, useOriginalPaths);
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        };
    }

    static String getPath(DocumentDbSchemaColumn column, boolean useOriginalPaths) {
        String path = column instanceof DocumentDbMetadataColumn && !DocumentDbConnectionProperties.isNullOrWhitespace(((DocumentDbMetadataColumn)column).getResolvedPath()) && !useOriginalPaths ? ((DocumentDbMetadataColumn)column).getResolvedPath() : (column.isIndex() ? column.getSqlName() : column.getFieldPath());
        if (DocumentDbConnectionProperties.isNullOrWhitespace(path)) {
            return null;
        }
        return path;
    }

    static List<String> mongoFieldNames(RelDataType rowType, DocumentDbSchemaTable metadataTable) {
        return DocumentDbRules.mongoFieldNames(rowType, metadataTable, false);
    }

    static String maybeQuote(String s) {
        if (!DocumentDbRules.needsQuote(s)) {
            return s;
        }
        return DocumentDbRules.quote(s);
    }

    static String quote(String s) {
        return "'" + s + "'";
    }

    private static boolean needsQuote(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (Character.isJavaIdentifierPart(c) && c != '$' && c != '.' && c != ':') continue;
            return true;
        }
        return false;
    }

    protected static String getNormalizedIdentifier(String fieldName) {
        return fieldName.startsWith("$") ? "_" + fieldName.substring(1) : fieldName;
    }

    private static <T> @NonNull T getValueAs(RexLiteral literal, Class<T> clazz) throws SQLException {
        Object result = literal.getValueAs(clazz);
        if (result == null) {
            throw SqlError.createSQLException(LOGGER, SqlState.INVALID_QUERY_EXPRESSION, SqlError.MISSING_LITERAL_VALUE, literal.getTypeName().getName());
        }
        return (T)result;
    }

    private static String stripQuotes(String s) {
        return s.startsWith("'") && s.endsWith("'") ? s.substring(1, s.length() - 1) : s;
    }

    private static Operand getMongoAggregateForOperator(RexCall call, List<Operand> strings, String stdOperator) {
        if (DocumentDbRules.hasObjectIdAndLiteral(call, strings)) {
            return new Operand(DocumentDbRules.getObjectIdAggregateForOperator(call, strings, stdOperator));
        }
        return new Operand("{" + DocumentDbRules.maybeQuote(stdOperator) + ": [" + Util.commaList(strings) + "]}");
    }

    private static Operand getIntegerDivisionOperation(String value, String divisor) {
        String modulo = String.format("{\"$mod\": [%s, %s]}", value, divisor);
        String subtractRemainder = String.format("{\"$subtract\": [%s, %s]}", value, modulo);
        return Operand.format("{\"$divide\": [%s, %s]}", subtractRemainder, divisor);
    }

    private static Operand getIntegerDivisionOperation(Operand value, Operand divisor) {
        return DocumentDbRules.getIntegerDivisionOperation(value.getAggregationValue(), divisor.getAggregationValue());
    }

    private static String getObjectIdAggregateForOperator(RexCall call, List<Operand> strings, String stdOperator) throws SQLException {
        String oidOperation = "{" + DocumentDbRules.maybeQuote(stdOperator) + ": [" + Util.commaList(DocumentDbRules.reformatObjectIdOperands(call, strings)) + "]}";
        String nativeOperation = "{" + DocumentDbRules.maybeQuote(stdOperator) + ": [" + Util.commaList(strings) + "]}";
        return "{\"$or\": [" + oidOperation + ", " + nativeOperation + "]}";
    }

    private static boolean hasObjectIdAndLiteral(RexCall call, List<Operand> strings) {
        Operand objectIdOperand = strings.stream().filter(operand -> operand.getColumn() != null && operand.getColumn().getDbType() == BsonType.OBJECT_ID).findFirst().orElse(null);
        if (objectIdOperand == null) {
            return false;
        }
        block6: for (int index = 0; index < strings.size(); ++index) {
            Operand operand2 = strings.get(index);
            if (operand2 == objectIdOperand || !(call.operands.get(index) instanceof RexLiteral)) continue;
            RexLiteral literal = (RexLiteral)call.operands.get(index);
            switch (literal.getTypeName()) {
                case BINARY: 
                case VARBINARY: {
                    byte[] valueAsByteArray = DocumentDbRules.getValueAs(literal, byte[].class);
                    if (valueAsByteArray.length != 12) continue block6;
                    return true;
                }
                case CHAR: 
                case VARCHAR: {
                    String valueAsString = DocumentDbRules.getValueAs(literal, String.class);
                    if (!OBJECT_ID_PATTERN.matcher(valueAsString).matches()) continue block6;
                    return true;
                }
            }
        }
        return false;
    }

    private static List<Operand> reformatObjectIdOperands(RexCall call, List<Operand> strings) throws SQLException {
        ArrayList<Operand> copyOfStrings = new ArrayList<Operand>();
        for (int index = 0; index < strings.size(); ++index) {
            Operand operand = strings.get(index);
            if (call.operands.get(index) instanceof RexLiteral) {
                RexLiteral literal = (RexLiteral)call.operands.get(index);
                copyOfStrings.add(DocumentDbRules.reformatObjectIdLiteral(literal, operand));
                continue;
            }
            copyOfStrings.add(operand);
        }
        return copyOfStrings;
    }

    private static Operand reformatObjectIdLiteral(RexLiteral literal, Operand operand) throws SQLException {
        switch (literal.getTypeName()) {
            case BINARY: 
            case VARBINARY: {
                byte[] valueAsByteArray = DocumentDbRules.getValueAs(literal, byte[].class);
                if (valueAsByteArray.length == 12) {
                    String value = "{\"$oid\": \"" + BaseEncoding.base16().encode(valueAsByteArray) + "\"}";
                    return new Operand(value, value, true);
                }
                return operand;
            }
            case CHAR: 
            case VARCHAR: {
                String valueAsString = DocumentDbRules.getValueAs(literal, String.class);
                if (OBJECT_ID_PATTERN.matcher(valueAsString).matches()) {
                    String value = "{\"$oid\": \"" + valueAsString + "\"}";
                    return new Operand(value, value, true);
                }
                return operand;
            }
        }
        return operand;
    }

    static class Operand {
        private final String aggregationValue;
        private final String queryValue;
        private final boolean isQuerySyntax;
        private final DocumentDbSchemaColumn column;

        public Operand(String aggregationValue) {
            this(aggregationValue, null, false, null);
        }

        public Operand(String aggregationValue, String queryValue, boolean isQuerySyntax) {
            this(aggregationValue, queryValue, isQuerySyntax, null);
        }

        public Operand(String aggregationValue, String queryValue, boolean isQuerySyntax, DocumentDbSchemaColumn column) {
            this.aggregationValue = aggregationValue;
            this.queryValue = queryValue;
            this.isQuerySyntax = isQuerySyntax;
            this.column = column;
        }

        public static Operand format(String format, Object ... args) {
            return new Operand(String.format(format, args));
        }

        public boolean isInputRef() {
            return this.column != null;
        }

        public String toString() {
            return this.aggregationValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof String) {
                String stringValue = (String)o;
                return stringValue.equals(this.getAggregationValue());
            }
            if (!(o instanceof Operand)) {
                return false;
            }
            Operand that = (Operand)o;
            return Objects.equals(this.getAggregationValue(), that.getAggregationValue());
        }

        public int hashCode() {
            return Objects.hash(this.getAggregationValue());
        }

        public String getAggregationValue() {
            return this.aggregationValue;
        }

        public String getQueryValue() {
            return this.queryValue;
        }

        public boolean isQuerySyntax() {
            return this.isQuerySyntax;
        }

        public DocumentDbSchemaColumn getColumn() {
            return this.column;
        }
    }

    private static class DocumentDbAggregateRule
    extends DocumentDbConverterRule {
        static final DocumentDbAggregateRule INSTANCE = (DocumentDbAggregateRule)ConverterRule.Config.INSTANCE.withConversion(LogicalAggregate.class, (RelTrait)Convention.NONE, (RelTrait)DocumentDbRel.CONVENTION, "DocumentDbAggregateRule").withRuleFactory(DocumentDbAggregateRule::new).toRule(DocumentDbAggregateRule.class);

        DocumentDbAggregateRule(ConverterRule.Config config) {
            super(config);
        }

        public RelNode convert(RelNode rel) {
            LogicalAggregate agg = (LogicalAggregate)rel;
            RelTraitSet traitSet = agg.getTraitSet().replace((RelTrait)this.out);
            try {
                return new DocumentDbAggregate(rel.getCluster(), traitSet, DocumentDbAggregateRule.convert((RelNode)agg.getInput(), (RelTraitSet)traitSet.simplify()), agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
            }
            catch (InvalidRelException e) {
                LOGGER.warn(e.toString());
                return null;
            }
        }
    }

    private static class DocumentDbJoinRule
    extends DocumentDbConverterRule {
        private static final DocumentDbJoinRule INSTANCE = (DocumentDbJoinRule)ConverterRule.Config.INSTANCE.withConversion(LogicalJoin.class, (RelTrait)Convention.NONE, (RelTrait)DocumentDbRel.CONVENTION, "DocumentDbJoinRule").withRuleFactory(DocumentDbJoinRule::new).toRule(DocumentDbJoinRule.class);

        protected DocumentDbJoinRule(ConverterRule.Config config) {
            super(config);
        }

        public RelNode convert(RelNode rel) {
            LogicalJoin join = (LogicalJoin)rel;
            RelTraitSet traitSet = join.getTraitSet().replace((RelTrait)this.out);
            return new DocumentDbJoin(join.getCluster(), traitSet, DocumentDbJoinRule.convert((RelNode)join.getLeft(), (RelTrait)this.out), DocumentDbJoinRule.convert((RelNode)join.getRight(), (RelTrait)this.out), join.getCondition(), join.getJoinType());
        }

        static /* synthetic */ DocumentDbJoinRule access$000() {
            return INSTANCE;
        }
    }

    private static class DocumentDbProjectRule
    extends DocumentDbConverterRule {
        static final DocumentDbProjectRule INSTANCE = (DocumentDbProjectRule)ConverterRule.Config.INSTANCE.withConversion(LogicalProject.class, (RelTrait)Convention.NONE, (RelTrait)DocumentDbRel.CONVENTION, "DocumentDbProjectRule").withRuleFactory(DocumentDbProjectRule::new).toRule(DocumentDbProjectRule.class);

        DocumentDbProjectRule(ConverterRule.Config config) {
            super(config);
        }

        public RelNode convert(RelNode rel) {
            LogicalProject project = (LogicalProject)rel;
            RelTraitSet traitSet = project.getTraitSet().replace((RelTrait)this.out);
            return new DocumentDbProject(project.getCluster(), traitSet, DocumentDbProjectRule.convert((RelNode)project.getInput(), (RelTrait)this.out), project.getProjects(), project.getRowType());
        }
    }

    private static class DocumentDbFilterRule
    extends DocumentDbConverterRule {
        static final DocumentDbFilterRule INSTANCE = (DocumentDbFilterRule)ConverterRule.Config.INSTANCE.withConversion(LogicalFilter.class, (RelTrait)Convention.NONE, (RelTrait)DocumentDbRel.CONVENTION, "DocumentDbFilterRule").withRuleFactory(DocumentDbFilterRule::new).toRule(DocumentDbFilterRule.class);

        DocumentDbFilterRule(ConverterRule.Config config) {
            super(config);
        }

        public RelNode convert(RelNode rel) {
            LogicalFilter filter = (LogicalFilter)rel;
            RelTraitSet traitSet = filter.getTraitSet().replace((RelTrait)this.out);
            return new DocumentDbFilter(rel.getCluster(), traitSet, DocumentDbFilterRule.convert((RelNode)filter.getInput(), (RelTrait)this.out), filter.getCondition());
        }
    }

    private static class DocumentDbSortRule
    extends DocumentDbConverterRule {
        static final DocumentDbSortRule INSTANCE = (DocumentDbSortRule)ConverterRule.Config.INSTANCE.withConversion(Sort.class, (RelTrait)Convention.NONE, (RelTrait)DocumentDbRel.CONVENTION, "DocumentDbSortRule").withRuleFactory(DocumentDbSortRule::new).toRule(DocumentDbSortRule.class);

        DocumentDbSortRule(ConverterRule.Config config) {
            super(config);
        }

        public RelNode convert(RelNode rel) {
            Sort sort = (Sort)rel;
            RelTraitSet traitSet = sort.getTraitSet().replace((RelTrait)this.out).replace((RelTrait)sort.getCollation());
            return new DocumentDbSort(rel.getCluster(), traitSet, DocumentDbSortRule.convert((RelNode)sort.getInput(), (RelTraitSet)traitSet.replace((RelTrait)RelCollations.EMPTY)), sort.getCollation(), sort.offset, sort.fetch);
        }
    }

    static abstract class DocumentDbConverterRule
    extends ConverterRule {
        protected DocumentDbConverterRule(ConverterRule.Config config) {
            super(config);
        }
    }

    private static class StringFunctionTranslator {
        private static final Map<SqlOperator, String> STRING_OPERATORS = new HashMap<SqlOperator, String>();

        private StringFunctionTranslator() {
        }

        private static Operand getMongoAggregateForSubstringOperator(RexCall call, List<Operand> strings) {
            ArrayList<Operand> inputs = new ArrayList<Operand>(strings);
            inputs.set(1, new Operand("{\"$subtract\": [" + inputs.get(1) + ", 1]}"));
            if (inputs.size() == 2) {
                inputs.add(new Operand(String.valueOf(Integer.MAX_VALUE)));
            }
            return new Operand("{" + STRING_OPERATORS.get(SqlStdOperatorTable.SUBSTRING) + ": [" + Util.commaList(inputs) + "]}");
        }

        private static Operand getMongoAggregateForConcatOperator(RexCall call, List<Operand> strings) {
            List inputs = strings.stream().map(string -> call.getOperator() == SqlLibraryOperators.CONCAT_FUNCTION ? "{\"$ifNull\": [" + string + ", \"\" ]}" : string.toString()).collect(Collectors.toList());
            return new Operand("{" + STRING_OPERATORS.get(SqlStdOperatorTable.CONCAT) + ": [" + Util.commaList(inputs) + "]}");
        }

        private static Operand getMongoAggregateForPositionStringOperator(RexCall call, List<Operand> strings) {
            ArrayList<String> args = new ArrayList<String>();
            StringBuilder operand = new StringBuilder();
            StringBuilder finish = new StringBuilder();
            args.add("{" + STRING_OPERATORS.get(SqlStdOperatorTable.LOWER) + ":" + strings.get(1) + "}");
            args.add("{" + STRING_OPERATORS.get(SqlStdOperatorTable.LOWER) + ":" + strings.get(0) + "}");
            operand.append("{\"$cond\": [" + RexToMongoTranslator.getNullCheckExpr(strings) + ", ");
            if (strings.size() == 3) {
                args.add("{\"$subtract\": [" + strings.get(2) + ", 1]}");
                operand.append("{\"$cond\": [{\"$lte\": [" + strings.get(2) + ", 0]}, 0, ");
                finish.append("]}");
            }
            operand.append("{\"$add\": [{" + STRING_OPERATORS.get(SqlStdOperatorTable.POSITION) + ": [" + Util.commaList(args) + "]}, 1]}");
            operand.append((CharSequence)finish);
            operand.append(", null ]}");
            return new Operand(operand.toString());
        }

        private static Operand getMongoAggregateForStringOperator(RexCall call, List<Operand> strings) {
            return new Operand("{\"$cond\": [" + RexToMongoTranslator.getNullCheckExpr(strings) + ", {" + STRING_OPERATORS.get(call.getOperator()) + ": " + strings.get(0) + "}, null]}");
        }

        private static Operand getMongoAggregateForLeftOperator(RexCall call, List<Operand> strings) {
            ArrayList<Operand> inputs = new ArrayList<Operand>();
            inputs.add(strings.get(0));
            inputs.add(new Operand("0"));
            inputs.add(strings.get(1));
            return new Operand("{\"$cond\": [{\"$and\": [" + RexToMongoTranslator.getNullCheckExpr(strings) + ", {\"$gte\":[" + strings.get(1) + ", 0]}]}, {" + STRING_OPERATORS.get(SqlStdOperatorTable.SUBSTRING) + ": [" + Util.commaList(inputs) + "]}, null]}");
        }

        private static Operand getMongoAggregateForRightOperator(RexCall call, List<Operand> strings) {
            ArrayList<Operand> inputs = new ArrayList<Operand>();
            inputs.add(strings.get(0));
            inputs.add(new Operand("{\"$subtract\": [ {" + STRING_OPERATORS.get(SqlStdOperatorTable.CHAR_LENGTH) + ":" + strings.get(0) + "}, " + strings.get(1) + "]}"));
            inputs.add(strings.get(1));
            return new Operand("{\"$cond\": [{\"$and\": [" + RexToMongoTranslator.getNullCheckExpr(strings) + ", {\"$gte\":[" + strings.get(1) + ", 0]}]}, {\"$cond\": [ {\"$lte\": [{" + STRING_OPERATORS.get(SqlStdOperatorTable.CHAR_LENGTH) + ":" + strings.get(0) + "}, " + strings.get(1) + "]}, " + strings.get(0) + ", {" + STRING_OPERATORS.get(SqlStdOperatorTable.SUBSTRING) + ": [" + Util.commaList(inputs) + "]}]}, null]}");
        }

        static {
            STRING_OPERATORS.put((SqlOperator)SqlStdOperatorTable.CONCAT, "$concat");
            STRING_OPERATORS.put((SqlOperator)SqlStdOperatorTable.LOWER, "$toLower");
            STRING_OPERATORS.put((SqlOperator)SqlStdOperatorTable.UPPER, "$toUpper");
            STRING_OPERATORS.put((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, "$strLenCP");
            STRING_OPERATORS.put((SqlOperator)SqlStdOperatorTable.SUBSTRING, "$substrCP");
            STRING_OPERATORS.put((SqlOperator)SqlStdOperatorTable.POSITION, "$indexOfCP");
        }
    }

    private static class SimpleMatchTranslator {
        private static final Map<SqlOperator, String> REVERSE_OPERATORS = new HashMap<SqlOperator, String>();

        private SimpleMatchTranslator() {
        }

        private static String getObjectIdComparisonOperator(RexCall call, List<Operand> strings, String stdOperator) throws SQLException {
            String nativeOperation = SimpleMatchTranslator.getComparisonOperator(call, strings, stdOperator);
            String oidOperation = SimpleMatchTranslator.getComparisonOperator(call, DocumentDbRules.reformatObjectIdOperands(call, strings), stdOperator);
            if (nativeOperation != null && oidOperation != null) {
                return "{\"$or\": [" + oidOperation + ", " + nativeOperation + "]}";
            }
            return null;
        }

        private static String getComparisonOperator(RexCall call, List<Operand> strings, String stdOperator) {
            if (call.isA(SqlKind.NOT) && strings.get(0).isInputRef()) {
                return "{" + strings.get(0).getQueryValue() + ": false}";
            }
            if (strings.size() == 2) {
                Operand left = strings.get(0);
                Operand right = strings.get(1);
                String reverseOp = REVERSE_OPERATORS.get(call.getOperator());
                String simpleComparison = SimpleMatchTranslator.formatSimpleBinaryComparison(stdOperator, left, right);
                if (simpleComparison != null) {
                    return simpleComparison;
                }
                return SimpleMatchTranslator.formatSimpleBinaryComparison(reverseOp, right, left);
            }
            return null;
        }

        private static String getAndOrOperator(List<Operand> operands, String op) {
            StringBuilder simple = new StringBuilder();
            simple.append("{").append(op).append(": [");
            for (Operand value : operands) {
                if (value.getQueryValue() == null) {
                    return null;
                }
                simple.append(value.isInputRef() ? "{" + value.getQueryValue() + ": true}" : value.getQueryValue());
                simple.append(",");
            }
            simple.deleteCharAt(simple.length() - 1);
            simple.append("]}");
            return simple.toString();
        }

        private static String formatSimpleBinaryComparison(String op, Operand leftOperand, Operand rightOperand) {
            if (leftOperand.isInputRef() && rightOperand.isQuerySyntax() && leftOperand.getQueryValue() != null && rightOperand.getQueryValue() != null) {
                String comparison = "{" + leftOperand.getQueryValue() + ": {" + op + ": " + rightOperand.getQueryValue() + "}}";
                if (op.equals(RexToMongoTranslator.MONGO_OPERATORS.get(SqlStdOperatorTable.NOT_EQUALS))) {
                    comparison = "{" + leftOperand.getQueryValue() + ": {$nin: [null, " + rightOperand.getQueryValue() + "]}}";
                }
                return comparison;
            }
            return null;
        }

        private static String getNullCheckOperator(RexCall call, List<Operand> operands) {
            String op = call.getOperator() == SqlStdOperatorTable.IS_NULL ? "$eq" : "$ne";
            return operands.get(0).isInputRef() ? "{" + operands.get(0).getQueryValue() + ": {" + op + ": null }}" : null;
        }

        static {
            REVERSE_OPERATORS.put((SqlOperator)SqlStdOperatorTable.EQUALS, "$eq");
            REVERSE_OPERATORS.put((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, "$ne");
            REVERSE_OPERATORS.put((SqlOperator)SqlStdOperatorTable.GREATER_THAN, "$lte");
            REVERSE_OPERATORS.put((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, "$lt");
            REVERSE_OPERATORS.put((SqlOperator)SqlStdOperatorTable.LESS_THAN, "$gte");
            REVERSE_OPERATORS.put((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, "$gt");
        }
    }

    private static class DateFunctionTranslator {
        private static final Map<TimeUnitRange, String> DATE_PART_OPERATORS = new HashMap<TimeUnitRange, String>();
        private static final Instant FIRST_DAY_OF_WEEK_AFTER_EPOCH = Instant.parse("1970-01-05T00:00:00Z");

        private DateFunctionTranslator() {
        }

        private static Operand translateCurrentTimestamp(Instant currentTime) {
            String currentTimestamp = "{\"$date\": {\"$numberLong\": \"" + currentTime.toEpochMilli() + "\"}}";
            return new Operand(currentTimestamp, currentTimestamp, true);
        }

        private static Operand translateDateAdd(RexCall call, List<Operand> strings) {
            DateFunctionTranslator.verifySupportedDateAddType((RexNode)call.getOperands().get(1));
            return new Operand("{ \"$add\":[" + Util.commaList(strings) + "]}");
        }

        private static void verifySupportedDateAddType(RexNode node) throws SQLFeatureNotSupportedException {
            if (node.getType().getSqlTypeName() == SqlTypeName.INTERVAL_MONTH || node.getType().getSqlTypeName() == SqlTypeName.INTERVAL_YEAR) {
                throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_CONVERSION, node.getType().getSqlTypeName().getName(), SqlTypeName.TIMESTAMP.getName());
            }
        }

        private static Operand translateDateDiff(RexCall call, List<Operand> strings) {
            TimeUnitRange interval = DateFunctionTranslator.getIntervalQualifier((RexCall)call).timeUnitRange;
            switch (interval) {
                case YEAR: {
                    return DateFunctionTranslator.formatDateDiffYear(strings);
                }
                case QUARTER: 
                case MONTH: {
                    return DateFunctionTranslator.formatDateDiffMonth(strings, interval);
                }
            }
            return DocumentDbRules.getMongoAggregateForOperator(call, strings, (String)RexToMongoTranslator.MONGO_OPERATORS.get(SqlStdOperatorTable.MINUS_DATE));
        }

        private static @NonNull SqlIntervalQualifier getIntervalQualifier(RexCall call) throws SQLException {
            SqlIntervalQualifier result = call.getType().getIntervalQualifier();
            if (result == null) {
                throw SqlError.createSQLException(LOGGER, SqlState.INVALID_QUERY_EXPRESSION, SqlError.MISSING_LITERAL_VALUE, call.getType().getSqlTypeName().getName());
            }
            return result;
        }

        private static Operand formatDateDiffYear(List<Operand> strings) {
            String dateDiffYearFormat = "{'$subtract': [{'$year': %1$s}, {'$year': %2$s}]}";
            return Operand.format("{'$subtract': [{'$year': %1$s}, {'$year': %2$s}]}", strings.get(0), strings.get(1));
        }

        private static Operand formatDateDiffMonth(List<Operand> strings, TimeUnitRange timeUnitRange) {
            String yearPartMultiplier = timeUnitRange == TimeUnitRange.QUARTER ? "4" : "12";
            String monthPart1 = timeUnitRange == TimeUnitRange.QUARTER ? DateFunctionTranslator.translateExtractQuarter(strings.get(0)).getAggregationValue() : String.format("{'$month': %s}", strings.get(0));
            String monthPart2 = timeUnitRange == TimeUnitRange.QUARTER ? DateFunctionTranslator.translateExtractQuarter(strings.get(1)).getAggregationValue() : String.format("{'$month': %s}", strings.get(1));
            String dateDiffMonthFormat = "{'$subtract': [ {'$add': [ {'$multiply': [%1$s, {'$year': %2$s}]}, %4$s]}, {'$add': [ {'$multiply': [%1$s, {'$year': %3$s}]}, %5$s]}]}";
            return Operand.format("{'$subtract': [ {'$add': [ {'$multiply': [%1$s, {'$year': %2$s}]}, %4$s]}, {'$add': [ {'$multiply': [%1$s, {'$year': %3$s}]}, %5$s]}]}", yearPartMultiplier, strings.get(0), strings.get(1), monthPart1, monthPart2);
        }

        private static Operand translateExtract(RexCall call, List<Operand> strings) {
            RexLiteral literal = (RexLiteral)call.getOperands().get(0);
            TimeUnitRange range = (TimeUnitRange)literal.getValueAs(TimeUnitRange.class);
            if (range == TimeUnitRange.QUARTER) {
                return DateFunctionTranslator.translateExtractQuarter(strings.get(1));
            }
            return new Operand("{ " + DocumentDbRules.quote(DATE_PART_OPERATORS.get(range)) + ": " + strings.get(1) + "}");
        }

        private static Operand translateExtractQuarter(Operand date) {
            String extractQuarterFormatString = "{'$cond': [{'$lte': [{'$month': %1$s}, 3]}, 1, {'$cond': [{'$lte': [{'$month': %1$s}, 6]}, 2, {'$cond': [{'$lte': [{'$month': %1$s}, 9]}, 3, {'$cond': [{'$lte': [{'$month': %1$s}, 12]}, 4, null]}]}]}]}";
            return Operand.format("{'$cond': [{'$lte': [{'$month': %1$s}, 3]}, 1, {'$cond': [{'$lte': [{'$month': %1$s}, 6]}, 2, {'$cond': [{'$lte': [{'$month': %1$s}, 9]}, 3, {'$cond': [{'$lte': [{'$month': %1$s}, 12]}, 4, null]}]}]}]}", date);
        }

        public static Operand translateDayName(RexCall rexCall, List<Operand> strings) {
            String dayNameFormatString = " {'$cond': [{'$eq': [{'$dayOfWeek': %8$s}, 1]}, '%1$s', {'$cond': [{'$eq': [{'$dayOfWeek': %8$s}, 2]}, '%2$s', {'$cond': [{'$eq': [{'$dayOfWeek': %8$s}, 3]}, '%3$s', {'$cond': [{'$eq': [{'$dayOfWeek': %8$s}, 4]}, '%4$s', {'$cond': [{'$eq': [{'$dayOfWeek': %8$s}, 5]}, '%5$s', {'$cond': [{'$eq': [{'$dayOfWeek': %8$s}, 6]}, '%6$s', {'$cond': [{'$eq': [{'$dayOfWeek': %8$s}, 7]}, '%7$s', null]}]}]}]}]}]}]}";
            return Operand.format(" {'$cond': [{'$eq': [{'$dayOfWeek': %8$s}, 1]}, '%1$s', {'$cond': [{'$eq': [{'$dayOfWeek': %8$s}, 2]}, '%2$s', {'$cond': [{'$eq': [{'$dayOfWeek': %8$s}, 3]}, '%3$s', {'$cond': [{'$eq': [{'$dayOfWeek': %8$s}, 4]}, '%4$s', {'$cond': [{'$eq': [{'$dayOfWeek': %8$s}, 5]}, '%5$s', {'$cond': [{'$eq': [{'$dayOfWeek': %8$s}, 6]}, '%6$s', {'$cond': [{'$eq': [{'$dayOfWeek': %8$s}, 7]}, '%7$s', null]}]}]}]}]}]}]}", DayOfWeek.SUNDAY.getDisplayName(TextStyle.FULL, Locale.getDefault()), DayOfWeek.MONDAY.getDisplayName(TextStyle.FULL, Locale.getDefault()), DayOfWeek.TUESDAY.getDisplayName(TextStyle.FULL, Locale.getDefault()), DayOfWeek.WEDNESDAY.getDisplayName(TextStyle.FULL, Locale.getDefault()), DayOfWeek.THURSDAY.getDisplayName(TextStyle.FULL, Locale.getDefault()), DayOfWeek.FRIDAY.getDisplayName(TextStyle.FULL, Locale.getDefault()), DayOfWeek.SATURDAY.getDisplayName(TextStyle.FULL, Locale.getDefault()), strings.get(0));
        }

        public static Operand translateMonthName(RexCall rexCall, List<Operand> strings) {
            String monthNameFormatString = "{'$cond': [{'$eq': [{'$month': %13$s}, 1]}, '%1$s', {'$cond': [{'$eq': [{'$month': %13$s}, 2]}, '%2$s', {'$cond': [{'$eq': [{'$month': %13$s}, 3]}, '%3$s', {'$cond': [{'$eq': [{'$month': %13$s}, 4]}, '%4$s', {'$cond': [{'$eq': [{'$month': %13$s}, 5]}, '%5$s', {'$cond': [{'$eq': [{'$month': %13$s}, 6]}, '%6$s', {'$cond': [{'$eq': [{'$month': %13$s}, 7]}, '%7$s', {'$cond': [{'$eq': [{'$month': %13$s}, 8]}, '%8$s', {'$cond': [{'$eq': [{'$month': %13$s}, 9]}, '%9$s', {'$cond': [{'$eq': [{'$month': %13$s}, 10]}, '%10$s', {'$cond': [{'$eq': [{'$month': %13$s}, 11]}, '%11$s', {'$cond': [{'$eq': [{'$month': %13$s}, 12]}, '%12$s', null]}]}]}]}]}]}]}]}]}]}]}]}";
            return Operand.format("{'$cond': [{'$eq': [{'$month': %13$s}, 1]}, '%1$s', {'$cond': [{'$eq': [{'$month': %13$s}, 2]}, '%2$s', {'$cond': [{'$eq': [{'$month': %13$s}, 3]}, '%3$s', {'$cond': [{'$eq': [{'$month': %13$s}, 4]}, '%4$s', {'$cond': [{'$eq': [{'$month': %13$s}, 5]}, '%5$s', {'$cond': [{'$eq': [{'$month': %13$s}, 6]}, '%6$s', {'$cond': [{'$eq': [{'$month': %13$s}, 7]}, '%7$s', {'$cond': [{'$eq': [{'$month': %13$s}, 8]}, '%8$s', {'$cond': [{'$eq': [{'$month': %13$s}, 9]}, '%9$s', {'$cond': [{'$eq': [{'$month': %13$s}, 10]}, '%10$s', {'$cond': [{'$eq': [{'$month': %13$s}, 11]}, '%11$s', {'$cond': [{'$eq': [{'$month': %13$s}, 12]}, '%12$s', null]}]}]}]}]}]}]}]}]}]}]}]}", Month.JANUARY.getDisplayName(TextStyle.FULL, Locale.getDefault()), Month.FEBRUARY.getDisplayName(TextStyle.FULL, Locale.getDefault()), Month.MARCH.getDisplayName(TextStyle.FULL, Locale.getDefault()), Month.APRIL.getDisplayName(TextStyle.FULL, Locale.getDefault()), Month.MAY.getDisplayName(TextStyle.FULL, Locale.getDefault()), Month.JUNE.getDisplayName(TextStyle.FULL, Locale.getDefault()), Month.JULY.getDisplayName(TextStyle.FULL, Locale.getDefault()), Month.AUGUST.getDisplayName(TextStyle.FULL, Locale.getDefault()), Month.SEPTEMBER.getDisplayName(TextStyle.FULL, Locale.getDefault()), Month.OCTOBER.getDisplayName(TextStyle.FULL, Locale.getDefault()), Month.NOVEMBER.getDisplayName(TextStyle.FULL, Locale.getDefault()), Month.DECEMBER.getDisplayName(TextStyle.FULL, Locale.getDefault()), strings.get(0));
        }

        private static Operand translateFloor(RexCall rexCall, List<Operand> strings) {
            if (rexCall.operands.size() != 2) {
                return null;
            }
            RexNode operand2 = (RexNode)rexCall.operands.get(1);
            if (!operand2.isA(SqlKind.LITERAL) || operand2.getType().getSqlTypeName() != SqlTypeName.SYMBOL || !(((RexLiteral)operand2).getValue() instanceof TimeUnitRange)) {
                return null;
            }
            RexLiteral literal = (RexLiteral)operand2;
            TimeUnitRange timeUnitRange = (TimeUnitRange)DocumentDbRules.getValueAs(literal, TimeUnitRange.class);
            switch (timeUnitRange) {
                case YEAR: 
                case MONTH: {
                    return new Operand(DateFunctionTranslator.formatYearMonthFloorOperation(strings, timeUnitRange));
                }
                case QUARTER: {
                    return new Operand(DateFunctionTranslator.formatQuarterFloorOperation(strings));
                }
                case WEEK: 
                case DAY: 
                case HOUR: 
                case MINUTE: 
                case SECOND: 
                case MILLISECOND: {
                    return DateFunctionTranslator.formatMillisecondFloorOperation(strings, timeUnitRange);
                }
            }
            throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_PROPERTY, timeUnitRange.toString());
        }

        private static String formatYearMonthFloorOperation(List<Operand> strings, TimeUnitRange timeUnitRange) {
            String monthFormat = timeUnitRange == TimeUnitRange.YEAR ? "01" : "%m";
            return DateFunctionTranslator.formatYearMonthFloorOperation(strings.get(0), monthFormat);
        }

        private static String formatYearMonthFloorOperation(Operand dateOperand, String monthFormat) {
            String yearFormat = "%Y";
            return String.format("{'$dateFromString': {'dateString': {'$dateToString': {'date': %1$s, 'format': '%2$s-%3$s-01T00:00:00Z'}}}}", dateOperand, "%Y", monthFormat);
        }

        private static Operand formatMillisecondFloorOperation(List<Operand> strings, TimeUnitRange timeUnitRange) throws SQLFeatureNotSupportedException {
            Instant baseDate = timeUnitRange == TimeUnitRange.WEEK ? FIRST_DAY_OF_WEEK_AFTER_EPOCH : Instant.EPOCH;
            long divisorLong = DateFunctionTranslator.getDivisorValueForNumericFloor(timeUnitRange);
            String divisor = String.format("{\"$numberLong\": \"%d\"}", divisorLong);
            String subtract = String.format("{\"$subtract\": [%s, {\"$date\": {\"$numberLong\": \"%d\"}}]}", strings.get(0), baseDate.toEpochMilli());
            Operand divide = DocumentDbRules.getIntegerDivisionOperation(subtract, divisor);
            String multiply = String.format("{\"$multiply\": [%s, %s]}", divisor, divide);
            return Operand.format("{\"$add\": [{\"$date\": {\"$numberLong\": \"%d\"}}, %s]}", baseDate.toEpochMilli(), multiply);
        }

        private static String formatQuarterFloorOperation(List<Operand> strings) {
            String truncateQuarterFormatString = "{'$cond': [{'$lte': [{'$month': %1$s}, 3]}, %2$s, {'$cond': [{'$lte': [{'$month': %1$s}, 6]}, %3$s, {'$cond': [{'$lte': [{'$month': %1$s}, 9]}, %4$s, {'$cond': [{'$lte': [{'$month': %1$s}, 12]}, %5$s, null]}]}]}]}";
            String monthFormatJanuary = "01";
            String monthFormatApril = "04";
            String monthFormatJuly = "07";
            String monthFormatOctober = "10";
            return String.format("{'$cond': [{'$lte': [{'$month': %1$s}, 3]}, %2$s, {'$cond': [{'$lte': [{'$month': %1$s}, 6]}, %3$s, {'$cond': [{'$lte': [{'$month': %1$s}, 9]}, %4$s, {'$cond': [{'$lte': [{'$month': %1$s}, 12]}, %5$s, null]}]}]}]}", strings.get(0), DateFunctionTranslator.formatYearMonthFloorOperation(strings.get(0), "01"), DateFunctionTranslator.formatYearMonthFloorOperation(strings.get(0), "04"), DateFunctionTranslator.formatYearMonthFloorOperation(strings.get(0), "07"), DateFunctionTranslator.formatYearMonthFloorOperation(strings.get(0), "10"));
        }

        private static long getDivisorValueForNumericFloor(TimeUnitRange timeUnitRange) throws SQLFeatureNotSupportedException {
            long divisorLong;
            switch (timeUnitRange) {
                case WEEK: {
                    divisorLong = ChronoUnit.WEEKS.getDuration().toMillis();
                    break;
                }
                case DAY: {
                    divisorLong = ChronoUnit.DAYS.getDuration().toMillis();
                    break;
                }
                case HOUR: {
                    divisorLong = ChronoUnit.HOURS.getDuration().toMillis();
                    break;
                }
                case MINUTE: {
                    divisorLong = ChronoUnit.MINUTES.getDuration().toMillis();
                    break;
                }
                case SECOND: {
                    divisorLong = ChronoUnit.SECONDS.getDuration().toMillis();
                    break;
                }
                case MILLISECOND: {
                    divisorLong = 1L;
                    break;
                }
                default: {
                    throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.UNSUPPORTED_PROPERTY, timeUnitRange.toString());
                }
            }
            return divisorLong;
        }

        static {
            DATE_PART_OPERATORS.put(TimeUnitRange.YEAR, "$year");
            DATE_PART_OPERATORS.put(TimeUnitRange.MONTH, "$month");
            DATE_PART_OPERATORS.put(TimeUnitRange.WEEK, "$week");
            DATE_PART_OPERATORS.put(TimeUnitRange.HOUR, "$hour");
            DATE_PART_OPERATORS.put(TimeUnitRange.MINUTE, "$minute");
            DATE_PART_OPERATORS.put(TimeUnitRange.SECOND, "$second");
            DATE_PART_OPERATORS.put(TimeUnitRange.DOY, "$dayOfYear");
            DATE_PART_OPERATORS.put(TimeUnitRange.DAY, "$dayOfMonth");
            DATE_PART_OPERATORS.put(TimeUnitRange.DOW, "$dayOfWeek");
            DATE_PART_OPERATORS.put(TimeUnitRange.ISODOW, "$isoDayOfWeek");
            DATE_PART_OPERATORS.put(TimeUnitRange.ISOYEAR, "$isoWeekYear");
        }
    }

    static class RexToMongoTranslator
    extends RexVisitorImpl<Operand> {
        private final JavaTypeFactory typeFactory;
        private final List<String> inFields;
        private final List<String> keys;
        private final DocumentDbSchemaTable schemaTable;
        private final Map<SqlOperator, BiFunction<RexCall, List<Operand>, Operand>> rexCallToMongoMap = new HashMap<SqlOperator, BiFunction<RexCall, List<Operand>, Operand>>();
        private static final Map<SqlOperator, String> MONGO_OPERATORS = new HashMap<SqlOperator, String>();

        private void initializeRexCallToMongoMap(Instant currentTime) {
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.DIVIDE, (call, strings) -> DocumentDbRules.getMongoAggregateForOperator(call, strings, RexToMongoTranslator.MONGO_OPERATORS.get(call.getOperator())));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.MULTIPLY, (call, strings) -> DocumentDbRules.getMongoAggregateForOperator(call, strings, RexToMongoTranslator.MONGO_OPERATORS.get(call.getOperator())));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.MOD, (call, strings) -> DocumentDbRules.getMongoAggregateForOperator(call, strings, RexToMongoTranslator.MONGO_OPERATORS.get(call.getOperator())));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.PLUS, (call, strings) -> DocumentDbRules.getMongoAggregateForOperator(call, strings, RexToMongoTranslator.MONGO_OPERATORS.get(call.getOperator())));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.MINUS, (call, strings) -> DocumentDbRules.getMongoAggregateForOperator(call, strings, RexToMongoTranslator.MONGO_OPERATORS.get(call.getOperator())));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, RexToMongoTranslator::getMongoAggregateForIntegerDivide);
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.AND, (call, strings) -> RexToMongoTranslator.getMongoAggregateForAndOperator(call, strings, MONGO_OPERATORS.get(call.getOperator())));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.OR, (call, strings) -> RexToMongoTranslator.getMongoAggregateForOrOperator(call, strings, MONGO_OPERATORS.get(call.getOperator())));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.NOT, (call, strings) -> RexToMongoTranslator.getMongoAggregateForComparisonOperator(call, strings, MONGO_OPERATORS.get(call.getOperator())));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.EQUALS, (call, strings) -> RexToMongoTranslator.getMongoAggregateForComparisonOperator(call, strings, MONGO_OPERATORS.get(call.getOperator())));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, (call, strings) -> RexToMongoTranslator.getMongoAggregateForComparisonOperator(call, strings, MONGO_OPERATORS.get(call.getOperator())));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (call, strings) -> RexToMongoTranslator.getMongoAggregateForComparisonOperator(call, strings, MONGO_OPERATORS.get(call.getOperator())));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (call, strings) -> RexToMongoTranslator.getMongoAggregateForComparisonOperator(call, strings, MONGO_OPERATORS.get(call.getOperator())));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.LESS_THAN, (call, strings) -> RexToMongoTranslator.getMongoAggregateForComparisonOperator(call, strings, MONGO_OPERATORS.get(call.getOperator())));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (call, strings) -> RexToMongoTranslator.getMongoAggregateForComparisonOperator(call, strings, MONGO_OPERATORS.get(call.getOperator())));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.IS_NULL, (call, strings) -> RexToMongoTranslator.getMongoAggregateForNullOperator(call, strings, MONGO_OPERATORS.get(call.getOperator())));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, (call, strings) -> RexToMongoTranslator.getMongoAggregateForNullOperator(call, strings, MONGO_OPERATORS.get(call.getOperator())));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.CURRENT_DATE, (call, operands) -> DateFunctionTranslator.translateCurrentTimestamp(currentTime));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.CURRENT_TIME, (call, operands) -> DateFunctionTranslator.translateCurrentTimestamp(currentTime));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.CURRENT_TIMESTAMP, (call, operands) -> DateFunctionTranslator.translateCurrentTimestamp(currentTime));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.DATETIME_PLUS, (x$0, x$1) -> DateFunctionTranslator.translateDateAdd(x$0, x$1));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.EXTRACT, (x$0, x$1) -> DateFunctionTranslator.translateExtract(x$0, x$1));
            this.rexCallToMongoMap.put((SqlOperator)SqlLibraryOperators.DAYNAME, DateFunctionTranslator::translateDayName);
            this.rexCallToMongoMap.put((SqlOperator)SqlLibraryOperators.MONTHNAME, DateFunctionTranslator::translateMonthName);
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.FLOOR, (x$0, x$1) -> DateFunctionTranslator.translateFloor(x$0, x$1));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.MINUS_DATE, (x$0, x$1) -> DateFunctionTranslator.translateDateDiff(x$0, x$1));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.CASE, RexToMongoTranslator::getMongoAggregateForCase);
            this.rexCallToMongoMap.put(SqlStdOperatorTable.ITEM, RexToMongoTranslator::getMongoAggregateForItem);
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.CONCAT, (x$0, x$1) -> StringFunctionTranslator.getMongoAggregateForConcatOperator(x$0, x$1));
            this.rexCallToMongoMap.put((SqlOperator)SqlLibraryOperators.CONCAT_FUNCTION, (x$0, x$1) -> StringFunctionTranslator.getMongoAggregateForConcatOperator(x$0, x$1));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.SUBSTRING, (x$0, x$1) -> StringFunctionTranslator.getMongoAggregateForSubstringOperator(x$0, x$1));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.POSITION, (x$0, x$1) -> StringFunctionTranslator.getMongoAggregateForPositionStringOperator(x$0, x$1));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.UPPER, (x$0, x$1) -> StringFunctionTranslator.getMongoAggregateForStringOperator(x$0, x$1));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.LOWER, (x$0, x$1) -> StringFunctionTranslator.getMongoAggregateForStringOperator(x$0, x$1));
            this.rexCallToMongoMap.put((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, (x$0, x$1) -> StringFunctionTranslator.getMongoAggregateForStringOperator(x$0, x$1));
            this.rexCallToMongoMap.put((SqlOperator)SqlLibraryOperators.LEFT, (x$0, x$1) -> StringFunctionTranslator.getMongoAggregateForLeftOperator(x$0, x$1));
            this.rexCallToMongoMap.put((SqlOperator)SqlLibraryOperators.RIGHT, (x$0, x$1) -> StringFunctionTranslator.getMongoAggregateForRightOperator(x$0, x$1));
        }

        private static Operand getMongoAggregateForAndOperator(RexCall call, List<Operand> operands, String s) {
            StringBuilder sb = new StringBuilder();
            sb.append("{$cond: [{$and: [");
            for (Operand value : operands) {
                sb.append("{$eq: [true, ").append(value).append("]},");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("]}, true,");
            sb.append("{$cond: [{$or: [");
            for (Operand value : operands) {
                sb.append("{$eq: [false, ").append(value).append("]},");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("]}, false, null]}]}");
            return new Operand(sb.toString(), SimpleMatchTranslator.getAndOrOperator(operands, s), false);
        }

        private static Operand getMongoAggregateForOrOperator(RexCall call, List<Operand> operands, String s) {
            StringBuilder sb = new StringBuilder();
            sb.append("{$cond: [{$or: [");
            for (Operand value : operands) {
                sb.append("{$eq: [true, ").append(value.getAggregationValue()).append("]},");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("]}, true,");
            sb.append("{$cond: [{$and: [");
            for (Operand value : operands) {
                sb.append("{$eq: [false, ").append(value.getAggregationValue()).append("]},");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("]}, false, null]}]}");
            return new Operand(sb.toString(), SimpleMatchTranslator.getAndOrOperator(operands, s), false);
        }

        protected RexToMongoTranslator(JavaTypeFactory typeFactory, List<String> inFields, List<String> keys, DocumentDbSchemaTable schemaTable, Instant currentTime) {
            super(true);
            this.initializeRexCallToMongoMap(currentTime);
            this.typeFactory = typeFactory;
            this.inFields = inFields;
            this.keys = keys;
            this.schemaTable = schemaTable;
        }

        public Operand visitLiteral(RexLiteral literal) {
            if (literal.getValue() == null) {
                return new Operand("null");
            }
            switch (literal.getType().getSqlTypeName()) {
                case DECIMAL: {
                    Comparable value = literal.getValue();
                    String decimal128Format = "{\"$numberDecimal\": \"" + value + "\"}";
                    return new Operand("{\"$literal\": " + decimal128Format + "}", decimal128Format, true);
                }
                case DOUBLE: 
                case FLOAT: 
                case REAL: {
                    String doubleFormat = "{\"$numberDouble\": \"" + DocumentDbRules.getValueAs(literal, Double.class) + "\"}";
                    return new Operand("{\"$literal\": " + doubleFormat + "}", doubleFormat, true);
                }
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: {
                    String intFormat = "{\"$numberInt\": \"" + DocumentDbRules.getValueAs(literal, Long.class) + "\"}";
                    return new Operand("{\"$literal\": " + intFormat + "}", intFormat, true);
                }
                case BIGINT: 
                case INTERVAL_MONTH: 
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    String longFormat = "{\"$numberLong\": \"" + DocumentDbRules.getValueAs(literal, Long.class) + "\"}";
                    return new Operand("{\"$literal\": " + longFormat + "}", longFormat, true);
                }
                case DATE: {
                    String dateFormat = "{\"$date\": {\"$numberLong\": \"" + ((DateString)DocumentDbRules.getValueAs(literal, DateString.class)).getMillisSinceEpoch() + "\" } }";
                    return new Operand(dateFormat, dateFormat, true);
                }
                case TIME: {
                    String timeFormat = "{\"$date\": {\"$numberLong\": \"" + ((TimeString)DocumentDbRules.getValueAs(literal, TimeString.class)).getMillisOfDay() + "\" } }";
                    return new Operand(timeFormat, timeFormat, true);
                }
                case TIMESTAMP: 
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    String datetimeFormat = "{\"$date\": {\"$numberLong\": \"" + DocumentDbRules.getValueAs(literal, Long.class) + "\" } }";
                    return new Operand(datetimeFormat, datetimeFormat, true);
                }
                case BINARY: 
                case VARBINARY: {
                    String base64Literal = BaseEncoding.base64().encode((byte[])DocumentDbRules.getValueAs(literal, byte[].class));
                    String binaryFormat = "{\"$binary\": {\"base64\": \"" + base64Literal + "\", \"subType\": \"00\"}}";
                    return new Operand(binaryFormat, binaryFormat, true);
                }
            }
            String simpleLiteral = RexToLixTranslator.translateLiteral((RexLiteral)literal, (RelDataType)literal.getType(), (JavaTypeFactory)this.typeFactory, (RexImpTable.NullAs)RexImpTable.NullAs.NOT_POSSIBLE).toString();
            return new Operand("{\"$literal\": " + simpleLiteral + "}", simpleLiteral, true);
        }

        public Operand visitInputRef(RexInputRef inputRef) {
            return new Operand(DocumentDbRules.maybeQuote("$" + this.inFields.get(inputRef.getIndex())), DocumentDbRules.maybeQuote(this.inFields.get(inputRef.getIndex())), false, (DocumentDbSchemaColumn)this.schemaTable.getColumnMap().get((Object)this.keys.get(inputRef.getIndex())));
        }

        public Operand visitCall(RexCall call) {
            Operand result;
            String name = DocumentDbRules.isItem(call);
            if (name != null) {
                return new Operand("'$" + name + "'");
            }
            List strings = this.visitList((Iterable)call.operands);
            if (call.getKind() == SqlKind.CAST || call.getKind() == SqlKind.REINTERPRET) {
                return RexToMongoTranslator.getCastExpression(call, strings);
            }
            if (this.rexCallToMongoMap.containsKey(call.getOperator()) && (result = this.rexCallToMongoMap.get(call.getOperator()).apply(call, strings)) != null) {
                return result;
            }
            throw new IllegalArgumentException("Translation of " + call + " is not supported by DocumentDbRules");
        }

        private static Operand getCastExpression(RexCall call, List<Operand> strings) {
            if (call.operands.size() == 1 && call.operands.get(0) instanceof RexLiteral) {
                RexLiteral operand = (RexLiteral)call.operands.get(0);
                block0 : switch (operand.getType().getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        String value = (String)operand.getValueAs(String.class);
                        switch (call.type.getSqlTypeName()) {
                            case DECIMAL: {
                                String decimal128Format = "{\"$numberDecimal\": \"" + value + "\"}";
                                return new Operand("{\"$literal\": " + decimal128Format + "}", decimal128Format, true);
                            }
                            case DOUBLE: 
                            case FLOAT: 
                            case REAL: {
                                String doubleFormat = "{\"$numberDouble\": \"" + value + "\"}";
                                return new Operand("{\"$literal\": " + doubleFormat + "}", doubleFormat, true);
                            }
                            case BOOLEAN: {
                                break block0;
                            }
                            case TINYINT: 
                            case SMALLINT: 
                            case INTEGER: {
                                String intFormat = "{\"$numberInt\": \"" + value + "\"}";
                                return new Operand("{\"$literal\": " + intFormat + "}", intFormat, true);
                            }
                            case BIGINT: {
                                String longFormat = "{\"$numberLong\": \"" + value + "\"}";
                                return new Operand("{\"$literal\": " + longFormat + "}", longFormat, true);
                            }
                        }
                        break;
                    }
                }
            }
            return strings.get(0);
        }

        private static Operand getMongoAggregateForIntegerDivide(RexCall call, List<Operand> strings) {
            return DocumentDbRules.getIntegerDivisionOperation(strings.get(0), strings.get(1));
        }

        private static Operand getMongoAggregateForCase(RexCall call, List<Operand> strings) {
            StringBuilder sb = new StringBuilder();
            StringBuilder finish = new StringBuilder();
            for (int i = 0; i < strings.size(); i += 2) {
                sb.append("{$cond:[");
                finish.append("]}");
                sb.append(strings.get(i));
                sb.append(',');
                sb.append(strings.get(i + 1));
                sb.append(',');
                if (i == strings.size() - 3) {
                    sb.append(strings.get(i + 2));
                    break;
                }
                if (i != strings.size() - 2) continue;
                sb.append("null");
                break;
            }
            sb.append((CharSequence)finish);
            return new Operand(sb.toString());
        }

        private static Operand getMongoAggregateForItem(RexCall call, List<Operand> strings) {
            RexNode op1 = (RexNode)call.operands.get(1);
            if (op1 instanceof RexLiteral && op1.getType().getSqlTypeName() == SqlTypeName.INTEGER) {
                return new Operand("'" + DocumentDbRules.stripQuotes(strings.get(0).getAggregationValue()) + "[" + ((RexLiteral)op1).getValue2() + "]'");
            }
            return null;
        }

        private static Operand getMongoAggregateForComparisonOperator(RexCall call, List<Operand> strings, String stdOperator) {
            String aggregateExpr = "{\"$cond\": [" + RexToMongoTranslator.getNullCheckExpr(strings) + ", " + DocumentDbRules.getMongoAggregateForOperator(call, strings, stdOperator) + ", null]}";
            return new Operand(aggregateExpr, DocumentDbRules.hasObjectIdAndLiteral(call, strings) ? SimpleMatchTranslator.getObjectIdComparisonOperator(call, strings, stdOperator) : SimpleMatchTranslator.getComparisonOperator(call, strings, stdOperator), false);
        }

        private static String getNullCheckExpr(List<Operand> strings) {
            StringBuilder nullCheckOperator = new StringBuilder("{\"$and\": [");
            for (Operand s : strings) {
                nullCheckOperator.append("{\"$gt\": [");
                nullCheckOperator.append(s);
                nullCheckOperator.append(", null]},");
            }
            nullCheckOperator.deleteCharAt(nullCheckOperator.length() - 1);
            nullCheckOperator.append("]}");
            return nullCheckOperator.toString();
        }

        private static Operand getMongoAggregateForNullOperator(RexCall call, List<Operand> strings, String stdOperator) {
            return new Operand("{" + stdOperator + ": [" + strings.get(0) + ", null]}", SimpleMatchTranslator.getNullCheckOperator(call, strings), false);
        }

        static {
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.DIVIDE, "$divide");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.MULTIPLY, "$multiply");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.MOD, "$mod");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.PLUS, "$add");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.MINUS, "$subtract");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.MINUS_DATE, "$subtract");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.AND, "$and");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.OR, "$or");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.NOT, "$not");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.EQUALS, "$eq");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, "$ne");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.GREATER_THAN, "$gt");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, "$gte");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.LESS_THAN, "$lt");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, "$lte");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.IS_NULL, "$lte");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, "$gt");
        }
    }
}

