/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.common;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import software.amazon.documentdb.jdbc.common.Statement;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;

public abstract class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    private final String sql;
    private ResultSet resultSet;

    protected PreparedStatement(Connection connection, String sql) {
        super(connection);
        this.sql = sql;
    }

    @Override
    public void addBatch() throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute() throws SQLException {
        this.resultSet = this.executeQuery();
        return true;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.verifyOpen();
        return this.resultSet;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void clearParameters() throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.READ_ONLY, new Object[0]));
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.UNSUPPORTED_TYPE, Blob.class.toString()));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.UNSUPPORTED_TYPE, Blob.class.toString()));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.UNSUPPORTED_TYPE, Blob.class.toString()));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.UNSUPPORTED_TYPE, Clob.class.toString()));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.UNSUPPORTED_TYPE, Clob.class.toString()));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.UNSUPPORTED_TYPE, Clob.class.toString()));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.UNSUPPORTED_TYPE, NClob.class.toString()));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.UNSUPPORTED_TYPE, NClob.class.toString()));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.UNSUPPORTED_TYPE, NClob.class.toString()));
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.UNSUPPORTED_TYPE, Ref.class.toString()));
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.UNSUPPORTED_TYPE, SQLXML.class.toString()));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.PARAMETERS_NOT_SUPPORTED, new Object[0]));
    }

    protected String getSql() {
        return this.sql;
    }
}

