/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc;

import com.google.common.collect.ImmutableList;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.common.ResultSetMetaData;
import software.amazon.documentdb.jdbc.common.utilities.JdbcColumnMetaData;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;

public class DocumentDbResultSetMetaData
extends ResultSetMetaData
implements java.sql.ResultSetMetaData {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentDbResultSetMetaData.class);
    private final ImmutableList<JdbcColumnMetaData> columnMetaData;
    private final int columnCount;

    DocumentDbResultSetMetaData(ImmutableList<JdbcColumnMetaData> columnMetaData) {
        this.columnMetaData = columnMetaData;
        this.columnCount = columnMetaData.size();
    }

    private void verifyColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.INVALID_INDEX, columnIndex, this.columnCount);
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).isAutoIncrement();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).isCaseSensitive();
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).isSearchable();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).isCurrency();
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).getNullable();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).getColumnDisplaySize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).getColumnLabel();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).getColumnName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).getSchemaName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).getScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).getTableName();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).getCatalogName();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).getColumnType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).getColumnTypeName();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).isReadOnly();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).isWritable();
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).isDefinitelyWritable();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return ((JdbcColumnMetaData)this.columnMetaData.get(column - 1)).getColumnClassName();
    }
}

