/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.query;

import java.util.List;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import software.amazon.documentdb.jdbc.common.utilities.JdbcColumnMetaData;

public class DocumentDbMqlQueryContext {
    private final List<JdbcColumnMetaData> columnMetaData;
    private final List<Bson> aggregateOperations;
    private final String collectionName;
    private final List<String> paths;

    public List<String> getAggregateOperationsAsStrings() {
        return this.aggregateOperations.stream().map(doc -> doc.toBsonDocument().toJson(JsonWriterSettings.builder().outputMode(JsonMode.EXTENDED).build())).collect(Collectors.toList());
    }

    DocumentDbMqlQueryContext(List<JdbcColumnMetaData> columnMetaData, List<Bson> aggregateOperations, String collectionName, List<String> paths) {
        this.columnMetaData = columnMetaData;
        this.aggregateOperations = aggregateOperations;
        this.collectionName = collectionName;
        this.paths = paths;
    }

    public static DocumentDbMqlQueryContextBuilder builder() {
        return new DocumentDbMqlQueryContextBuilder();
    }

    public List<JdbcColumnMetaData> getColumnMetaData() {
        return this.columnMetaData;
    }

    public List<Bson> getAggregateOperations() {
        return this.aggregateOperations;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public static class DocumentDbMqlQueryContextBuilder {
        private List<JdbcColumnMetaData> columnMetaData;
        private List<Bson> aggregateOperations;
        private String collectionName;
        private List<String> paths;

        DocumentDbMqlQueryContextBuilder() {
        }

        public DocumentDbMqlQueryContextBuilder columnMetaData(List<JdbcColumnMetaData> columnMetaData) {
            this.columnMetaData = columnMetaData;
            return this;
        }

        public DocumentDbMqlQueryContextBuilder aggregateOperations(List<Bson> aggregateOperations) {
            this.aggregateOperations = aggregateOperations;
            return this;
        }

        public DocumentDbMqlQueryContextBuilder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public DocumentDbMqlQueryContextBuilder paths(List<String> paths) {
            this.paths = paths;
            return this;
        }

        public DocumentDbMqlQueryContext build() {
            return new DocumentDbMqlQueryContext(this.columnMetaData, this.aggregateOperations, this.collectionName, this.paths);
        }

        public String toString() {
            return "DocumentDbMqlQueryContext.DocumentDbMqlQueryContextBuilder(columnMetaData=" + this.columnMetaData + ", aggregateOperations=" + this.aggregateOperations + ", collectionName=" + this.collectionName + ", paths=" + this.paths + ")";
        }
    }
}

