/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import org.apache.calcite.avatica.ColumnMetaData;
import software.amazon.documentdb.jdbc.common.utilities.JdbcColumnMetaData;
import software.amazon.documentdb.jdbc.common.utilities.JdbcType;

public class DocumentDbJdbcMetaDataConverter {
    private static final ImmutableMap<JdbcType, ColumnMetaData.Rep> JDBC_TYPE_TO_REP = ImmutableMap.builder().put((Object)JdbcType.BIGINT, (Object)ColumnMetaData.Rep.PRIMITIVE_LONG).put((Object)JdbcType.BOOLEAN, (Object)ColumnMetaData.Rep.PRIMITIVE_BOOLEAN).put((Object)JdbcType.DECIMAL, (Object)ColumnMetaData.Rep.NUMBER).put((Object)JdbcType.DOUBLE, (Object)ColumnMetaData.Rep.PRIMITIVE_DOUBLE).put((Object)JdbcType.INTEGER, (Object)ColumnMetaData.Rep.PRIMITIVE_INT).put((Object)JdbcType.NULL, (Object)ColumnMetaData.Rep.STRING).put((Object)JdbcType.TIMESTAMP, (Object)ColumnMetaData.Rep.JAVA_SQL_TIMESTAMP).put((Object)JdbcType.VARCHAR, (Object)ColumnMetaData.Rep.STRING).put((Object)JdbcType.VARBINARY, (Object)ColumnMetaData.Rep.BYTE_STRING).build();

    public static List<JdbcColumnMetaData> fromCalciteColumnMetaData(List<ColumnMetaData> columnMetaData) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnMetaData columnMetaDataItem : columnMetaData) {
            builder.add((Object)DocumentDbJdbcMetaDataConverter.fromCalciteColumnMetaData(columnMetaDataItem));
        }
        return builder.build();
    }

    public static JdbcColumnMetaData fromCalciteColumnMetaData(ColumnMetaData columnMetaData) {
        return new JdbcColumnMetaData(columnMetaData.ordinal, columnMetaData.autoIncrement, columnMetaData.caseSensitive, columnMetaData.searchable, columnMetaData.currency, columnMetaData.nullable, columnMetaData.signed, columnMetaData.displaySize, columnMetaData.label, columnMetaData.columnName, columnMetaData.schemaName, columnMetaData.precision, columnMetaData.scale, columnMetaData.tableName, columnMetaData.catalogName, columnMetaData.type.id, columnMetaData.type.name, columnMetaData.readOnly, columnMetaData.writable, columnMetaData.definitelyWritable, columnMetaData.columnClassName);
    }
}

