/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.common.utilities;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.apache.commons.beanutils.converters.ArrayConverter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.beanutils.converters.DateTimeConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;

public class TypeConverters {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeConverters.class);
    private static final ImmutableMap<Class<?>, AbstractConverter> TYPE_CONVERTERS_MAP = ImmutableMap.builder().put(BigDecimal.class, (Object)new BigDecimalConverter((Object)0)).put(Boolean.class, (Object)new BooleanConverter((Object)false)).put(Boolean.TYPE, (Object)new BooleanConverter((Object)false)).put(BsonTimestamp.class, (Object)new BsonTimestampConverter()).put(BsonRegularExpression.class, (Object)new StringConverter()).put(Byte.class, (Object)new ByteConverter((Object)0)).put(Byte.TYPE, (Object)new ByteConverter((Object)0)).put(java.util.Date.class, (Object)new DateConverter(null)).put(Date.class, (Object)new DateConverter(null)).put(Double.class, (Object)new DoubleConverter((Object)0.0)).put(Double.TYPE, (Object)new DoubleConverter((Object)0.0)).put(Float.class, (Object)new FloatConverter((Object)0.0)).put(Float.TYPE, (Object)new FloatConverter((Object)0.0)).put(Integer.class, (Object)new IntegerConverter((Object)0)).put(Integer.TYPE, (Object)new IntegerConverter((Object)0)).put(Long.class, (Object)new LongConverter((Object)0)).put(Long.TYPE, (Object)new LongConverter((Object)0)).put(MaxKey.class, (Object)new StringConverter()).put(MinKey.class, (Object)new StringConverter()).put(ObjectId.class, (Object)new StringConverter()).put(Short.class, (Object)new ShortConverter((Object)0)).put(Short.TYPE, (Object)new ShortConverter((Object)0)).put(String.class, (Object)new StringConverter()).put(Timestamp.class, (Object)new SqlTimestampConverter()).put(Byte[].class, (Object)new ArrayConverter(Byte[].class, (Converter)new ByteConverter(), -1)).put(byte[].class, (Object)new ArrayConverter(byte[].class, (Converter)new ByteConverter(), -1)).build();

    public static AbstractConverter get(Class<? extends Object> sourceType, Class<? extends Object> targetType) throws SQLException {
        AbstractConverter converter = (AbstractConverter)TYPE_CONVERTERS_MAP.get(sourceType);
        if (converter == null) {
            throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.UNSUPPORTED_CONVERSION, sourceType.getSimpleName(), targetType.getSimpleName());
        }
        return converter;
    }

    private static class BsonTimestampConverter
    extends DateTimeConverter {
        public BsonTimestampConverter() {
        }

        public BsonTimestampConverter(Object defaultValue) {
            super(defaultValue);
        }

        protected <T> T convertToType(Class<T> targetType, Object value) throws Exception {
            if (value instanceof BsonTimestamp) {
                return (T)super.convertToType(targetType, (Object)((BsonTimestamp)value).getValue());
            }
            return (T)super.convertToType(targetType, value);
        }

        protected String convertToString(Object value) throws Throwable {
            if (value instanceof BsonTimestamp) {
                return super.convertToString((Object)((BsonTimestamp)value).getValue());
            }
            return super.convertToString(value);
        }

        protected Class<?> getDefaultType() {
            return BsonTimestamp.class;
        }
    }
}

