/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.jar.bytebuddy.implementation.bytecode.assign;

import software.amazon.disco.agent.jar.asm.MethodVisitor;
import software.amazon.disco.agent.jar.bytebuddy.build.HashCodeAndEqualsPlugin;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDefinition;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.implementation.Implementation;
import software.amazon.disco.agent.jar.bytebuddy.implementation.bytecode.StackManipulation;
import software.amazon.disco.agent.jar.bytebuddy.implementation.bytecode.StackSize;
import software.amazon.disco.agent.jar.bytebuddy.utility.nullability.MaybeNull;

@HashCodeAndEqualsPlugin.Enhance
public class TypeCasting
extends StackManipulation.AbstractBase {
    private final TypeDescription typeDescription;

    protected TypeCasting(TypeDescription typeDescription) {
        this.typeDescription = typeDescription;
    }

    public static StackManipulation to(TypeDefinition typeDefinition) {
        if (typeDefinition.isPrimitive()) {
            throw new IllegalArgumentException("Cannot cast to primitive type: " + typeDefinition);
        }
        return new TypeCasting(typeDefinition.asErasure());
    }

    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitTypeInsn(192, this.typeDescription.getInternalName());
        return StackSize.ZERO.toIncreasingSize();
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.typeDescription.equals(((TypeCasting)object).typeDescription);
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + this.typeDescription.hashCode();
    }
}

