/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import software.amazon.disco.agent.concurrent.InterceptorUtils;
import software.amazon.disco.agent.concurrent.decorate.DecoratedRunnable;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.AgentBuilder;
import software.amazon.disco.agent.jar.bytebuddy.asm.Advice;
import software.amazon.disco.agent.jar.bytebuddy.description.method.MethodDescription;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatcher;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

public class ThreadPoolInterceptor
implements Installable {
    private static Logger log = LogManager.getLogger(ThreadPoolInterceptor.class);

    @Override
    public AgentBuilder install(AgentBuilder agentBuilder) {
        return InterceptorUtils.configureRedefinition(agentBuilder).type(ThreadPoolInterceptor.createTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.visit(Advice.to(BeforeExecuteAdvice.class).on(ThreadPoolInterceptor.createBeforeExecuteMethodMatcher())).visit(Advice.to(AfterExecuteAdvice.class).on(ThreadPoolInterceptor.createAfterExecuteMethodMatcher())).visit(Advice.to(RemoveAdvice.class).on(ThreadPoolInterceptor.createRemoveMethodMatcher())).visit(Advice.to(ShutdownNowAdvice.class).on(ThreadPoolInterceptor.createShutdownNowMethodMatcher())));
    }

    static ElementMatcher.Junction<? super TypeDescription> createTypeMatcher() {
        return ElementMatchers.isSubTypeOf(ThreadPoolExecutor.class).and(ElementMatchers.not(ElementMatchers.isSubTypeOf(ScheduledThreadPoolExecutor.class)));
    }

    static ElementMatcher.Junction<? super MethodDescription> createBeforeExecuteMethodMatcher() {
        return ElementMatchers.named("beforeExecute").and(ElementMatchers.isOverriddenFrom(ThreadPoolExecutor.class)).and(ElementMatchers.not(ElementMatchers.isAbstract()));
    }

    static ElementMatcher.Junction<? super MethodDescription> createAfterExecuteMethodMatcher() {
        return ElementMatchers.named("afterExecute").and(ElementMatchers.isOverriddenFrom(ThreadPoolExecutor.class)).and(ElementMatchers.not(ElementMatchers.isAbstract()));
    }

    static ElementMatcher.Junction<? super MethodDescription> createRemoveMethodMatcher() {
        return ElementMatchers.named("remove").and(ElementMatchers.isOverriddenFrom(ThreadPoolExecutor.class)).and(ElementMatchers.not(ElementMatchers.isAbstract()));
    }

    static ElementMatcher.Junction<? super MethodDescription> createShutdownNowMethodMatcher() {
        return ElementMatchers.named("shutdownNow").and(ElementMatchers.isOverriddenFrom(ThreadPoolExecutor.class)).and(ElementMatchers.not(ElementMatchers.isAbstract()));
    }

    public static Runnable unDecorate(Runnable r) {
        if (r instanceof DecoratedRunnable) {
            return ((DecoratedRunnable)r).getTarget();
        }
        return r;
    }

    public static class ShutdownNowAdvice {
        @Advice.OnMethodExit
        public static void onMethodExit(@Advice.Return(readOnly=false) List<Runnable> rs) {
            for (int i = 0; i < rs.size(); ++i) {
                rs.set(i, ThreadPoolInterceptor.unDecorate(rs.get(i)));
            }
        }
    }

    public static class RemoveAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.This ThreadPoolExecutor thiz, @Advice.Argument(value=0, readOnly=false) Runnable r) {
            r = RemoveAdvice.decorate(thiz, r);
        }

        public static Runnable decorate(ThreadPoolExecutor thiz, Runnable r) {
            if (thiz instanceof ScheduledThreadPoolExecutor) {
                return r;
            }
            return DecoratedRunnable.maybeCreate(r);
        }
    }

    public static class AfterExecuteAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.Argument(value=0, readOnly=false) Runnable r) {
            r = ThreadPoolInterceptor.unDecorate(r);
        }
    }

    public static class BeforeExecuteAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.Argument(value=1, readOnly=false) Runnable r) {
            r = ThreadPoolInterceptor.unDecorate(r);
        }
    }
}

