/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import software.amazon.disco.agent.concurrent.MetadataItem;
import software.amazon.disco.agent.concurrent.TransactionIdentifier;
import software.amazon.disco.agent.event.EventBus;
import software.amazon.disco.agent.event.TransactionBeginEvent;
import software.amazon.disco.agent.event.TransactionEndEvent;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

public class TransactionContext {
    private static Logger log = LogManager.getLogger(TransactionContext.class);
    static final String TRANSACTION_ID_KEY = "$amazon.discoTransactionId";
    public static final String TRANSACTION_OWNING_THREAD_KEY = "$amazon.discoTransactionOwningThreadId";
    public static final String UNINITIALIZED_TRANSACTION_CONTEXT_VALUE = "disco_null_id";
    private static final String REFERENCE_COUNTER_KEY = "$amazon.discoRefCounterKey";
    private static final TransactionContextFactory TRANSACTION_CONTEXT_FACTORY = new TransactionContextFactory();
    private static final ThreadLocal<ConcurrentMap<String, MetadataItem>> transactionContext = ThreadLocal.withInitial(TRANSACTION_CONTEXT_FACTORY);

    static AtomicInteger getReferenceCounter() {
        MetadataItem referenceCounter = (MetadataItem)transactionContext.get().get(REFERENCE_COUNTER_KEY);
        if (referenceCounter == null) {
            return null;
        }
        return (AtomicInteger)AtomicInteger.class.cast(referenceCounter.get());
    }

    public static int create() {
        if (TransactionContext.getReferenceCounter() == null || TransactionContext.getReferenceCounter().get() <= 0) {
            TransactionContext.clear();
            TransactionContext.set(TransactionIdentifier.generate());
            TransactionContext.putMetadata(TRANSACTION_OWNING_THREAD_KEY, Thread.currentThread().getId());
            transactionContext.get().put(REFERENCE_COUNTER_KEY, new MetadataItem(new AtomicInteger(0)));
            EventBus.publish(new TransactionBeginEvent("Core"));
        }
        return TransactionContext.getReferenceCounter().getAndIncrement();
    }

    public static void destroy() {
        if (TransactionContext.getReferenceCounter() == null) {
            TransactionContext.clear();
            return;
        }
        if (TransactionContext.getReferenceCounter().decrementAndGet() <= 0) {
            EventBus.publish(new TransactionEndEvent("Core"));
            TransactionContext.clear();
        }
    }

    public static String get() {
        return (String)String.class.cast(((MetadataItem)transactionContext.get().get(TRANSACTION_ID_KEY)).get());
    }

    public static void set(String value) {
        transactionContext.get().put(TRANSACTION_ID_KEY, new MetadataItem(value));
    }

    public static void putMetadata(String key, Object value) {
        if (TRANSACTION_ID_KEY.equals(key)) {
            throw new IllegalArgumentException("$amazon.discoTransactionId may not be used as a metadata key");
        }
        transactionContext.get().put(key, new MetadataItem(value));
    }

    public static void removeMetadata(String key) {
        if (TRANSACTION_ID_KEY.equals(key)) {
            throw new IllegalArgumentException("$amazon.discoTransactionId may not be used as a metadata key");
        }
        transactionContext.get().remove(key);
    }

    public static Object getMetadata(String key) {
        if (TRANSACTION_ID_KEY.equals(key)) {
            throw new IllegalArgumentException("$amazon.discoTransactionId may not be used as a metadata key");
        }
        MetadataItem metadataItem = (MetadataItem)transactionContext.get().get(key);
        if (metadataItem == null) {
            return null;
        }
        return metadataItem.get();
    }

    public static Map<String, Object> getMetadataWithTag(String tag) {
        Map<String, Object> result = transactionContext.get().entrySet().stream().filter(map -> ((MetadataItem)map.getValue()).hasTag(tag)).collect(Collectors.toMap(map -> (String)map.getKey(), map -> ((MetadataItem)map.getValue()).get()));
        return result;
    }

    public static void setMetadataTag(String key, String tag) {
        MetadataItem metadataItem = (MetadataItem)transactionContext.get().get(key);
        if (metadataItem == null) {
            throw new IllegalArgumentException(key + " no metadata object exists for this key");
        }
        metadataItem.setTag(tag);
    }

    public static void clearMetadataTag(String key, String tag) {
        MetadataItem metadataItem = (MetadataItem)transactionContext.get().get(key);
        if (metadataItem == null) {
            throw new IllegalArgumentException(key + " no metadata object exists for this key");
        }
        metadataItem.clearTag(tag);
    }

    public static boolean hasMetadataTag(String key, String tag) {
        MetadataItem metadataItem = (MetadataItem)transactionContext.get().get(key);
        if (metadataItem == null) {
            throw new IllegalArgumentException(key + " no metadata object exists for this key");
        }
        return metadataItem.hasTag(tag);
    }

    public static void clear() {
        transactionContext.set((ConcurrentMap<String, MetadataItem>)TRANSACTION_CONTEXT_FACTORY.get());
    }

    public static void remove() {
        transactionContext.remove();
    }

    public static String getUninitializedTransactionContextValue() {
        return UNINITIALIZED_TRANSACTION_CONTEXT_VALUE;
    }

    public static boolean isWithinCreatedContext() {
        return !UNINITIALIZED_TRANSACTION_CONTEXT_VALUE.equals(TransactionContext.get());
    }

    public static ConcurrentMap<String, MetadataItem> getPrivateMetadata() {
        return transactionContext.get();
    }

    public static ThreadLocal<ConcurrentMap<String, MetadataItem>> getPrivateMetadataThreadLocal() {
        return transactionContext;
    }

    public static void setPrivateMetadata(ConcurrentMap<String, MetadataItem> metadata) {
        transactionContext.set(metadata);
    }

    static class TransactionContextFactory
    implements Supplier<ConcurrentMap<String, MetadataItem>> {
        TransactionContextFactory() {
        }

        @Override
        public ConcurrentMap<String, MetadataItem> get() {
            ConcurrentHashMap<String, MetadataItem> map = new ConcurrentHashMap<String, MetadataItem>();
            map.put(TransactionContext.TRANSACTION_ID_KEY, new MetadataItem(TransactionContext.UNINITIALIZED_TRANSACTION_CONTEXT_VALUE));
            map.put(TransactionContext.TRANSACTION_OWNING_THREAD_KEY, new MetadataItem(-1L));
            return map;
        }
    }
}

