/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import software.amazon.disco.agent.concurrent.decorate.DecoratedCallable;
import software.amazon.disco.agent.concurrent.decorate.DecoratedForkJoinTask;
import software.amazon.disco.agent.concurrent.decorate.DecoratedRunnable;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.AgentBuilder;
import software.amazon.disco.agent.jar.bytebuddy.asm.Advice;
import software.amazon.disco.agent.jar.bytebuddy.description.method.MethodDescription;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.implementation.bytecode.assign.Assigner;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatcher;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

class ForkJoinPoolInterceptor
implements Installable {
    public static Logger log = LogManager.getLogger(ForkJoinPoolInterceptor.class);

    ForkJoinPoolInterceptor() {
    }

    @Override
    public AgentBuilder install(AgentBuilder agentBuilder) {
        return agentBuilder.ignore(ElementMatchers.not(ElementMatchers.named("java.util.concurrent.ForkJoinPool"))).type(ForkJoinPoolInterceptor.createTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.method(ForkJoinPoolInterceptor.createRunnableMethodsMatcher()).intercept(Advice.to(RunnableMethodsAdvice.class)).method(ForkJoinPoolInterceptor.createCallableMethodsMatcher()).intercept(Advice.to(CallableMethodsAdvice.class)).method(ForkJoinPoolInterceptor.createCallableCollectionMethodsMatcher()).intercept(Advice.to(CallableCollectionMethodsAdvice.class)).method(ForkJoinPoolInterceptor.createForkJoinTaskMethodsMatcher()).intercept(Advice.to(ForkJoinTaskMethodsAdvice.class)));
    }

    static ElementMatcher.Junction<? super TypeDescription> createTypeMatcher() {
        return ElementMatchers.named("java.util.concurrent.ForkJoinPool");
    }

    static ElementMatcher.Junction<? super MethodDescription> createRunnableMethodsMatcher() {
        return ElementMatchers.isPublic().and(ElementMatchers.named("execute").or(ElementMatchers.named("submit"))).and(ElementMatchers.takesArgument(0, Runnable.class));
    }

    static ElementMatcher.Junction<? super MethodDescription> createCallableMethodsMatcher() {
        return ElementMatchers.isPublic().and(ElementMatchers.named("submit")).and(ElementMatchers.takesArgument(0, Callable.class));
    }

    static ElementMatcher.Junction<? super MethodDescription> createCallableCollectionMethodsMatcher() {
        return ElementMatchers.isPublic().and(ElementMatchers.named("invokeAll")).and(ElementMatchers.takesArgument(0, Collection.class));
    }

    static ElementMatcher.Junction<? super MethodDescription> createForkJoinTaskMethodsMatcher() {
        return ElementMatchers.isPublic().and(ElementMatchers.named("invoke").or(ElementMatchers.named("execute")).or(ElementMatchers.named("submit"))).and(ElementMatchers.takesArgument(0, ElementMatchers.named("java.util.concurrent.ForkJoinTask")));
    }

    public static class ForkJoinTaskMethodsAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.Argument(value=0, typing=Assigner.Typing.DYNAMIC) Object task) {
            ForkJoinTaskMethodsAdvice.methodEnter(task);
        }

        public static void methodEnter(Object task) {
            try {
                DecoratedForkJoinTask.Accessor accessor = (DecoratedForkJoinTask.Accessor)task;
                accessor.setDiscoDecoration(DecoratedForkJoinTask.create());
            }
            catch (Exception e) {
                log.error("DiSCo(Concurrency) could not propagate context into " + task);
            }
        }
    }

    public static class CallableCollectionMethodsAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.Argument(value=0, readOnly=false) Collection<Callable> tasks) {
            tasks = CallableCollectionMethodsAdvice.methodEnter(tasks);
        }

        public static Collection<Callable> methodEnter(Collection<Callable> tasks) {
            int size = tasks.size();
            if (size > 0) {
                ArrayList<Callable> decorated = new ArrayList<Callable>(size);
                for (Callable c : tasks) {
                    decorated.add(DecoratedCallable.maybeCreate(c));
                }
                return decorated;
            }
            return tasks;
        }
    }

    public static class CallableMethodsAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.Argument(value=0, readOnly=false) Callable task) {
            task = CallableMethodsAdvice.methodEnter(task);
        }

        public static Callable methodEnter(Callable task) {
            return DecoratedCallable.maybeCreate(task);
        }
    }

    public static class RunnableMethodsAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.Argument(value=0, readOnly=false) Runnable task) {
            task = RunnableMethodsAdvice.methodEnter(task);
        }

        public static Runnable methodEnter(Runnable task) {
            return DecoratedRunnable.maybeCreate(task);
        }
    }
}

