/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.jar.bytebuddy.dynamic.loading;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.dynamic.loading.ClassLoadingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InjectionClassLoader
extends ClassLoader {
    private final boolean sealed;

    protected InjectionClassLoader(ClassLoader parent, boolean sealed) {
        super(parent);
        this.sealed = sealed;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public Class<?> defineClass(String name, byte[] binaryRepresentation) throws ClassNotFoundException {
        return this.defineClasses(Collections.singletonMap(name, binaryRepresentation)).get(name);
    }

    public Map<String, Class<?>> defineClasses(Map<String, byte[]> typeDefinitions) throws ClassNotFoundException {
        if (this.sealed) {
            throw new IllegalStateException("Cannot inject classes into a sealed class loader");
        }
        return this.doDefineClasses(typeDefinitions);
    }

    protected abstract Map<String, Class<?>> doDefineClasses(Map<String, byte[]> var1) throws ClassNotFoundException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strategy implements ClassLoadingStrategy<InjectionClassLoader>
    {
        INSTANCE;


        @Override
        public Map<TypeDescription, Class<?>> load(InjectionClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            if (classLoader == null) {
                throw new IllegalArgumentException("Cannot add types to bootstrap class loader: " + types);
            }
            LinkedHashMap<String, byte[]> typeDefinitions = new LinkedHashMap<String, byte[]>();
            HashMap<String, TypeDescription> typeDescriptions = new HashMap<String, TypeDescription>();
            for (Map.Entry<TypeDescription, byte[]> entry : types.entrySet()) {
                typeDefinitions.put(entry.getKey().getName(), entry.getValue());
                typeDescriptions.put(entry.getKey().getName(), entry.getKey());
            }
            HashMap loadedTypes = new HashMap();
            try {
                for (Map.Entry<String, Class<?>> entry : classLoader.defineClasses(typeDefinitions).entrySet()) {
                    loadedTypes.put((TypeDescription)typeDescriptions.get(entry.getKey()), entry.getValue());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException("Cannot load classes: " + types, classNotFoundException);
            }
            return loadedTypes;
        }
    }
}

