/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.interception;

import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.AgentBuilder;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.dynamic.DynamicType;
import software.amazon.disco.agent.jar.bytebuddy.utility.JavaModule;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

class InterceptionListener
implements AgentBuilder.Listener {
    private static Logger log = LogManager.getLogger(InterceptionListener.class);
    private final String prefix;
    private final boolean shouldTrace = LogManager.isTraceEnabled();

    private InterceptionListener(Installable installable) {
        this.prefix = installable.getClass().getName();
    }

    static InterceptionListener create(Installable installable) {
        return new InterceptionListener(installable);
    }

    @Override
    public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        if (this.shouldTrace) {
            log.trace("DiSCo(Core) " + this.prefix + " discovered " + typeName + (loaded ? " (after" : " (before") + " loading)");
        }
    }

    @Override
    public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded, DynamicType dynamicType) {
        log.debug("DiSCo(Core) " + this.prefix + " transforming " + typeDescription.getName() + (loaded ? " (after" : " (before") + " loading)");
    }

    @Override
    public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded) {
        if (this.shouldTrace) {
            log.trace("DiSCo(Core) " + this.prefix + " ignoring " + typeDescription.getName() + (loaded ? " (after" : " (before") + " loading)");
        }
    }

    @Override
    public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
        log.warn("DiSCo(Core) " + this.prefix + " failed to transform " + typeName + (loaded ? " (after" : " (before") + " loading) in classloader " + classLoader.toString(), throwable);
    }

    @Override
    public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        if (this.shouldTrace) {
            log.trace("DiSCo(Core) " + this.prefix + " completed " + typeName + (loaded ? "(after" : "(before") + " loading)");
        }
    }
}

