/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.event;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import software.amazon.disco.agent.event.Event;
import software.amazon.disco.agent.event.Listener;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

public class EventBus {
    private static Logger log = LogManager.getLogger(EventBus.class);
    static Map<Integer, Set<Listener>> listeners;

    private static void init() {
        listeners = new TreeMap<Integer, Set<Listener>>();
    }

    public static void publish(Event e) {
        if (e == null) {
            return;
        }
        if (LogManager.isDebugEnabled()) {
            log.debug("DiSCo(Core) publishing event " + e + " from origin " + e.getOrigin());
        }
        for (Set<Listener> listenerSet : listeners.values()) {
            for (Listener l : listenerSet) {
                l.listen(e);
            }
        }
    }

    public static void addListener(Listener l) {
        if (l == null) {
            return;
        }
        if (!listeners.containsKey(l.getPriority())) {
            listeners.put(l.getPriority(), new HashSet());
        }
        listeners.get(l.getPriority()).add(l);
    }

    public static void removeListener(Listener l) {
        if (l == null) {
            return;
        }
        if (listeners.containsKey(l.getPriority())) {
            listeners.get(l.getPriority()).remove(l);
        }
    }

    public static void removeAllListeners() {
        EventBus.init();
    }

    public static boolean isListenerPresent(Listener listener) {
        Collection listenersByPriority = listeners.get(listener.getPriority());
        return listenersByPriority != null && listenersByPriority.contains(listener);
    }

    static {
        EventBus.init();
    }
}

