/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.lang.reflect.Type;
import software.amazon.disco.agent.concurrent.decorate.DecoratedThread;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.AgentBuilder;
import software.amazon.disco.agent.jar.bytebuddy.asm.Advice;
import software.amazon.disco.agent.jar.bytebuddy.description.method.MethodDescription;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatcher;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatchers;

class ThreadSubclassInterceptor
implements Installable {
    public static final String DISCO_DECORATION_FIELD_NAME = "discoDecoration";

    ThreadSubclassInterceptor() {
    }

    @Override
    public AgentBuilder install(AgentBuilder agentBuilder) {
        return agentBuilder.type(ThreadSubclassInterceptor.createThreadSubclassTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.defineField(DISCO_DECORATION_FIELD_NAME, (Type)((Object)DecoratedThread.class), 4).method(ThreadSubclassInterceptor.createStartMethodMatcher()).intercept(Advice.to(StartAdvice.class)).method(ThreadSubclassInterceptor.createRunMethodMatcher()).intercept(Advice.to(RunAdvice.class)));
    }

    static ElementMatcher.Junction<? super TypeDescription> createThreadSubclassTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("java.lang.Thread")).and(ElementMatchers.not(ElementMatchers.named("java.lang.Thread")));
    }

    static ElementMatcher.Junction<? super MethodDescription> createRunMethodMatcher() {
        return ElementMatchers.named("run").and(ElementMatchers.takesArguments(0));
    }

    static ElementMatcher.Junction<? super MethodDescription> createStartMethodMatcher() {
        return ElementMatchers.named("start").and(ElementMatchers.takesArguments(0));
    }

    public static class RunAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.FieldValue(value="discoDecoration") DecoratedThread discoDecoration) {
            RunAdvice.methodEnter(discoDecoration);
        }

        public static void methodEnter(DecoratedThread discoDecoration) {
            try {
                discoDecoration.before();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class)
        public static void onMethodExit(@Advice.FieldValue(value="discoDecoration") DecoratedThread discoDecoration) {
            RunAdvice.methodExit(discoDecoration);
        }

        public static void methodExit(DecoratedThread discoDecoration) {
            try {
                discoDecoration.after();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class StartAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.FieldValue(readOnly=false, value="discoDecoration") DecoratedThread discoDecoration) {
            discoDecoration = StartAdvice.methodEnter();
        }

        public static DecoratedThread methodEnter() {
            try {
                return new DecoratedThread();
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

