/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import software.amazon.disco.agent.concurrent.InterceptorUtils;
import software.amazon.disco.agent.concurrent.decorate.DecoratedRunnableScheduledFuture;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.AgentBuilder;
import software.amazon.disco.agent.jar.bytebuddy.asm.Advice;
import software.amazon.disco.agent.jar.bytebuddy.description.method.MethodDescription;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatcher;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

class ScheduledThreadPoolExecutorInterceptor
implements Installable {
    private static Logger log = LogManager.getLogger(ScheduledThreadPoolExecutorInterceptor.class);

    ScheduledThreadPoolExecutorInterceptor() {
    }

    @Override
    public AgentBuilder install(AgentBuilder agentBuilder) {
        return InterceptorUtils.configureRedefinition(agentBuilder).type(ScheduledThreadPoolExecutorInterceptor.createTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.visit(Advice.to(DecorateTaskAdvice.class).on(ScheduledThreadPoolExecutorInterceptor.createMethodMatcher())));
    }

    static ElementMatcher.Junction<? super TypeDescription> createTypeMatcher() {
        return ElementMatchers.isSubTypeOf(ScheduledThreadPoolExecutor.class);
    }

    static ElementMatcher.Junction<? super MethodDescription> createMethodMatcher() {
        return ElementMatchers.named("decorateTask");
    }

    public static class DecorateTaskAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.Argument(value=1, readOnly=false) RunnableScheduledFuture task) {
            try {
                task = DecorateTaskAdvice.decorate(task);
            }
            catch (Throwable t) {
                DecorateTaskAdvice.captureThrowableForDebugging(t);
            }
        }

        public static RunnableScheduledFuture decorate(RunnableScheduledFuture task) {
            return DecoratedRunnableScheduledFuture.maybeCreate(task);
        }

        public static void captureThrowableForDebugging(Throwable t) {
            log.error("DiSCo(Concurrency) failed to decorate RunnableScheduledFuture for ScheduledThreadPoolExecutor", t);
        }
    }
}

