/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.multipreprocessor;

import java.io.File;
import software.amazon.disco.agent.inject.Injector;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.instrumentation.preprocess.cli.Driver;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfigParser;
import software.amazon.disco.instrumentation.preprocess.instrumentation.StaticInstrumentationTransformer;
import software.amazon.disco.instrumentation.preprocess.loaders.agents.DiscoAgentLoader;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.DirectoryLoader;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.JarLoader;

public class PreprocessorDriver {
    private static final Logger log = LogManager.getLogger(PreprocessorDriver.class);

    public static void main(String[] args) {
        try {
            PreprocessConfig config = new PreprocessConfigParser().parseCommandLine(args);
            Injector.addToBootstrapClasspath(Injector.createInstrumentation(), new File(config.getAgentPath()));
            Driver.configureLog(config.getLogLevel());
            StaticInstrumentationTransformer.builder().agentLoader(new DiscoAgentLoader()).classFileLoader(JarLoader.class, new JarLoader()).classFileLoader(DirectoryLoader.class, new DirectoryLoader()).config(config).build().transform();
        }
        catch (Exception e) {
            log.fatal("Disco(Instrumentation preprocess) - Preprocessor aborted", e);
            e.printStackTrace();
            System.exit(1);
        }
    }
}

