/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.instrumentation.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.exceptions.PreprocessCacheException;
import software.amazon.disco.instrumentation.preprocess.instrumentation.cache.CacheStrategy;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.JDKModuleLoader;
import software.amazon.disco.instrumentation.preprocess.util.FileUtils;

public class ChecksumCacheStrategy
implements CacheStrategy {
    static final String SIMPLE_NAME = "checksum";
    static final String MANIFEST_FILE_NAME = "preprocessing_cache.properties";
    static final String PLUGINS_CHECKSUM_PROPERTY_KEY = "PLUGINS_CHECKSUM";
    static final String AGENT_CHECKSUM_PROPERTY_KEY = "AGENT_CHECKSUM";
    static final String PREPROCESSOR_CHECKSUM_PROPERTY_KEY = "PREPROCESSOR_CHECKSUM";
    static final String JAVA_RUNTIME_BASE_MODULE_CHECKSUM_PROPERTY_KEY = "JAVA_RUNTIME_BASE_MODULE_CHECKSUM";
    static final String PREPROCESSOR_CONFIG_STRING_PROPERTY_KEY = "PREPROCESSOR_CONFIG_STRING";
    static final String TEMPORARY_MANIFEST_FOLDER_NAME = "tmp/cache_manifest_files";
    private static final Logger logger = LogManager.getLogger(ChecksumCacheStrategy.class);
    private static final String CHECK_SUM_ALGORITHM = "md5";
    private static final Set<String> INSTRUMENTATION_CONTEXT_PROPERTIES = new HashSet<String>();
    Properties runtimeCache = new Properties();
    Map<String, String> currentInstrumentationContext = new HashMap<String, String>();

    @Override
    public String getSimpleName() {
        return SIMPLE_NAME;
    }

    @Override
    public void loadManifestFileToRuntimeCache(PreprocessConfig config) throws PreprocessCacheException {
        logger.info("Disco(Instrumentation preprocess) - Initializing ChecksumCacheStrategy...");
        this.currentInstrumentationContext = this.computeCurrentInstrumentationContext(config);
        File cacheManifestFile = new File(config.getOutputDir(), MANIFEST_FILE_NAME);
        logger.debug("Disco(Instrumentation preprocess) - Scanning for manifest file at: " + cacheManifestFile.getAbsolutePath());
        if (!cacheManifestFile.exists()) {
            logger.info("Disco(Instrumentation preprocess) - Manifest file doesn't exist. All input sources will be processed.");
        } else {
            this.runtimeCache = this.readPropertiesFromFile(cacheManifestFile);
            logger.info("Disco(Instrumentation preprocess) - Runtime cache constructed from loaded manifest file.");
            this.validateCachedInstrumentationContext();
        }
        this.runtimeCache.putAll(this.currentInstrumentationContext);
        File temporaryManifestDir = new File(config.getOutputDir(), TEMPORARY_MANIFEST_FOLDER_NAME);
        if (temporaryManifestDir.exists()) {
            for (File manifestFile : temporaryManifestDir.listFiles()) {
                manifestFile.delete();
            }
        }
    }

    @Override
    public boolean isSourceCached(Path path) throws PreprocessCacheException {
        if (this.runtimeCache.isEmpty()) {
            return false;
        }
        String checksum = this.computeChecksum(path);
        return checksum == null ? false : checksum.equals(this.runtimeCache.getProperty(path.toString()));
    }

    @Override
    public void cacheSource(Path path) throws PreprocessCacheException {
        logger.debug("Disco(Instrumentation preprocess) - Caching: " + path);
        if (path == null) {
            return;
        }
        String checksum = this.computeChecksum(path);
        if (checksum == null) {
            return;
        }
        this.runtimeCache.setProperty(path.toString(), checksum);
    }

    void validateCachedInstrumentationContext() throws PreprocessCacheException {
        for (String property : INSTRUMENTATION_CONTEXT_PROPERTIES) {
            String propertyValue = this.runtimeCache.getProperty(property);
            if (propertyValue != null) continue;
            throw new PreprocessCacheException("Property missing from loaded manifest file: " + property);
        }
        List<String> instrumentationContextDeltaList = this.computeInstrumentationContextDelta(this.runtimeCache, this.currentInstrumentationContext);
        if (!instrumentationContextDeltaList.isEmpty()) {
            logger.info("Disco(Instrumentation preprocess) - Instrumentation context has changed compared to previous build, cache will be reset.");
            for (String element : instrumentationContextDeltaList) {
                logger.debug("Disco(Instrumentation preprocess) - Instrumentation context has changed compared for: " + element);
            }
            this.runtimeCache.clear();
        }
    }

    String computeChecksum(Path path) throws PreprocessCacheException {
        if (path == null) {
            logger.debug("Disco(Instrumentation preprocess) - Path provided to compute its checksum is null, skipping.");
            return null;
        }
        if (!path.toFile().exists()) {
            logger.debug("Disco(Instrumentation preprocess) - Path provided to compute its checksum does not exist, skipping.");
            return null;
        }
        if (path.toFile().isDirectory()) {
            logger.debug("Disco(Instrumentation preprocess) - Path provided to compute its checksum a directory, skipping.");
            return null;
        }
        try {
            MessageDigest msgDst = MessageDigest.getInstance(CHECK_SUM_ALGORITHM);
            byte[] fileContent = Files.readAllBytes(path);
            byte[] msgArr = msgDst.digest(fileContent);
            return new BigInteger(1, msgArr).toString(16);
        }
        catch (Exception e) {
            throw new PreprocessCacheException("Disco(Instrumentation preprocess) - Failed to compute checksum for file: " + path.toString(), e);
        }
    }

    String computeChecksumForPlugins(PreprocessConfig config) throws PreprocessCacheException {
        StringBuilder pluginChecksumPropertyBuilder = new StringBuilder();
        Object[] plugins = FileUtils.scanPluginsFromAgentConfig(config.getAgentArg()).toArray(new File[0]);
        Arrays.sort(plugins);
        for (Object plugin : plugins) {
            pluginChecksumPropertyBuilder.append(pluginChecksumPropertyBuilder.length() == 0 ? "" : ",").append(((File)plugin).getAbsolutePath()).append("=").append(this.computeChecksum(((File)plugin).toPath()));
        }
        return pluginChecksumPropertyBuilder.toString();
    }

    @Override
    public void serializeRuntimeCacheToTempManifestFile(PreprocessConfig config) throws PreprocessCacheException {
        logger.info("Disco(Instrumentation preprocess) - Serializing runtime cache to manifest file at: " + config.getOutputDir());
        logger.debug("Disco(Instrumentation preprocess) - " + this.runtimeCache.size() + " entries will be stored in the manifest file.");
        try {
            if (this.runtimeCache.isEmpty()) {
                logger.info("Disco(Instrumentation preprocess) - No input sources were cached, skipping serialization.");
                return;
            }
            File temporaryManifest = FileUtils.createTemporaryManifestFile(new File(config.getOutputDir(), TEMPORARY_MANIFEST_FOLDER_NAME));
            try (FileOutputStream fileOutputStream = new FileOutputStream(temporaryManifest);){
                this.runtimeCache.putAll(this.computeCurrentInstrumentationContext(config));
                this.runtimeCache.store(fileOutputStream, null);
            }
        }
        catch (Exception e) {
            throw new PreprocessCacheException("Failed to serialize runtime cache to temporary manifest file.", e);
        }
    }

    @Override
    public void mergeTempCacheManifests(File outputDir) throws PreprocessCacheException {
        File temporaryManifestsDir = new File(outputDir, TEMPORARY_MANIFEST_FOLDER_NAME);
        if (!temporaryManifestsDir.exists() || temporaryManifestsDir.listFiles().length == 0) {
            return;
        }
        logger.info("Disco(Instrumentation preprocess) - Merging " + temporaryManifestsDir.listFiles().length + " temporary manifest files.");
        for (File manifest : temporaryManifestsDir.listFiles()) {
            if (manifest.isDirectory()) {
                return;
            }
            Properties propertiesToBeMerged = this.readPropertiesFromFile(manifest);
            logger.debug("Disco(Instrumentation preprocess) - Attempting to merge: " + manifest.getAbsolutePath());
            List<String> instrumentationContextDeltaList = this.computeInstrumentationContextDelta(this.runtimeCache, propertiesToBeMerged);
            if (!instrumentationContextDeltaList.isEmpty()) {
                for (String element : instrumentationContextDeltaList) {
                    logger.error("Disco(Instrumentation preprocess) - Inconsistent instrumentation context element: " + element);
                }
                throw new PreprocessCacheException("Preprocessor checksum retrieved from temporary manifest is inconsistent with the one stored in the runtime cache. Please perform a clean build.");
            }
            this.runtimeCache.putAll((Map<?, ?>)propertiesToBeMerged);
            logger.debug("Disco(Instrumentation preprocess) - Manifest file merged successfully.");
        }
        File cacheManifestFile = new File(outputDir, MANIFEST_FILE_NAME);
        try (FileOutputStream fileOutputStream = new FileOutputStream(cacheManifestFile);){
            this.runtimeCache.store(fileOutputStream, null);
            logger.info("Disco(Instrumentation preprocess) - Serialized runtime cache to manifest file: " + cacheManifestFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new PreprocessCacheException("Failed to serialize manifest to file: " + cacheManifestFile.getAbsolutePath(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Properties readPropertiesFromFile(File file) throws PreprocessCacheException {
        logger.debug("Disco(Instrumentation preprocess) - Loading manifest file: " + file.getAbsolutePath());
        try (FileInputStream input = new FileInputStream(file);){
            Properties properties = new Properties();
            properties.load(input);
            logger.debug("Disco(Instrumentation preprocess) - Manifest file loaded");
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new PreprocessCacheException("Failed to read file: " + file.getAbsolutePath(), e);
        }
    }

    Map<String, String> computeCurrentInstrumentationContext(PreprocessConfig config) throws PreprocessCacheException {
        HashMap<String, String> instrumentationContext = new HashMap<String, String>();
        instrumentationContext.put(AGENT_CHECKSUM_PROPERTY_KEY, this.computeChecksum(Paths.get(config.getAgentPath(), new String[0])));
        instrumentationContext.put(PLUGINS_CHECKSUM_PROPERTY_KEY, this.computeChecksumForPlugins(config));
        instrumentationContext.put(PREPROCESSOR_CHECKSUM_PROPERTY_KEY, this.computeChecksum(this.getPreprocessorJarPath()));
        instrumentationContext.put(PREPROCESSOR_CONFIG_STRING_PROPERTY_KEY, config.toStringForCaching());
        instrumentationContext.put(JAVA_RUNTIME_BASE_MODULE_CHECKSUM_PROPERTY_KEY, this.computeChecksum(new JDKModuleLoader().getJDKBaseModule(System.getProperty("java.home")).toPath()));
        return instrumentationContext;
    }

    List<String> computeInstrumentationContextDelta(Map context, Map contextOther) {
        ArrayList<String> delta = new ArrayList<String>();
        for (String property : INSTRUMENTATION_CONTEXT_PROPERTIES) {
            if (context.get(property).equals(contextOther.get(property))) continue;
            logger.debug("Disco(Instrumentation preprocess) - The value of the instrumentation context property is inconsistent: " + property);
            delta.add(property);
        }
        return delta;
    }

    Path getPreprocessorJarPath() throws PreprocessCacheException {
        CodeSource codeSource = CacheStrategy.class.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            throw new PreprocessCacheException("Failed to determine path to the preprocessor Jar. Code source is null.");
        }
        try {
            return new File(codeSource.getLocation().toURI().getPath()).toPath();
        }
        catch (Exception e) {
            throw new PreprocessCacheException("Failed to determine path to the Preprocessor Jar.", e);
        }
    }

    static {
        INSTRUMENTATION_CONTEXT_PROPERTIES.addAll(Arrays.asList(PLUGINS_CHECKSUM_PROPERTY_KEY, AGENT_CHECKSUM_PROPERTY_KEY, PREPROCESSOR_CHECKSUM_PROPERTY_KEY, JAVA_RUNTIME_BASE_MODULE_CHECKSUM_PROPERTY_KEY, PREPROCESSOR_CONFIG_STRING_PROPERTY_KEY));
    }
}

