/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.export;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.exceptions.ExportException;
import software.amazon.disco.instrumentation.preprocess.exceptions.JarEntryCopyException;
import software.amazon.disco.instrumentation.preprocess.instrumentation.InstrumentationArtifact;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.SourceInfo;
import software.amazon.disco.instrumentation.preprocess.util.FileUtils;

public abstract class ExportStrategy {
    private static final Logger log = LogManager.getLogger(ExportStrategy.class);

    public abstract File export(SourceInfo var1, Map<String, InstrumentationArtifact> var2, PreprocessConfig var3, String var4);

    protected File createOutputFile(String rootOutputDir, String relativeParentPath, String filePath) {
        try {
            File outputFile = Paths.get(rootOutputDir, relativeParentPath, filePath).toFile();
            outputFile.getParentFile().mkdirs();
            outputFile.createNewFile();
            return outputFile;
        }
        catch (IOException e) {
            throw new ExportException("Failed to create output file for: " + String.join((CharSequence)"/", filePath), e);
        }
    }

    protected void copyJarEntry(JarOutputStream jarOS, JarFile file, JarEntry entry) {
        try {
            log.trace("Disco(Instrumentation preprocess) - Copying entry: " + entry.getName());
            jarOS.putNextEntry(new JarEntry(entry.getName()));
            jarOS.write(FileUtils.readEntryFromJar(file, entry));
            jarOS.closeEntry();
        }
        catch (Throwable t) {
            if (t instanceof IOException && entry.getName().startsWith("META-INF/")) {
                log.trace("Disco(Instrumentation preprocess) - Duplicated entry ignored: " + entry.getName());
            }
            throw new JarEntryCopyException(entry.getName(), t);
        }
    }

    protected void saveInstrumentationArtifactsToJar(JarOutputStream jarOS, Map<String, InstrumentationArtifact> artifacts) {
        log.debug("Disco(Instrumentation preprocess) - Transformed " + artifacts.size() + " classes.");
        for (Map.Entry<String, InstrumentationArtifact> mapEntry : artifacts.entrySet()) {
            String classPath = mapEntry.getKey();
            InstrumentationArtifact info = mapEntry.getValue();
            JarEntry entry = new JarEntry(classPath + ".class");
            log.trace("Disco(Instrumentation preprocess) - Copying instrumented entry: " + entry.getName());
            try {
                jarOS.putNextEntry(entry);
                jarOS.write(info.getClassBytes());
                jarOS.closeEntry();
            }
            catch (IOException e) {
                throw new ExportException(classPath, e);
            }
        }
    }
}

