/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import software.amazon.disco.agent.config.AgentConfig;

public class AgentConfigParser {
    protected static final String CONFIG_FILE_NAME = "disco.config";

    public AgentConfig parseCommandLine(String args) {
        AgentConfig result = new AgentConfig(new ArrayList<String>());
        if (args != null && !args.isEmpty()) {
            LinkedHashMap<String, String> argsMap = this.parseArgsStringToMap(args);
            for (Map.Entry<String, String> argPair : argsMap.entrySet()) {
                this.applyArgToConfig(result, argPair.getKey(), argPair.getValue());
            }
        }
        this.applyConfigOverride(result);
        return result;
    }

    protected LinkedHashMap<String, String> parseArgsStringToMap(String argStr) {
        LinkedHashMap<String, String> argsMap = new LinkedHashMap<String, String>();
        if (argStr == null || argStr.isEmpty()) {
            return argsMap;
        }
        String[] individualArgs = argStr.split("(?<!\\\\):");
        this.insertArgsToMap(individualArgs, argsMap);
        return argsMap;
    }

    private void insertArgsToMap(String[] individualArgs, Map<String, String> argsMap) {
        for (String arg : individualArgs) {
            String[] pair = arg.split("(?<!\\\\)=");
            String value = pair.length > 1 ? pair[1].replaceAll("\\\\:", ":").replaceAll("\\\\=", "=") : "";
            argsMap.put(pair[0], value);
        }
    }

    private void applyArgToConfig(AgentConfig config, String argKey, String argValue) {
        switch (argKey.toLowerCase(Locale.ROOT)) {
            case "runtimeonly": {
                if (argValue.isEmpty() || argValue.equalsIgnoreCase("true")) {
                    config.setRuntimeOnly(true);
                    break;
                }
                if (!argValue.equalsIgnoreCase("false")) break;
                config.setRuntimeOnly(false);
                break;
            }
            case "pluginpath": {
                config.setPluginPath(argValue);
                break;
            }
            case "verbose": {
                config.setVerbose(true);
                break;
            }
            case "extraverbose": {
                config.setExtraverbose(true);
                break;
            }
            case "loggerfactory": {
                config.setLoggerFactoryClass(argValue);
                break;
            }
        }
        String argPair = argKey + (argValue == null || argValue.isEmpty() ? "" : "=" + argValue);
        config.getArgs().add(argPair);
    }

    protected void applyConfigOverride(AgentConfig config) {
        List<String> argsListFromConfigFile = this.readConfigFileFromPluginPath(config.getPluginPath());
        if (argsListFromConfigFile == null || argsListFromConfigFile.isEmpty()) {
            return;
        }
        LinkedHashMap<String, String> argsMap = new LinkedHashMap<String, String>();
        this.insertArgsToMap(argsListFromConfigFile.toArray(new String[1]), argsMap);
        for (Map.Entry<String, String> argPair : argsMap.entrySet()) {
            if (argPair.getKey().equalsIgnoreCase("pluginpath")) {
                System.err.println("Disco(Agent) overwriting the 'pluginPath' agent argument is not supported. Value supplied will be ignored.");
                continue;
            }
            this.applyArgToConfig(config, argPair.getKey(), argPair.getValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<String> readConfigFileFromPluginPath(String pluginPath) {
        if (pluginPath == null) {
            return null;
        }
        File configFile = new File(pluginPath, CONFIG_FILE_NAME);
        if (!configFile.exists()) return null;
        if (!configFile.isFile()) {
            return null;
        }
        try (Scanner scanner = new Scanner(configFile);){
            ArrayList<String> argsRead = new ArrayList<String>();
            while (scanner.hasNextLine()) {
                String arg = scanner.nextLine().trim();
                if (arg.isEmpty()) continue;
                argsRead.add(arg);
            }
            ArrayList<String> arrayList = argsRead;
            return arrayList;
        }
        catch (IOException | IllegalArgumentException e) {
            System.err.println("Disco(Agent) failed to load config override file: " + e.getMessage());
            return null;
        }
    }
}

