/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.loaders.classfiles;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.export.DirectoryExportStrategy;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.ClassFileLoader;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.SourceInfo;

public class DirectoryLoader
implements ClassFileLoader {
    private static final Logger log = LogManager.getLogger(DirectoryLoader.class);

    @Override
    public SourceInfo load(Path source, PreprocessConfig config) {
        log.debug("Disco(Instrumentation preprocess) - Loading Directory: " + source);
        try {
            ClassFileScanner locator = new ClassFileScanner(source);
            Files.walkFileTree(source, locator);
            if (!locator.getClassFilesLocated().isEmpty()) {
                return new SourceInfo(source.toFile(), new DirectoryExportStrategy(), locator.getClassFilesLocated());
            }
            return null;
        }
        catch (Throwable t) {
            log.warn("Disco(Instrumentation preprocess) - Failed to load directory: " + source);
            return null;
        }
    }

    public static class ClassFileScanner
    extends SimpleFileVisitor<Path> {
        private Map<String, byte[]> classFilesLocated = new HashMap<String, byte[]>();
        private Path root;

        public ClassFileScanner(Path root) {
            this.root = root;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) throws IOException {
            if (!attr.isDirectory() && file.toString().endsWith(".class")) {
                Path fullPath = Paths.get(file.toFile().getAbsolutePath(), new String[0]);
                Path relativePath = this.root.relativize(fullPath);
                String fullyQualifiedClassName = relativePath.toString().substring(0, relativePath.toString().indexOf(".class")).replace("/", ".");
                this.classFilesLocated.put(fullyQualifiedClassName, Files.readAllBytes(file));
            }
            return FileVisitResult.CONTINUE;
        }

        public Map<String, byte[]> getClassFilesLocated() {
            return this.classFilesLocated;
        }
    }
}

