/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.instrumentation;

import java.util.List;

public class InstrumentationOutcome {
    private Status status;
    private String source;
    private List<String> failedClasses;

    public boolean hasFailed() {
        return this.failedClasses != null && !this.failedClasses.isEmpty();
    }

    InstrumentationOutcome(Status status, String source, List<String> failedClasses) {
        this.status = status;
        this.source = source;
        this.failedClasses = failedClasses;
    }

    public static InstrumentationOutcomeBuilder builder() {
        return new InstrumentationOutcomeBuilder();
    }

    public Status getStatus() {
        return this.status;
    }

    public String getSource() {
        return this.source;
    }

    public List<String> getFailedClasses() {
        return this.failedClasses;
    }

    public static class InstrumentationOutcomeBuilder {
        private Status status;
        private String source;
        private List<String> failedClasses;

        InstrumentationOutcomeBuilder() {
        }

        public InstrumentationOutcomeBuilder status(Status status) {
            this.status = status;
            return this;
        }

        public InstrumentationOutcomeBuilder source(String source) {
            this.source = source;
            return this;
        }

        public InstrumentationOutcomeBuilder failedClasses(List<String> failedClasses) {
            this.failedClasses = failedClasses;
            return this;
        }

        public InstrumentationOutcome build() {
            return new InstrumentationOutcome(this.status, this.source, this.failedClasses);
        }

        public String toString() {
            return "InstrumentationOutcome.InstrumentationOutcomeBuilder(status=" + (Object)((Object)this.status) + ", source=" + this.source + ", failedClasses=" + this.failedClasses + ")";
        }
    }

    public static enum Status {
        COMPLETED,
        WARNING_OCCURRED,
        NO_OP;

    }
}

