/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;

public class PreprocessConfig {
    private final Map<String, Set<String>> sourcePaths;
    private final String outputDir;
    private final String agentPath;
    private final String suffix;
    private final Level logLevel;
    private final String serializationJarPath;
    private final String javaVersion;
    private final String agentArg;
    private final String jdkPath;
    private final boolean failOnUnresolvableDependency;

    public Level getLogLevel() {
        if (this.logLevel == null) {
            return Level.INFO;
        }
        return this.logLevel;
    }

    PreprocessConfig(Map<String, Set<String>> sourcePaths, String outputDir, String agentPath, String suffix, Level logLevel, String serializationJarPath, String javaVersion, String agentArg, String jdkPath, boolean failOnUnresolvableDependency) {
        this.sourcePaths = sourcePaths;
        this.outputDir = outputDir;
        this.agentPath = agentPath;
        this.suffix = suffix;
        this.logLevel = logLevel;
        this.serializationJarPath = serializationJarPath;
        this.javaVersion = javaVersion;
        this.agentArg = agentArg;
        this.jdkPath = jdkPath;
        this.failOnUnresolvableDependency = failOnUnresolvableDependency;
    }

    public static PreprocessConfigBuilder builder() {
        return new PreprocessConfigBuilder();
    }

    public Map<String, Set<String>> getSourcePaths() {
        return this.sourcePaths;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public String getAgentPath() {
        return this.agentPath;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getSerializationJarPath() {
        return this.serializationJarPath;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getAgentArg() {
        return this.agentArg;
    }

    public String getJdkPath() {
        return this.jdkPath;
    }

    public boolean isFailOnUnresolvableDependency() {
        return this.failOnUnresolvableDependency;
    }

    public static class PreprocessConfigBuilder {
        private ArrayList<String> sourcePaths$key;
        private ArrayList<Set<String>> sourcePaths$value;
        private String outputDir;
        private String agentPath;
        private String suffix;
        private Level logLevel;
        private String serializationJarPath;
        private String javaVersion;
        private String agentArg;
        private String jdkPath;
        private boolean failOnUnresolvableDependency;

        PreprocessConfigBuilder() {
        }

        public PreprocessConfigBuilder sourcePath(String sourcePathKey, Set<String> sourcePathValue) {
            if (this.sourcePaths$key == null) {
                this.sourcePaths$key = new ArrayList();
                this.sourcePaths$value = new ArrayList();
            }
            this.sourcePaths$key.add(sourcePathKey);
            this.sourcePaths$value.add(sourcePathValue);
            return this;
        }

        public PreprocessConfigBuilder sourcePaths(Map<? extends String, ? extends Set<String>> sourcePaths) {
            if (sourcePaths == null) {
                throw new NullPointerException("sourcePaths cannot be null");
            }
            if (this.sourcePaths$key == null) {
                this.sourcePaths$key = new ArrayList();
                this.sourcePaths$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Set<String>> $lombokEntry : sourcePaths.entrySet()) {
                this.sourcePaths$key.add($lombokEntry.getKey());
                this.sourcePaths$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public PreprocessConfigBuilder clearSourcePaths() {
            if (this.sourcePaths$key != null) {
                this.sourcePaths$key.clear();
                this.sourcePaths$value.clear();
            }
            return this;
        }

        public PreprocessConfigBuilder outputDir(String outputDir) {
            this.outputDir = outputDir;
            return this;
        }

        public PreprocessConfigBuilder agentPath(String agentPath) {
            this.agentPath = agentPath;
            return this;
        }

        public PreprocessConfigBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public PreprocessConfigBuilder logLevel(Level logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public PreprocessConfigBuilder serializationJarPath(String serializationJarPath) {
            this.serializationJarPath = serializationJarPath;
            return this;
        }

        public PreprocessConfigBuilder javaVersion(String javaVersion) {
            this.javaVersion = javaVersion;
            return this;
        }

        public PreprocessConfigBuilder agentArg(String agentArg) {
            this.agentArg = agentArg;
            return this;
        }

        public PreprocessConfigBuilder jdkPath(String jdkPath) {
            this.jdkPath = jdkPath;
            return this;
        }

        public PreprocessConfigBuilder failOnUnresolvableDependency(boolean failOnUnresolvableDependency) {
            this.failOnUnresolvableDependency = failOnUnresolvableDependency;
            return this;
        }

        public PreprocessConfig build() {
            Map<String, Set<String>> sourcePaths;
            switch (this.sourcePaths$key == null ? 0 : this.sourcePaths$key.size()) {
                case 0: {
                    sourcePaths = Collections.emptyMap();
                    break;
                }
                case 1: {
                    sourcePaths = Collections.singletonMap(this.sourcePaths$key.get(0), this.sourcePaths$value.get(0));
                    break;
                }
                default: {
                    sourcePaths = new LinkedHashMap(this.sourcePaths$key.size() < 0x40000000 ? 1 + this.sourcePaths$key.size() + (this.sourcePaths$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.sourcePaths$key.size(); ++$i) {
                        sourcePaths.put(this.sourcePaths$key.get($i), this.sourcePaths$value.get($i));
                    }
                    sourcePaths = Collections.unmodifiableMap(sourcePaths);
                }
            }
            return new PreprocessConfig(sourcePaths, this.outputDir, this.agentPath, this.suffix, this.logLevel, this.serializationJarPath, this.javaVersion, this.agentArg, this.jdkPath, this.failOnUnresolvableDependency);
        }

        public String toString() {
            return "PreprocessConfig.PreprocessConfigBuilder(sourcePaths$key=" + this.sourcePaths$key + ", sourcePaths$value=" + this.sourcePaths$value + ", outputDir=" + this.outputDir + ", agentPath=" + this.agentPath + ", suffix=" + this.suffix + ", logLevel=" + this.logLevel + ", serializationJarPath=" + this.serializationJarPath + ", javaVersion=" + this.javaVersion + ", agentArg=" + this.agentArg + ", jdkPath=" + this.jdkPath + ", failOnUnresolvableDependency=" + this.failOnUnresolvableDependency + ")";
        }
    }
}

