/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse;
import software.amazon.dax.com.amazon.dax.bits.DaxCborInputStream;
import software.amazon.dax.com.amazon.dax.bits.dynamodb.DynamoNumerals;
import software.amazon.dax.dynamodb.DaxResponseDecoder;
import software.amazon.dax.dynamodb.SimpleCache;
import software.amazon.dax.dynamodb.TransactionResponseHandler;
import software.amazon.dax.exceptions.MalformedResultException;

public class TransactWriteItemsResponseHandler
extends TransactionResponseHandler<TransactWriteItemsResponse> {
    private final AtomicReference<Map<String, List<AttributeDefinition>>> keyDefPerTable;
    private final AtomicReference<List<Map<String, AttributeValue>>> keysPerRequest;
    private final SimpleCache<Long, List<String>> attrListCache;
    private final TransactWriteItemsRequest request;

    public TransactWriteItemsResponseHandler(CompletableFuture<TransactWriteItemsResponse> completableFuture, AtomicReference<Map<String, List<AttributeDefinition>>> keyDefPerTable, AtomicReference<List<Map<String, AttributeValue>>> keysPerRequest, SimpleCache<Long, List<String>> attrListCache, TransactWriteItemsRequest request) {
        super(completableFuture, keysPerRequest, attrListCache);
        this.keyDefPerTable = keyDefPerTable;
        this.keysPerRequest = keysPerRequest;
        this.attrListCache = attrListCache;
        this.request = request;
    }

    @Override
    public void decode(DaxCborInputStream in, CompletableFuture<TransactWriteItemsResponse> completableFuture) throws Exception {
        ArrayList<ConsumedCapacity> consumedCapacities;
        int arrayLen = in.readArrayLength();
        if (arrayLen != 3) {
            throw new UnsupportedEncodingException("TransactWriteResponse needs to have 3 elements, instead had: " + arrayLen);
        }
        int numItems = in.readArrayLength();
        for (int i = 0; i < numItems; ++i) {
            if (in.tryReadNull()) continue;
            throw new MalformedResultException("TransactWriteResponse needs to have null items in itemResponses but was not null");
        }
        int consumedCapacityArrayLen = in.readArrayLength();
        ArrayList<ConsumedCapacity> arrayList = consumedCapacities = consumedCapacityArrayLen == 0 ? null : new ArrayList<ConsumedCapacity>(consumedCapacityArrayLen);
        while (consumedCapacityArrayLen-- > 0) {
            consumedCapacities.add(DaxResponseDecoder.decodeConsumedCapacityExtended(in));
        }
        int itemCollectionMetricsMapLength = in.readMapLength();
        HashMap transactWriteItemCollectionMetrics = itemCollectionMetricsMapLength == 0 ? null : new HashMap();
        for (int i = 0; i < itemCollectionMetricsMapLength; ++i) {
            String tableName = (String)in.readObject();
            List<AttributeDefinition> tableKeys = this.keyDefPerTable.get().get(tableName);
            int numberOfMetrics = in.readArrayLength();
            ArrayList<ItemCollectionMetrics> metricsList = new ArrayList<ItemCollectionMetrics>(numberOfMetrics);
            for (int j = 0; j < numberOfMetrics; ++j) {
                metricsList.add(DaxResponseDecoder.decodeItemCollectionMetrics(in, tableKeys));
            }
            transactWriteItemCollectionMetrics.put(tableName, metricsList);
        }
        TransactWriteItemsResponse.Builder response = TransactWriteItemsResponse.builder().consumedCapacity(consumedCapacities).itemCollectionMetrics(transactWriteItemCollectionMetrics);
        if (DynamoNumerals.ReturnConsumedCapacity.fromName(this.request.returnConsumedCapacityAsString()) != DynamoNumerals.ReturnConsumedCapacity.NONE) {
            response.consumedCapacity(DaxResponseDecoder.verifyBatchConsumedCapacity(consumedCapacities, this.keyDefPerTable.get().keySet()));
        }
        if (DynamoNumerals.ReturnItemCollectionMetrics.fromName(this.request.returnItemCollectionMetricsAsString()) != DynamoNumerals.ReturnItemCollectionMetrics.NONE && transactWriteItemCollectionMetrics == null) {
            response.itemCollectionMetrics(new HashMap());
        }
        completableFuture.complete((TransactWriteItemsResponse)response.build());
    }
}

