/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.channel;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import software.amazon.dax.channel.ChannelAttributeKey;
import software.amazon.dax.channel.RequestContext;
import software.amazon.dax.com.amazon.dax.bits.DaxCborInputStream;
import software.amazon.dax.exceptions.ExceptionHandler;

public abstract class ResponseHandler<T>
extends SimpleChannelInboundHandler<DaxCborInputStream> {
    private final CompletableFuture<T> completableFuture;

    public ResponseHandler(CompletableFuture<T> completableFuture) {
        this.completableFuture = completableFuture;
    }

    public CompletableFuture<T> getCompletableFuture() {
        return this.completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, DaxCborInputStream in) throws Exception {
        RequestContext requestContext = (RequestContext)ctx.channel().attr(ChannelAttributeKey.REQUEST_CONTEXT_KEY).get();
        CompletableFuture decodeFuture = new CompletableFuture();
        try {
            decodeFuture.whenComplete((r, e) -> {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (e != null) {
                    this.completableFuture.completeExceptionally((Throwable)ExceptionHandler.handleException(e, ctx.channel()));
                } else {
                    this.completableFuture.complete(r);
                }
            });
            this.decode(in, decodeFuture);
        }
        catch (Throwable t) {
            decodeFuture.completeExceptionally((Throwable)ExceptionHandler.handleException(t, ctx.channel()));
        }
        finally {
            requestContext.channelPool().release(ctx.channel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        RequestContext requestContext = (RequestContext)ctx.channel().attr(ChannelAttributeKey.REQUEST_CONTEXT_KEY).get();
        try {
            this.completableFuture.completeExceptionally((Throwable)ExceptionHandler.handleException(cause, ctx.channel()));
        }
        finally {
            requestContext.channelPool().release(ctx.channel());
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            this.exceptionCaught(ctx, new IOException("Channel closed"));
        }
        finally {
            super.channelInactive(ctx);
        }
    }

    public abstract void decode(DaxCborInputStream var1, CompletableFuture<T> var2) throws Exception;
}

