/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.com.amazon.cbor;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import software.amazon.dax.com.amazon.cbor.IntRef;
import software.amazon.dax.com.amazon.cbor.Utils;

public class Decoder {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final BigDecimal DECIMAL_TWO = BigDecimal.valueOf(2L);

    public static boolean verifyUtf8(byte[] src, int srcOffset, int srcLength) {
        int end = srcOffset + srcLength;
        block5: for (int i = srcOffset; i < end; ++i) {
            byte c = src[i];
            if (c >= 0) continue;
            switch (c >> 4 & 0xF) {
                case 15: {
                    if ((c & 8) != 0) {
                        return false;
                    }
                    if (++i >= end || (src[i] & 0xC0) != 128) {
                        return false;
                    }
                }
                case 14: {
                    if (++i >= end || (src[i] & 0xC0) != 128) {
                        return false;
                    }
                }
                case 12: 
                case 13: {
                    if (++i < end && (src[i] & 0xC0) == 128) continue block5;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static String decodeUtf8(byte[] src) {
        return Decoder.decodeUtf8(src, 0, src.length);
    }

    public static String decodeUtf8(byte[] src, int srcOffset, int srcLength) {
        if (srcLength == 0) {
            return "";
        }
        char[] chars = new char[srcLength];
        return new String(chars, 0, Decoder.decodeUtf8(src, srcOffset, srcLength, chars, 0));
    }

    public static int decodeUtf8(byte[] src, int srcOffset, int srcLength, char[] dst, int dstOffset) {
        int end = srcOffset + srcLength;
        block4: for (int i = srcOffset; i < end; ++i) {
            int c = src[i];
            if (c < 0) {
                switch (c >> 4 & 3) {
                    default: {
                        if (++i >= end) break block4;
                        c = (c & 0x1F) << 6 | src[i] & 0x3F;
                        break;
                    }
                    case 2: {
                        if (i + 2 >= end) break block4;
                        c = (c & 0xF) << 12 | (src[++i] & 0x3F) << 6 | src[++i] & 0x3F;
                        break;
                    }
                    case 3: {
                        if (i + 3 >= end) break block4;
                        if ((c = (c & 7) << 18 | (src[++i] & 0x3F) << 12 | (src[++i] & 0x3F) << 6 | src[++i] & 0x3F) < 65536) break;
                        dst[dstOffset++] = (char)(0xD800 | (c -= 65536) >> 10 & 0x3FF);
                        c = 0xDC00 | c & 0x3FF;
                    }
                }
            }
            dst[dstOffset++] = (char)c;
        }
        return dstOffset;
    }

    public static int decodeUtf8Length(byte[] src, int offset, int length) {
        int utf8Length = 0;
        int end = offset + length;
        block4: for (int i = offset; i < end; ++i) {
            int c = src[i];
            if (c < 0) {
                switch (c >> 4 & 3) {
                    default: {
                        if (++i < end) break;
                        break block4;
                    }
                    case 2: {
                        if (i + 2 < end) break;
                        break block4;
                    }
                    case 3: {
                        if (i + 3 >= end) break block4;
                        if ((c = (c & 7) << 18 | (src[++i] & 0x3F) << 12 | (src[++i] & 0x3F) << 6 | src[++i] & 0x3F) < 65536) break;
                        ++utf8Length;
                    }
                }
            }
            ++utf8Length;
        }
        return utf8Length;
    }

    public static String decodeUtf8(ByteBuffer buffer, int length) {
        if (buffer.hasArray()) {
            String str = Decoder.decodeUtf8(buffer.array(), buffer.arrayOffset(), length);
            buffer.position(buffer.position() + length);
            return str;
        }
        byte[] text = new byte[length];
        buffer.get(text);
        return Decoder.decodeUtf8(text, 0, length);
    }

    public static float float16to32(int f16) {
        int exp = f16 >> 10 & 0x1F;
        int fract = f16 & 0x3FF;
        if (exp == 0) {
            return (float)fract * 5.9604645E-8f * (float)(1 - (f16 >>> 14));
        }
        exp = exp == 31 ? 255 : exp + 112 & 0xFF;
        return Float.intBitsToFloat(f16 << 16 & Integer.MIN_VALUE | exp << 23 | fract << 13);
    }

    public static int skipCborItems(byte[] src, int offset, int count) {
        while (--count >= 0) {
            offset = Decoder.skipCborItem(src, offset);
        }
        return offset;
    }

    public static int skipCborItem(byte[] src, int offset) {
        int lenShift;
        int adjustMask;
        int type;
        block13: while (true) {
            type = src[offset++] & 0xFF;
            switch (type >> 5) {
                default: {
                    return Decoder.nextCborType(type, offset);
                }
                case 2: 
                case 3: {
                    adjustMask = -1;
                    lenShift = 31;
                    break block13;
                }
                case 4: {
                    adjustMask = 0;
                    lenShift = 0;
                    break block13;
                }
                case 5: {
                    adjustMask = 0;
                    lenShift = 1;
                    break block13;
                }
                case 6: {
                    offset = Decoder.nextCborType(type, offset);
                    continue block13;
                }
            }
            break;
        }
        int len = 0;
        switch (type &= 0x1F) {
            default: {
                len = type;
                break;
            }
            case 27: {
                len = (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | src[offset++] & 0xFF;
                if (len != 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
            }
            case 26: {
                len = len | (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16;
                if (len < 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
            }
            case 25: {
                len |= (src[offset++] & 0xFF) << 8;
            }
            case 24: {
                len |= src[offset++] & 0xFF;
                break;
            }
            case 31: {
                while (src[offset = Decoder.skipCborItem(src, offset)] != -1) {
                }
                return offset + 1;
            }
        }
        offset += len & adjustMask;
        len <<= lenShift;
        while (len > 0) {
            offset = Decoder.skipCborItem(src, offset);
            --len;
        }
        return offset;
    }

    public static int nextCborType(int type, int offset) {
        switch (type & 0x1F) {
            default: {
                return offset;
            }
            case 24: {
                return offset + 1;
            }
            case 25: {
                return offset + 2;
            }
            case 26: {
                return offset + 4;
            }
            case 27: 
        }
        return offset + 8;
    }

    public static int skipCborLength(byte[] src, int offset, int expectedType) {
        block11: while (true) {
            int type = src[offset++] & 0xFF;
            switch (type >> 5) {
                default: {
                    return Decoder.nextCborType(type, offset);
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if ((type & 0xE0) == expectedType) break block11;
                    return 0;
                }
                case 6: {
                    offset = Decoder.nextCborType(type, offset);
                    continue block11;
                }
            }
            break;
        }
        switch (type &= 0x1F) {
            default: {
                return offset;
            }
            case 24: {
                return offset + 1;
            }
            case 25: {
                return offset + 2;
            }
            case 26: {
                return offset + 4;
            }
            case 27: {
                return offset + 8;
            }
            case 31: 
        }
        return -offset;
    }

    public static int decodeCborSize(byte[] src, int offset, int fail) {
        return Decoder.decodeCborSize(src, new IntRef(offset), fail);
    }

    public static byte[] decodeCborBytes(byte[] src, IntRef srcOffsetRef) {
        return Decoder.decodeCborBytes(0, src, srcOffsetRef);
    }

    public static byte[] decodeCborStringAsBytes(byte[] src, IntRef srcOffsetRef) {
        int len = Decoder.decodeCborValueBounds(src, srcOffsetRef, 96);
        if (len < 0) {
            throw new IllegalArgumentException("Not a string");
        }
        byte[] bytes = new byte[len];
        System.arraycopy(src, srcOffsetRef.value - len, bytes, 0, len);
        return bytes;
    }

    public static int decodeAnyCborInt(byte[] src, IntRef srcOffsetRef) {
        long longValue = Decoder.decodeAnyCborLong(src, srcOffsetRef);
        int intValue = (int)longValue;
        if ((long)intValue != longValue) {
            throw new IllegalArgumentException("Too large: " + longValue);
        }
        return intValue;
    }

    public static long decodeAnyCborLong(byte[] src, IntRef srcOffsetRef) {
        long value;
        block5: while (true) {
            int b = src[srcOffsetRef.value++] & 0xFF;
            value = Decoder.decodeCborLong(src, srcOffsetRef, b);
            switch (b >> 5) {
                case 6: {
                    continue block5;
                }
                case 7: {
                    throw new IllegalArgumentException("Illegal type: " + b);
                }
                case 1: {
                    value ^= 0xFFFFFFFFFFFFFFFFL;
                }
            }
            break;
        }
        return value;
    }

    public static long decodeCborLong(byte[] src, IntRef srcOffsetRef) {
        int b;
        block5: while (true) {
            b = src[srcOffsetRef.value++] & 0xFF;
            long value = Decoder.decodeCborLong(src, srcOffsetRef, b);
            switch (b >> 5) {
                case 6: {
                    continue block5;
                }
                case 1: {
                    value ^= 0xFFFFFFFFFFFFFFFFL;
                }
                case 0: {
                    return value;
                }
            }
            break;
        }
        throw new IllegalArgumentException("Illegal type: " + b);
    }

    private static long decodeCborLong(byte[] src, IntRef srcOffsetRef, int b) {
        int n;
        int srcOffset = srcOffsetRef.value;
        long value = 0L;
        switch (b & 0x1F) {
            default: {
                return b & 0x1F;
            }
            case 27: {
                value = ((long)src[srcOffset++] & 0xFFL) << 56 | ((long)src[srcOffset++] & 0xFFL) << 48 | ((long)src[srcOffset++] & 0xFFL) << 40 | ((long)src[srcOffset++] & 0xFFL) << 32;
                if (value < 0L) {
                    srcOffsetRef.value = srcOffset + 4;
                    throw new IllegalArgumentException("Too large: " + Utils.longToUnsignedString(value));
                }
            }
            case 26: {
                value = value | ((long)src[srcOffset++] & 0xFFL) << 24 | ((long)src[srcOffset++] & 0xFFL) << 16;
            }
            case 25: {
                value |= ((long)src[srcOffset++] & 0xFFL) << 8;
            }
            case 24: {
                n = srcOffset++;
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                throw new IllegalArgumentException("Illegal type: " + b);
            }
        }
        srcOffsetRef.value = srcOffset;
        return value |= (long)src[n] & 0xFFL;
    }

    public static double decodeCborDouble(byte[] src, IntRef srcOffsetRef) {
        double d;
        long value;
        int b;
        int srcOffset = srcOffsetRef.value;
        block15: while (true) {
            b = src[srcOffset++] & 0xFF;
            value = 0L;
            switch (b & 0x1F) {
                default: {
                    srcOffsetRef.value = Decoder.skipCborItem(src, srcOffset - 1);
                    throw new IllegalArgumentException("Illegal type: " + b);
                }
                case 27: {
                    value = ((long)src[srcOffset++] & 0xFFL) << 56 | ((long)src[srcOffset++] & 0xFFL) << 48 | ((long)src[srcOffset++] & 0xFFL) << 40 | ((long)src[srcOffset++] & 0xFFL) << 32;
                }
                case 26: {
                    value = value | ((long)src[srcOffset++] & 0xFFL) << 24 | ((long)src[srcOffset++] & 0xFFL) << 16;
                }
                case 25: {
                    value |= ((long)src[srcOffset++] & 0xFFL) << 8;
                }
                case 24: 
            }
            value |= (long)src[srcOffset++] & 0xFFL;
            switch (b >> 5) {
                default: {
                    srcOffsetRef.value = Decoder.skipCborItem(src, srcOffsetRef.value);
                    throw new IllegalArgumentException("Illegal type: " + b);
                }
                case 6: {
                    continue block15;
                }
                case 7: 
            }
            break;
        }
        switch (b & 0x1F) {
            default: {
                srcOffsetRef.value = Decoder.skipCborItem(src, srcOffsetRef.value);
                throw new IllegalArgumentException("Illegal type: " + b);
            }
            case 25: {
                d = Decoder.float16to32((int)value);
                break;
            }
            case 26: {
                d = Float.intBitsToFloat((int)value);
                break;
            }
            case 27: {
                d = Double.longBitsToDouble(value);
            }
        }
        srcOffsetRef.value = srcOffset;
        return d;
    }

    public static BigInteger decodeCborBigInteger(byte[] src, IntRef srcOffsetRef) {
        BigInteger value;
        int srcOffset = srcOffsetRef.value;
        block13: while (true) {
            int b = src[srcOffset++] & 0xFF;
            long field = 0L;
            switch (b & 0x1F) {
                default: {
                    field = b & 0x1F;
                    break;
                }
                case 27: {
                    field = ((long)src[srcOffset++] & 0xFFL) << 56 | ((long)src[srcOffset++] & 0xFFL) << 48 | ((long)src[srcOffset++] & 0xFFL) << 40 | ((long)src[srcOffset++] & 0xFFL) << 32;
                }
                case 26: {
                    field = field | ((long)src[srcOffset++] & 0xFFL) << 24 | ((long)src[srcOffset++] & 0xFFL) << 16;
                }
                case 25: {
                    field |= ((long)src[srcOffset++] & 0xFFL) << 8;
                }
                case 24: {
                    field |= (long)src[srcOffset++] & 0xFFL;
                    break;
                }
                case 28: 
                case 29: 
                case 30: {
                    throw new IllegalArgumentException("Illegal type: " + b);
                }
                case 31: {
                    srcOffset = Decoder.skipCborItem(src, srcOffset - 1);
                    value = null;
                    break block13;
                }
            }
            switch (b >> 5) {
                default: {
                    srcOffset = Decoder.skipCborItem(src, srcOffsetRef.value);
                    value = null;
                    break block13;
                }
                case 0: {
                    value = Decoder.decodePositiveBigInteger(field);
                    break block13;
                }
                case 1: {
                    value = Decoder.decodeNegativeBigInteger(field);
                    break block13;
                }
                case 6: {
                    if (field < 2L || field > 3L) continue block13;
                    srcOffsetRef.value = srcOffset;
                    return new BigInteger(Decoder.decodeCborBytes((int)field, src, srcOffsetRef));
                }
            }
            break;
        }
        srcOffsetRef.value = srcOffset;
        return value;
    }

    public static BigInteger decodePositiveBigInteger(long value) {
        if (value >= 0L) {
            return BigInteger.valueOf(value);
        }
        byte[] temp = new byte[9];
        Utils.encodeLongBE(temp, 1, value);
        return new BigInteger(temp);
    }

    public static BigInteger decodeNegativeBigInteger(long value) {
        if ((value ^= 0xFFFFFFFFFFFFFFFFL) < 0L) {
            return BigInteger.valueOf(value);
        }
        byte[] temp = new byte[9];
        temp[0] = -1;
        Utils.encodeLongBE(temp, 1, value);
        return new BigInteger(temp);
    }

    /*
     * Unable to fully structure code
     */
    public static BigDecimal decodeCborBigDecimal(byte[] src, IntRef srcOffsetRef) {
        srcOffset = srcOffsetRef.value;
        block21: while (true) {
            b = src[srcOffset++] & 255;
            field = 0L;
            switch (b & 31) {
                default: {
                    field = b & 31;
                    break;
                }
                case 27: {
                    field = ((long)src[srcOffset++] & 255L) << 56 | ((long)src[srcOffset++] & 255L) << 48 | ((long)src[srcOffset++] & 255L) << 40 | ((long)src[srcOffset++] & 255L) << 32;
                }
                case 26: {
                    field = field | ((long)src[srcOffset++] & 255L) << 24 | ((long)src[srcOffset++] & 255L) << 16;
                }
                case 25: {
                    field |= ((long)src[srcOffset++] & 255L) << 8;
                }
                case 24: {
                    field |= (long)src[srcOffset++] & 255L;
                    break;
                }
                case 28: 
                case 29: 
                case 30: {
                    throw new IllegalArgumentException("Illegal type: " + b);
                }
                case 31: {
                    srcOffset = Decoder.skipCborItem(src, srcOffset - 1);
                    value = null;
                    break block21;
                }
            }
            switch (b >> 5) {
                default: {
                    srcOffset = Decoder.skipCborItem(src, srcOffsetRef.value);
                    value = null;
                    break block21;
                }
                case 0: {
                    value = new BigDecimal(Decoder.decodePositiveBigInteger(field));
                    break block21;
                }
                case 1: {
                    value = new BigDecimal(Decoder.decodeNegativeBigInteger(field));
                    break block21;
                }
                case 6: {
                    if (field < 2L) continue block21;
                    if (field <= 3L) {
                        srcOffsetRef.value = srcOffset;
                        bi = new BigInteger(Decoder.decodeCborBytes((int)field, src, srcOffsetRef));
                        return new BigDecimal(bi);
                    }
                    if (field <= 5L) ** break;
                    continue block21;
                    srcOffsetRef.value = srcOffset;
                    return Decoder.decodeCborBigDecimal((int)field, src, srcOffsetRef);
                }
                case 7: {
                    try {
                        switch (b & 31) {
                            default: {
                                srcOffset = Decoder.skipCborItem(src, srcOffsetRef.value);
                                value = null;
                                break block21;
                            }
                            case 25: {
                                value = BigDecimal.valueOf(Decoder.float16to32((int)field));
                                break block21;
                            }
                            case 26: {
                                value = BigDecimal.valueOf(Float.intBitsToFloat((int)field));
                                break block21;
                            }
                            case 27: 
                        }
                        value = BigDecimal.valueOf(Double.longBitsToDouble(field));
                    }
                    catch (NumberFormatException e) {
                        srcOffset = Decoder.skipCborItem(src, srcOffsetRef.value);
                        value = null;
                    }
                    break block21;
                }
            }
            break;
        }
        srcOffsetRef.value = srcOffset;
        return value;
    }

    public static BigDecimal decodeCborBigDecimal(int tag, byte[] src, IntRef srcOffsetRef) {
        int srcOffset;
        block16: {
            srcOffset = srcOffsetRef.value;
            int len = 0;
            block12: while (true) {
                int b = src[srcOffset++] & 0xFF;
                switch (b) {
                    default: {
                        srcOffsetRef.value = Decoder.skipCborItem(src, srcOffset - 1);
                        return null;
                    }
                    case 130: {
                        break block16;
                    }
                    case 155: {
                        len = (src[srcOffset++] & 0xFF) << 24 | (src[srcOffset++] & 0xFF) << 16 | (src[srcOffset++] & 0xFF) << 8 | src[srcOffset++] & 0xFF;
                        if (len != 0) break block12;
                    }
                    case 154: {
                        len = (src[srcOffset++] & 0xFF) << 24 | (src[srcOffset++] & 0xFF) << 16;
                    }
                    case 153: {
                        len |= (src[srcOffset++] & 0xFF) << 8;
                    }
                    case 152: {
                        if ((len |= src[srcOffset++] & 0xFF) != 2) break block12;
                        break block16;
                    }
                    case 192: {
                        continue block12;
                    }
                    case 216: {
                        ++srcOffset;
                        continue block12;
                    }
                    case 217: {
                        srcOffset += 2;
                        continue block12;
                    }
                    case 218: {
                        srcOffset += 4;
                        continue block12;
                    }
                    case 219: {
                        srcOffset += 8;
                        continue block12;
                    }
                }
                break;
            }
            srcOffsetRef.value = Decoder.skipCborItem(src, srcOffsetRef.value);
            return null;
        }
        srcOffsetRef.value = srcOffset;
        long longExp = Decoder.decodeAnyCborLong(src, srcOffsetRef);
        if (tag == 4) {
            long longScale = -longExp;
            int intScale = (int)longScale;
            if ((long)intScale != longScale) {
                throw new IllegalArgumentException("Exponent is too large: " + longExp);
            }
            return new BigDecimal(Decoder.decodeCborBigInteger(src, srcOffsetRef), intScale);
        }
        int intExp = (int)longExp;
        if ((long)intExp != longExp) {
            throw new IllegalArgumentException("Exponent is too large: " + longExp);
        }
        return new BigDecimal(Decoder.decodeCborBigInteger(src, srcOffsetRef)).multiply(DECIMAL_TWO.pow(intExp));
    }

    public static int decodeCborValueBounds(byte[] src, IntRef srcOffsetRef, int type) {
        int srcOffset = srcOffsetRef.value;
        int len = 0;
        block12: while (true) {
            int b;
            if ((b = src[srcOffset++] & 0xFF) == 246 || (b & 0xE0) != type) {
                return -1;
            }
            switch (b & 0x1F) {
                default: {
                    len = b & 0x1F;
                    break block12;
                }
                case 27: {
                    len = (src[srcOffset++] & 0xFF) << 24 | (src[srcOffset++] & 0xFF) << 16 | (src[srcOffset++] & 0xFF) << 8 | src[srcOffset++] & 0xFF;
                    if (len != 0) {
                        throw new IllegalArgumentException("Too large: " + ((long)len << 32));
                    }
                }
                case 26: {
                    len = (src[srcOffset++] & 0xFF) << 24 | (src[srcOffset++] & 0xFF) << 16;
                    if (len < 0) {
                        throw new IllegalArgumentException("Too large: " + len);
                    }
                }
                case 25: {
                    len |= (src[srcOffset++] & 0xFF) << 8;
                }
                case 24: {
                    len |= src[srcOffset++] & 0xFF;
                    break block12;
                }
                case 31: {
                    throw new UnsupportedOperationException();
                }
                case 192: {
                    continue block12;
                }
                case 216: {
                    ++srcOffset;
                    continue block12;
                }
                case 217: {
                    srcOffset += 2;
                    continue block12;
                }
                case 218: {
                    srcOffset += 4;
                    continue block12;
                }
                case 219: {
                    srcOffset += 8;
                    continue block12;
                }
            }
            break;
        }
        srcOffsetRef.value = srcOffset + len;
        return len;
    }

    public static byte[] decodeCborBytes(int tag, byte[] src, IntRef srcOffsetRef) {
        byte[] bytes;
        int srcOffset = srcOffsetRef.value;
        int len = 0;
        block12: while (true) {
            int b = src[srcOffset++] & 0xFF;
            switch (b) {
                default: {
                    if ((b & 0xE0) != 64) {
                        throw new IllegalArgumentException("Illegal type: " + b);
                    }
                    len = b & 0x1F;
                    break block12;
                }
                case 91: {
                    len = (src[srcOffset++] & 0xFF) << 24 | (src[srcOffset++] & 0xFF) << 16 | (src[srcOffset++] & 0xFF) << 8 | src[srcOffset++] & 0xFF;
                    if (len != 0) {
                        throw new IllegalArgumentException("Too large: " + ((long)len << 32));
                    }
                }
                case 90: {
                    len = (src[srcOffset++] & 0xFF) << 24 | (src[srcOffset++] & 0xFF) << 16;
                    if (len < 0) {
                        throw new IllegalArgumentException("Too large: " + len);
                    }
                }
                case 89: {
                    len |= (src[srcOffset++] & 0xFF) << 8;
                }
                case 88: {
                    len |= src[srcOffset++] & 0xFF;
                    break block12;
                }
                case 95: {
                    throw new UnsupportedOperationException();
                }
                case 192: {
                    continue block12;
                }
                case 216: {
                    ++srcOffset;
                    continue block12;
                }
                case 217: {
                    srcOffset += 2;
                    continue block12;
                }
                case 218: {
                    srcOffset += 4;
                    continue block12;
                }
                case 219: {
                    srcOffset += 8;
                    continue block12;
                }
            }
            break;
        }
        if (tag == 0 || src[srcOffset] >= 0) {
            bytes = new byte[len];
            System.arraycopy(src, srcOffset, bytes, 0, len);
        } else {
            bytes = new byte[1 + len];
            System.arraycopy(src, srcOffset, bytes, 1, len);
        }
        if (tag == 3) {
            int i = 0;
            while (i < bytes.length) {
                int n = i++;
                bytes[n] = (byte)(bytes[n] ^ 0xFF);
            }
        }
        srcOffsetRef.value = srcOffset + len;
        return bytes;
    }

    public static int beginsWith(byte[] src, int srcOffset, byte[] subarr, int subarrOffset, int subarrLen, int fail) throws IOException {
        int srcLen;
        IntRef srcOffsetRef = new IntRef(srcOffset);
        try {
            srcLen = Decoder.decodeCborValueBounds(src, srcOffsetRef, 96);
        }
        catch (IllegalArgumentException e) {
            return fail;
        }
        if (srcLen < 0) {
            return fail;
        }
        if (subarrLen > srcLen) {
            return -1;
        }
        int srcStartOffset = srcOffsetRef.value - srcLen;
        for (int i = 0; i < subarrLen; ++i) {
            if (src[srcStartOffset + i] == subarr[subarrOffset + i]) continue;
            return src[srcStartOffset + i] - subarr[subarrOffset + i];
        }
        return 0;
    }

    public static long compareCborLong(byte[] src, int srcOffset, long value, long fail) {
        double da;
        long attrValue;
        int b;
        block23: while (true) {
            b = src[srcOffset++] & 0xFF;
            attrValue = 0L;
            switch (b & 0x1F) {
                default: {
                    attrValue = b & 0x1F;
                    break;
                }
                case 27: {
                    attrValue = ((long)src[srcOffset++] & 0xFFL) << 56 | ((long)src[srcOffset++] & 0xFFL) << 48 | ((long)src[srcOffset++] & 0xFFL) << 40 | ((long)src[srcOffset++] & 0xFFL) << 32;
                    if (attrValue < 0L) {
                        if (b == 27) {
                            return value + 1L;
                        }
                        if (b == 59) {
                            return value - 1L;
                        }
                    }
                }
                case 26: {
                    attrValue = attrValue | ((long)src[srcOffset++] & 0xFFL) << 24 | ((long)src[srcOffset++] & 0xFFL) << 16;
                }
                case 25: {
                    attrValue |= ((long)src[srcOffset++] & 0xFFL) << 8;
                }
                case 24: {
                    attrValue |= (long)src[srcOffset++] & 0xFFL;
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    return fail;
                }
            }
            switch (b >> 5) {
                default: {
                    return fail;
                }
                case 6: {
                    int tag = (int)attrValue;
                    if ((long)tag != attrValue) continue block23;
                    switch (tag) {
                        case 2: 
                        case 3: {
                            BigInteger bi = new BigInteger(Decoder.decodeCborBytes(tag, src, new IntRef(srcOffset)));
                            return value + (long)bi.compareTo(BigInteger.valueOf(value));
                        }
                        case 4: 
                        case 5: {
                            BigDecimal bd = Decoder.decodeCborBigDecimal(tag, src, new IntRef(srcOffset));
                            return value + (long)bd.compareTo(BigDecimal.valueOf(value));
                        }
                    }
                    continue block23;
                }
                case 1: {
                    return attrValue ^ 0xFFFFFFFFFFFFFFFFL;
                }
                case 0: {
                    return attrValue;
                }
                case 7: 
            }
            break;
        }
        switch (b & 0x1F) {
            default: {
                return fail;
            }
            case 22: {
                return value + 1L;
            }
            case 25: {
                da = Decoder.float16to32((int)attrValue);
                break;
            }
            case 26: {
                da = Float.intBitsToFloat((int)attrValue);
                break;
            }
            case 27: {
                da = Double.longBitsToDouble(attrValue);
            }
        }
        double dv = value;
        if (value == (long)dv) {
            return value + (long)Long.compare(Decoder.doubleCompareBits(da), Decoder.doubleCompareBits(dv));
        }
        if (Decoder.isInfinityOrNaN(da)) {
            return Double.doubleToRawLongBits(da) < 0L ? value - 1L : value + 1L;
        }
        return value + (long)BigDecimal.valueOf(da).compareTo(BigDecimal.valueOf(value));
    }

    public static int compareCborDouble(byte[] src, int srcOffset, double value, int fail) {
        double da;
        long attrValue;
        int b;
        block23: while (true) {
            b = src[srcOffset++] & 0xFF;
            attrValue = 0L;
            switch (b & 0x1F) {
                default: {
                    attrValue = b & 0x1F;
                    break;
                }
                case 27: {
                    attrValue = ((long)src[srcOffset++] & 0xFFL) << 56 | ((long)src[srcOffset++] & 0xFFL) << 48 | ((long)src[srcOffset++] & 0xFFL) << 40 | ((long)src[srcOffset++] & 0xFFL) << 32;
                }
                case 26: {
                    attrValue = attrValue | ((long)src[srcOffset++] & 0xFFL) << 24 | ((long)src[srcOffset++] & 0xFFL) << 16;
                }
                case 25: {
                    attrValue |= ((long)src[srcOffset++] & 0xFFL) << 8;
                }
                case 24: {
                    attrValue |= (long)src[srcOffset++] & 0xFFL;
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    return fail;
                }
            }
            switch (b >> 5) {
                default: {
                    return fail;
                }
                case 6: {
                    int tag = (int)attrValue;
                    if ((long)tag != attrValue) continue block23;
                    switch (tag) {
                        case 2: 
                        case 3: {
                            BigInteger bi = new BigInteger(Decoder.decodeCborBytes(tag, src, new IntRef(srcOffset)));
                            return Decoder.compare(new BigDecimal(bi, 0), value);
                        }
                        case 4: 
                        case 5: {
                            return Decoder.compare(Decoder.decodeCborBigDecimal(tag, src, new IntRef(srcOffset)), value);
                        }
                    }
                    continue block23;
                }
                case 1: {
                    long bits = Double.doubleToRawLongBits(value);
                    if ((attrValue & 0xFFE0000000000000L) != 0L) {
                        if (bits >= 0L) {
                            return -1;
                        }
                        if ((bits | 0x800FFFFFFFFFFFFFL) == -1L) {
                            return Long.compare(0L, Decoder.fixBits(bits));
                        }
                        int attrExp = 63 - Long.numberOfLeadingZeros(attrValue);
                        int valueExp = Math.getExponent(value);
                        int result = valueExp - attrExp;
                        if (result < -1 | result > 1) {
                            return result;
                        }
                        return Decoder.compare(new BigDecimal(Decoder.decodeNegativeBigInteger(attrValue)), value);
                    }
                    return Long.compare(Decoder.doubleCompareBits(attrValue ^ 0xFFFFFFFFFFFFFFFFL), Decoder.fixBits(bits));
                }
                case 0: {
                    long bits = Double.doubleToRawLongBits(value);
                    if ((attrValue & 0xFFE0000000000000L) != 0L) {
                        int valueExp;
                        if (bits < 0L) {
                            return 1;
                        }
                        if ((bits | 0x800FFFFFFFFFFFFFL) == -1L) {
                            return Long.compare(0L, Decoder.fixBits(bits));
                        }
                        int attrExp = 63 - Long.numberOfLeadingZeros(attrValue);
                        int result = attrExp - (valueExp = Math.getExponent(value));
                        if (result < -1 | result > 1) {
                            return result;
                        }
                        return Decoder.compare(new BigDecimal(Decoder.decodePositiveBigInteger(attrValue)), value);
                    }
                    return Long.compare(Decoder.doubleCompareBits(attrValue), Decoder.fixBits(bits));
                }
                case 7: 
            }
            break;
        }
        switch (b & 0x1F) {
            default: {
                return fail;
            }
            case 22: {
                return 1;
            }
            case 25: {
                da = Decoder.float16to32((int)attrValue);
                break;
            }
            case 26: {
                da = Float.intBitsToFloat((int)attrValue);
                break;
            }
            case 27: {
                return Long.compare(Decoder.fixBits(attrValue), Decoder.doubleCompareBits(value));
            }
        }
        return Long.compare(Decoder.doubleCompareBits(da), Decoder.doubleCompareBits(value));
    }

    /*
     * Unable to fully structure code
     */
    public static int compareCborBigDecimal(byte[] src, int srcOffset, BigDecimal value, int fail) {
        if (value == null) {
            return (src[srcOffset] & 255) == 246 ? 0 : -1;
        }
        block21: while (true) {
            b = src[srcOffset++] & 255;
            field = 0L;
            switch (b & 31) {
                default: {
                    field = b & 31;
                    break;
                }
                case 27: {
                    field = ((long)src[srcOffset++] & 255L) << 56 | ((long)src[srcOffset++] & 255L) << 48 | ((long)src[srcOffset++] & 255L) << 40 | ((long)src[srcOffset++] & 255L) << 32;
                }
                case 26: {
                    field = field | ((long)src[srcOffset++] & 255L) << 24 | ((long)src[srcOffset++] & 255L) << 16;
                }
                case 25: {
                    field |= ((long)src[srcOffset++] & 255L) << 8;
                }
                case 24: {
                    field |= (long)src[srcOffset++] & 255L;
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    return fail;
                }
            }
            switch (b >> 5) {
                default: {
                    return fail;
                }
                case 0: {
                    bd = new BigDecimal(Decoder.decodePositiveBigInteger(field));
                    break block21;
                }
                case 1: {
                    bd = new BigDecimal(Decoder.decodeNegativeBigInteger(field));
                    break block21;
                }
                case 6: {
                    if (field < 2L) continue block21;
                    if (field <= 3L) {
                        bi = new BigInteger(Decoder.decodeCborBytes((int)field, src, new IntRef(srcOffset)));
                        bd = new BigDecimal(bi);
                        break block21;
                    }
                    if (field <= 5L) ** break;
                    continue block21;
                    bd = Decoder.decodeCborBigDecimal((int)field, src, new IntRef(srcOffset));
                    break block21;
                }
                case 7: {
                    try {
                        switch (b & 31) {
                            default: {
                                return fail;
                            }
                            case 22: {
                                return 1;
                            }
                            case 25: {
                                ifield = (int)field;
                                if ((ifield | -31745) == -1) {
                                    if (ifield < 0) {
                                        ifield ^= 32767;
                                    }
                                    return Short.compare((short)ifield, (short)0);
                                }
                                f = Decoder.float16to32(ifield);
                                if ((ifield & 32767) == 0) {
                                    return Float.compare(f, value.signum());
                                }
                                bd = BigDecimal.valueOf(f);
                                break block21;
                            }
                            case 26: {
                                ifield = (int)field;
                                if ((ifield | -2139095041) == -1) {
                                    if (ifield < 0) {
                                        ifield ^= 0x7FFFFFFF;
                                    }
                                    return Integer.compare(ifield, 0);
                                }
                                f = Float.intBitsToFloat(ifield);
                                if ((ifield & 0x7FFFFFFF) == 0) {
                                    return Float.compare(f, value.signum());
                                }
                                bd = BigDecimal.valueOf(f);
                                break block21;
                            }
                            case 27: 
                        }
                        if ((field | -9218868437227405313L) == -1L) {
                            return Long.compare(Decoder.fixBits(field), 0L);
                        }
                        d = Double.longBitsToDouble(field);
                        if ((field & 0x7FFFFFFFFFFFFFFFL) == 0L) {
                            return Double.compare(d, value.signum());
                        }
                        bd = BigDecimal.valueOf(d);
                        break block21;
                    }
                    catch (NumberFormatException e) {
                        return fail;
                    }
                }
            }
            break;
        }
        return bd.compareTo(value);
    }

    public static int compareCborValue(byte[] src, int srcOffset, byte[] value, int valueOffset, int valueLen, int type, int fail) {
        return Decoder.compareCborValue(src, new IntRef(srcOffset), value, valueOffset, valueLen, type, fail);
    }

    public static int compareCborValue(byte[] src, IntRef srcOffsetRef, byte[] value, int valueOffset, int valueLen, int type, int fail) {
        int len;
        try {
            len = Decoder.decodeCborValueBounds(src, srcOffsetRef, type);
        }
        catch (IllegalArgumentException e) {
            return fail;
        }
        if (len < 0) {
            return fail;
        }
        return Utils.compareUnsigned(src, srcOffsetRef.value - len, len, value, valueOffset, valueLen);
    }

    public static int decodeCborSize(byte[] src, IntRef offsetRef, int fail) {
        boolean isUtf = false;
        long len = fail;
        block5: while (true) {
            int b = src[offsetRef.value++] & 0xFF;
            len = Decoder.decodeCborLong(src, offsetRef, b);
            switch (b >> 5) {
                case 3: {
                    isUtf = true;
                }
                case 2: 
                case 4: 
                case 5: {
                    break block5;
                }
                case 6: {
                    break;
                }
                default: {
                    return fail;
                }
            }
        }
        if (len < 0L || len == (long)fail) {
            return fail;
        }
        int intLen = (int)len;
        if ((long)intLen != len) {
            throw new IllegalArgumentException("Too large: " + len);
        }
        if (isUtf) {
            return Decoder.decodeUtf8Length(src, offsetRef.value, intLen);
        }
        return intLen;
    }

    public static long doubleCompareBits(double value) {
        return Decoder.fixBits(Double.doubleToRawLongBits(value));
    }

    public static long fixBits(long bits) {
        if (bits < 0L) {
            bits ^= Long.MAX_VALUE;
        }
        return bits;
    }

    public static int compare(BigDecimal bd, double value) {
        if (Decoder.isInfinityOrNaN(value)) {
            return Double.compare(0.0, value);
        }
        return bd.compareTo(BigDecimal.valueOf(value));
    }

    public static boolean isInfinityOrNaN(double value) {
        return (Double.doubleToRawLongBits(value) | 0x800FFFFFFFFFFFFFL) == -1L;
    }
}

