/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.dax.ClientBuilder;
import software.amazon.dax.Configuration;
import software.amazon.dax.DaxAsyncClient;
import software.amazon.dax.MetricAsyncClient;
import software.amazon.dax.cluster.Cluster;
import software.amazon.dax.utils.CheckedFunction;

public final class ClusterDaxAsyncClient
extends MetricAsyncClient {
    private static final Log LOG = LogFactory.getLog(ClusterDaxAsyncClient.class);
    private final Cluster cluster;

    private ClusterDaxAsyncClient(Configuration configuration) throws IOException {
        super(configuration);
        this.cluster = new Cluster(configuration);
        try {
            this.cluster.startup(1);
        }
        catch (IOException e) {
            LOG.warn((Object)("exception starting up cluster client: " + e), (Throwable)e);
        }
    }

    @Override
    DaxAsyncClient clientFactory(DaxAsyncClient prev) throws IOException {
        return this.cluster.client(prev);
    }

    public void close() {
        this.cluster.close();
    }

    public static Builder builder() {
        return new Builder(ClusterDaxAsyncClient::new);
    }

    public static final class Builder
    extends ClientBuilder<ClusterDaxAsyncClient> {
        Builder(CheckedFunction<Configuration, ClusterDaxAsyncClient, IOException> ctor) {
            super(ctor);
        }
    }
}

