/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile;

import com.amazon.ion.IonWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Map;
import java.util.logging.Logger;
import software.amazon.codeguruprofilerjavaagent.profile.IonUtils;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;

public class AgentDebugInfo {
    private static final Logger LOG = Logger.getLogger(AgentDebugInfo.class.getName());
    private static final Long COMPUTED_PROCESS_ID = AgentDebugInfo.getProcessId();
    private final Map<String, Double> genericMetrics;
    private final Instant agentStartTime;
    private final Long processId;
    private final ErrorsMetadata errorsMetadata;

    public AgentDebugInfo(Map<String, Double> genericMetrics, Instant agentStartTime, ErrorsMetadata errorsMetadata) {
        this(genericMetrics, agentStartTime, errorsMetadata, COMPUTED_PROCESS_ID);
    }

    AgentDebugInfo(Map<String, Double> genericMetrics, Instant agentStartTime, ErrorsMetadata errorsMetadata, Long processId) {
        this.genericMetrics = genericMetrics;
        this.agentStartTime = agentStartTime;
        this.processId = processId;
        this.errorsMetadata = errorsMetadata;
    }

    public static AgentDebugInfo empty() {
        return new AgentDebugInfo(null, null, null);
    }

    public void write(IonWriter out, String fieldName) throws IOException {
        IonUtils.writeStruct(out, fieldName, () -> {
            if (this.genericMetrics != null && !this.genericMetrics.isEmpty()) {
                IonUtils.writeStruct(out, "genericMetrics", () -> {
                    for (Map.Entry<String, Double> metricEntry : this.genericMetrics.entrySet()) {
                        IonUtils.writeDecimal(out, metricEntry.getKey(), new BigDecimal(metricEntry.getValue()));
                    }
                });
            }
            if (this.agentStartTime != null) {
                IonUtils.writeTimestamp(out, "agentStartTime", this.agentStartTime);
            }
            if (this.processId != null) {
                IonUtils.writeInt(out, "processId", this.processId);
            }
            if (this.errorsMetadata != null) {
                this.errorsMetadata.write(out, "errorsCount");
            }
        });
    }

    public Map<String, Double> getGenericMetrics() {
        return this.genericMetrics;
    }

    private static Long getProcessId() {
        try {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            return Long.parseLong(processName.substring(0, processName.indexOf(64)));
        }
        catch (Exception e) {
            LOG.info("Failed to get the process id, " + e.getMessage());
            return null;
        }
    }
}

