/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.flightrecorder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.jfr.FlightRecorder;
import jdk.jfr.Recording;
import jdk.jfr.consumer.RecordedEvent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.EventProcessor;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.RecordingHandler;
import software.amazon.codeguruprofilerjavaagent.profile.ProfileBuilder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\r\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0011J\u0006\u0010\u0019\u001a\u00020\u0011J\u0006\u0010\u001a\u001a\u00020\u0011J\u0006\u0010\u001b\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u0004\u0018\u00010\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/MemoryProfiler;", "", "enabled", "", "eventProcessors", "", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/EventProcessor;", "recordingHandlerFactory", "Lkotlin/Function0;", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/RecordingHandler;", "(ZLjava/util/List;Lkotlin/jvm/functions/Function0;)V", "recordingHandler", "getRecordingHandler", "()Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/RecordingHandler;", "recordingHandler$delegate", "Lkotlin/Lazy;", "flush", "", "profileBuilder", "Lsoftware/amazon/codeguruprofilerjavaagent/profile/ProfileBuilder;", "getLatestFlightRecordingFileSizeBytes", "", "()Ljava/lang/Long;", "isRecording", "notImplementedPause", "notImplementedResume", "startRecording", "stopRecording", "Companion", "SkySailJavaAgent"})
@SourceDebugExtension(value={"SMAP\nMemoryProfiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryProfiler.kt\nsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/MemoryProfiler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n1855#2,2:177\n*S KotlinDebug\n*F\n+ 1 MemoryProfiler.kt\nsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/MemoryProfiler\n*L\n72#1:177,2\n*E\n"})
public final class MemoryProfiler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean enabled;
    @NotNull
    private final List<EventProcessor> eventProcessors;
    @NotNull
    private final Function0<RecordingHandler> recordingHandlerFactory;
    @NotNull
    private final Lazy recordingHandler$delegate;
    @NotNull
    private static final Map<String, String> GC_TYPES;
    @NotNull
    private static final Set<String> SUPPORTED_GCS;
    @NotNull
    private static final Logger logger;

    @JvmOverloads
    public MemoryProfiler(boolean enabled, @NotNull List<? extends EventProcessor> eventProcessors, @NotNull Function0<RecordingHandler> recordingHandlerFactory) {
        Intrinsics.checkNotNullParameter(eventProcessors, (String)"eventProcessors");
        Intrinsics.checkNotNullParameter(recordingHandlerFactory, (String)"recordingHandlerFactory");
        this.enabled = enabled;
        this.eventProcessors = eventProcessors;
        this.recordingHandlerFactory = recordingHandlerFactory;
        this.recordingHandler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RecordingHandler>(this){
            final /* synthetic */ MemoryProfiler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final RecordingHandler invoke() {
                return (RecordingHandler)MemoryProfiler.access$getRecordingHandlerFactory$p(this.this$0).invoke();
            }
        }));
    }

    public /* synthetic */ MemoryProfiler(final boolean bl, final List list, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = (Function0)new Function0<RecordingHandler>(){

                @Nullable
                public final RecordingHandler invoke() {
                    return Companion.createRecordingHandler(bl, list);
                }
            };
        }
        this(bl, list, (Function0<RecordingHandler>)function0);
    }

    private final RecordingHandler getRecordingHandler() {
        Lazy lazy = this.recordingHandler$delegate;
        return (RecordingHandler)lazy.getValue();
    }

    public final void startRecording() {
        block0: {
            RecordingHandler recordingHandler2 = this.getRecordingHandler();
            if (recordingHandler2 == null) break block0;
            recordingHandler2.startRecording();
        }
    }

    public final void stopRecording() {
        block0: {
            RecordingHandler recordingHandler2 = this.getRecordingHandler();
            if (recordingHandler2 == null) break block0;
            recordingHandler2.stopRecording(true);
        }
    }

    public final void notImplementedPause() {
    }

    public final void notImplementedResume() {
    }

    @Nullable
    public final Long getLatestFlightRecordingFileSizeBytes() {
        RecordingHandler recordingHandler2 = this.getRecordingHandler();
        return recordingHandler2 != null ? recordingHandler2.getLatestRecordingFileSizeBytes() : null;
    }

    public final boolean isRecording() {
        RecordingHandler recordingHandler2 = this.getRecordingHandler();
        return recordingHandler2 != null ? recordingHandler2.isRecording() : false;
    }

    public final void flush(@NotNull ProfileBuilder profileBuilder) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)profileBuilder, (String)"profileBuilder");
        RecordingHandler recordingHandler2 = this.getRecordingHandler();
        if (recordingHandler2 != null) {
            recordingHandler2.stopRecording(false);
        }
        if ((object = this.getRecordingHandler()) == null || (object = ((RecordingHandler)object).processRecordedEvents()) == null) {
            object = CollectionsKt.emptyList();
        }
        Object recordedEvents = object;
        Iterable $this$forEach$iv = this.eventProcessors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventProcessor it = (EventProcessor)element$iv;
            boolean bl = false;
            it.process(profileBuilder, (List<RecordedEvent>)recordedEvents);
        }
    }

    @JvmOverloads
    public MemoryProfiler(boolean enabled, @NotNull List<? extends EventProcessor> eventProcessors) {
        Intrinsics.checkNotNullParameter(eventProcessors, (String)"eventProcessors");
        this(enabled, eventProcessors, null, 4, null);
    }

    public static final /* synthetic */ Function0 access$getRecordingHandlerFactory$p(MemoryProfiler $this) {
        return $this.recordingHandlerFactory;
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"G1_Old_Generation", (Object)"G1"), TuplesKt.to((Object)"G1_Young_Generation", (Object)"G1"), TuplesKt.to((Object)"PS_MarkSweep", (Object)"PS"), TuplesKt.to((Object)"PS_Scavenge", (Object)"PS"), TuplesKt.to((Object)"MarkSweepCompact", (Object)"Serial"), TuplesKt.to((Object)"Copy", (Object)"Serial"), TuplesKt.to((Object)"ConcurrentMarkSweep", (Object)"CMS"), TuplesKt.to((Object)"ParNew", (Object)"Parallel"), TuplesKt.to((Object)"Shenandoah_Cycles", (Object)"Shenandoah"), TuplesKt.to((Object)"Shenandoah_Pauses", (Object)"Shenandoah"), TuplesKt.to((Object)"ZGC", (Object)"ZGC")};
        GC_TYPES = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"G1", "PS", "Serial", "CMS", "Parallel"};
        SUPPORTED_GCS = SetsKt.setOf((Object[])objectArray);
        Logger logger = Logger.getLogger("javaClass");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(MemoryProfiler::javaClass.name)");
        MemoryProfiler.logger = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\tJ \u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0006\u0010\u001a\u001a\u00020\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0002J\u0006\u0010\u001c\u001a\u00020\u0011R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/MemoryProfiler$Companion;", "", "()V", "GC_TYPES", "", "", "getGC_TYPES", "()Ljava/util/Map;", "SUPPORTED_GCS", "", "getSUPPORTED_GCS", "()Ljava/util/Set;", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "checkIfGcIsSupported", "", "gcTypes", "createRecordingHandler", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/RecordingHandler;", "enabled", "", "eventProcessors", "", "Lsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/EventProcessor;", "isFlightRecorderAvailable", "jvmVersion", "warmup", "SkySailJavaAgent"})
    @SourceDebugExtension(value={"SMAP\nMemoryProfiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryProfiler.kt\nsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/MemoryProfiler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n1360#2:177\n1446#2,5:178\n*S KotlinDebug\n*F\n+ 1 MemoryProfiler.kt\nsoftware/amazon/codeguruprofilerjavaagent/flightrecorder/MemoryProfiler$Companion\n*L\n129#1:177\n129#1:178,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getGC_TYPES() {
            return GC_TYPES;
        }

        @NotNull
        public final Set<String> getSUPPORTED_GCS() {
            return SUPPORTED_GCS;
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public final void warmup() {
            if (this.isFlightRecorderAvailable()) {
                try {
                    Recording recording = new Recording();
                    recording.start();
                    recording.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final RecordingHandler createRecordingHandler(boolean enabled, List<? extends EventProcessor> eventProcessors) {
            Object object;
            if (!enabled || eventProcessors.isEmpty()) {
                return null;
            }
            if (!this.isFlightRecorderAvailable()) {
                this.getLogger().log(Level.INFO, Companion::createRecordingHandler$lambda$0);
                return null;
            }
            try {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                object = eventProcessors;
                int n = 0;
                Function0 function0 = null;
                Function2 function2 = null;
                boolean $i$f$flatMap = false;
                void var5_9 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    EventProcessor it = (EventProcessor)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.getSupportedEvents();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List list = (List)destination$iv$iv;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n2 = 7;
                List list2 = list;
                int n3 = n;
                Function0 function02 = function0;
                Function2 function22 = function2;
                object = new RecordingHandler(function22, function02, n3, list2, n2, defaultConstructorMarker);
            }
            catch (IOException e) {
                this.getLogger().log(Level.INFO, "Memory profiler initialization failed. Reason: " + e + '.');
                this.getLogger().log(Level.FINE, "Memory profiler initialization failed. Full details:", e);
                object = null;
            }
            return object;
        }

        public final boolean isFlightRecorderAvailable() {
            boolean bl;
            try {
                Class.forName("jdk.jfr.FlightRecorder");
                bl = true;
            }
            catch (ClassNotFoundException e) {
                bl = false;
            }
            boolean flightRecorderExists = bl;
            boolean available = flightRecorderExists && FlightRecorder.isAvailable();
            return available;
        }

        private final String jvmVersion() {
            return System.getProperty("java.runtime.name") + " (" + System.getProperty("java.runtime.version") + ')';
        }

        public final void checkIfGcIsSupported(@NotNull Set<String> gcTypes) {
            Intrinsics.checkNotNullParameter(gcTypes, (String)"gcTypes");
            for (String gc : gcTypes) {
                String gcName = this.getGC_TYPES().getOrDefault(gc, "Unknown");
                if (this.getSUPPORTED_GCS().contains(gcName)) continue;
                this.getLogger().log(Level.INFO, "Heap summary is enabled but garbage collector " + gcName + " is unsupported by this agent. Profiling will work but heap summary may not be available. Supported types: " + CollectionsKt.joinToString$default((Iterable)this.getSUPPORTED_GCS(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
                break;
            }
        }

        private static final String createRecordingHandler$lambda$0() {
            CharSequence charSequence = "\n                    Cannot use memory profiling features because JDK Flight Recorder is not available on this JVM. \n                    Known supported JDK versions are: OpenJDK 8u265+, any version of OpenJDK 11+. \n                    This JVM: " + Companion.jvmVersion() + ".\n                    ";
            Regex regex = new Regex("\n\\s*");
            String string = "";
            return regex.replace(charSequence, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

