/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class FrameEncodings {
    private static final int HASH_MAP_OVERHEAD = 48;
    private static final int MAP_ENTRY_OVERHEAD = 32;
    private static final int INTEGER_SIZE = 16;
    private static final int BYTE_PADDING = 8;
    private static final int STRING_OVERHEAD = 45;
    private final Map<String, Map<String, Integer>> frameEncodings = new HashMap<String, Map<String, Integer>>();
    private volatile int nextIdx;
    private volatile long stringSizes = 0L;

    public int encode(String className, String methodName) {
        if (className == null || methodName == null) {
            return -1;
        }
        Map<String, Integer> methodEncodings = this.frameEncodings.get(className);
        Integer encoding = null;
        if (null == methodEncodings) {
            methodEncodings = new HashMap<String, Integer>();
            this.frameEncodings.put(className, methodEncodings);
            this.stringSizes += (long)(8 * ((className.length() * 2 + 45) / 8));
        } else {
            encoding = methodEncodings.get(methodName);
        }
        if (null == encoding) {
            encoding = this.nextIdx++;
            methodEncodings.put(methodName, encoding);
            this.stringSizes += (long)(8 * ((methodName.length() * 2 + 45) / 8));
        }
        return encoding;
    }

    public int getNextIdx() {
        return this.nextIdx;
    }

    long getSizeInMemory() {
        int numberOfHashMaps = this.frameEncodings.size() + 1;
        int numberOfEntries = this.frameEncodings.size() + this.nextIdx;
        return (long)(48 * numberOfHashMaps + numberOfEntries * 48) + this.stringSizes;
    }

    public Map<String, Map<String, Integer>> getFrameEncodings() {
        return Collections.unmodifiableMap(this.frameEncodings);
    }

    Map<Integer, String> getEncodings() {
        HashMap<Integer, String> encodingsMap = new HashMap<Integer, String>(this.getNextIdx());
        for (Map.Entry<String, Map<String, Integer>> classNameEntry : this.frameEncodings.entrySet()) {
            String className = classNameEntry.getKey();
            Map<String, Integer> methodMap = this.frameEncodings.get(className);
            for (Map.Entry<String, Integer> methodEntry : methodMap.entrySet()) {
                encodingsMap.put(methodEntry.getValue(), this.buildFrameName(className, methodEntry.getKey()));
            }
        }
        return encodingsMap;
    }

    private String buildFrameName(String className, String methodName) {
        if ("".equals(className)) {
            return methodName;
        }
        if ("".equals(methodName)) {
            return className;
        }
        return className + "." + methodName;
    }

    private static class StringEntryComparator
    implements Comparator<Map.Entry<String, ?>>,
    Serializable {
        private StringEntryComparator() {
        }

        @Override
        public int compare(Map.Entry<String, ?> o1, Map.Entry<String, ?> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    }
}

