/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.jvmagent;

import java.lang.instrument.Instrumentation;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.codeguruprofilerjavaagent.EnvironmentReader;
import software.amazon.codeguruprofilerjavaagent.IProfiler;
import software.amazon.codeguruprofilerjavaagent.Profiler;
import software.amazon.codeguruprofilerjavaagent.flightrecorder.MemoryProfiler;
import software.amazon.codeguruprofilerjavaagent.jvmagent.JvmArgumentParser;
import software.amazon.codeguruprofilerjavaagent.jvmagent.ProfilerLambdaExtensionAgent;
import software.amazon.codeguruprofilerjavaagent.jvmagent.ProfilerShutdownHook;

public class ProfilerAsJvmAgent {
    private static final Logger LOG = Logger.getLogger(ProfilerAsJvmAgent.class.getName());
    public static EnvironmentReader environmentReader = new EnvironmentReader();

    private ProfilerAsJvmAgent() {
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        try {
            if (ProfilerAsJvmAgent.isInstanceTypeLambda()) {
                ProfilerAsJvmAgent.warmupLambda(agentArgs);
                ProfilerLambdaExtensionAgent profilerLambdaExtensionAgent = new ProfilerLambdaExtensionAgent(environmentReader);
                Thread processNextEventThread = profilerLambdaExtensionAgent.registerExtensionAndGetProcessNextEventThread(agentArgs);
                processNextEventThread.start();
            } else {
                Profiler profiler = ProfilerAsJvmAgent.getNonLambdaProfiler(agentArgs);
                ProfilerAsJvmAgent.tryAddShutdownHook(profiler);
                profiler.start();
            }
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "There was a problem starting the profiler", e);
        }
    }

    private static Profiler getNonLambdaProfiler(String agentArgs) {
        JvmArgumentParser argumentParser = new JvmArgumentParser(agentArgs);
        Profiler.Builder builder = Profiler.builder();
        argumentParser.configureProfilerBuilder(builder);
        return builder.build();
    }

    private static boolean isInstanceTypeLambda() {
        return environmentReader.get("LAMBDA_TASK_ROOT") != null && environmentReader.get("LAMBDA_RUNTIME_DIR") != null;
    }

    private static void warmupLambda(String agentArgs) {
        JvmArgumentParser parser = new JvmArgumentParser(agentArgs);
        Map<String, String> arguments = parser.parseArguments(agentArgs);
        Optional<Boolean> heapSummaryEnabled = parser.getHeapSummaryEnabled(arguments);
        if (heapSummaryEnabled.isPresent() && heapSummaryEnabled.get().booleanValue()) {
            MemoryProfiler.Companion.warmup();
        }
    }

    private static void tryAddShutdownHook(IProfiler profiler) {
        try {
            Runtime.getRuntime().addShutdownHook(new ProfilerShutdownHook(profiler));
        }
        catch (Exception e) {
            LOG.info("Failed to add Profiler shutdown hook: " + e.getMessage());
        }
    }

    static void setEnv(EnvironmentReader newEnvironmentReader) {
        environmentReader = newEnvironmentReader;
    }
}

