/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile.metadata;

import com.amazon.ion.IonWriter;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.awssdk.regions.internal.util.EC2MetadataUtils;
import software.amazon.codeguruprofilerjavaagent.profile.IonUtils;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FleetInfo;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FleetInstanceType;

public class AWSEC2Instance
implements FleetInfo {
    private static final Logger LOG = Logger.getLogger(AWSEC2Instance.class.getName());
    private final String hostName;
    private final String hostType;

    public AWSEC2Instance(String hostName, String hostType) {
        this.hostName = hostName;
        this.hostType = hostType;
    }

    @Override
    public void write(IonWriter out) throws IOException {
        IonUtils.writeStruct(out, () -> {
            IonUtils.writeString(out, "computeType", "aws_ec2_instance");
            IonUtils.writeString(out, "hostName", this.hostName);
            IonUtils.writeString(out, "hostType", this.hostType);
        });
    }

    @Override
    public String getFleetInstanceId() {
        return this.getHostName();
    }

    String getHostName() {
        return this.hostName;
    }

    String getHostType() {
        return this.hostType;
    }

    @Override
    public FleetInstanceType getFleetInstanceType() {
        return FleetInstanceType.AWSEC2Instance;
    }

    public static Optional<FleetInfo> lookUpMetadata(ErrorsMetadata errorsMetadata) {
        return AWSEC2Instance.lookUpMetadata(() -> EC2MetadataUtils.getLocalHostName(), () -> EC2MetadataUtils.getInstanceInfo().getInstanceType(), errorsMetadata);
    }

    public static Optional<FleetInfo> lookUpMetadata(Supplier<String> getLocalHostName, Supplier<String> getInstanceType, ErrorsMetadata errorsMetadata) {
        String hostName = AWSEC2Instance.lookUpHostName(getLocalHostName, errorsMetadata);
        if (hostName == null || hostName.trim().isEmpty()) {
            return Optional.empty();
        }
        String hostType = AWSEC2Instance.lookUpInstanceType(getInstanceType, errorsMetadata);
        if (hostType == null || hostType.trim().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new AWSEC2Instance(hostName, hostType));
    }

    private static String lookUpHostName(Supplier<String> getLocalHostName, ErrorsMetadata errorsMetadata) {
        try {
            return getLocalHostName.get();
        }
        catch (Exception e) {
            errorsMetadata.record(LOG, Level.INFO, "Host name is not found from EC2 metadata, this is normal when running in a different environment (e.g. Fargate), profiler will still work: " + e.getMessage(), null);
            return null;
        }
    }

    private static String lookUpInstanceType(Supplier<String> getInstanceType, ErrorsMetadata errorsMetadata) {
        try {
            return getInstanceType.get();
        }
        catch (Exception e) {
            errorsMetadata.record(LOG, Level.INFO, "Instance type is not found from EC2 metadata, this is normal when running in a different environment (e.g. Fargate), profiler will still work: " + e.getMessage(), null);
            return null;
        }
    }

    public String toString() {
        return "AWSEC2Instance{hostName=" + this.hostName + ", hostType=" + this.hostType + '}';
    }
}

