/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile.metadata;

import com.amazon.ion.IonWriter;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.codeguruprofilerjavaagent.profile.IonUtils;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FleetInfo;

public class AgentMetadata {
    private static final Logger LOG = Logger.getLogger(AgentMetadata.class.getName());
    private final AgentInfo agentInfo;
    private final CodeInfo codeInfo;
    private final FleetInfo fleetInfo;
    private final String runtimeVersion;
    private final ErrorsMetadata errorsMetadata;
    private final String gcType;

    public AgentMetadata(AgentInfo agentInfo, CodeInfo codeInfo, FleetInfo fleetInfo, String runtimeVersion, ErrorsMetadata errorsMetadata, String gcType) {
        this.agentInfo = agentInfo;
        this.codeInfo = codeInfo;
        this.fleetInfo = fleetInfo;
        this.runtimeVersion = runtimeVersion;
        this.errorsMetadata = errorsMetadata;
        this.gcType = gcType;
    }

    public AgentMetadata(FleetInfo fleetInfo, ErrorsMetadata errorsMetadata, String integrationMode) {
        this(new AgentInfo(integrationMode), new CodeInfo(), fleetInfo, AgentMetadata.findRuntimeVersion(errorsMetadata), errorsMetadata, AgentMetadata.findGcType(errorsMetadata));
    }

    public AgentMetadata(ErrorsMetadata errorsMetadata, String integrationMode) {
        this(new AgentInfo(integrationMode), new CodeInfo(), null, AgentMetadata.findRuntimeVersion(errorsMetadata), errorsMetadata, AgentMetadata.findGcType(errorsMetadata));
    }

    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    public CodeInfo getCodeInfo() {
        return this.codeInfo;
    }

    public Optional<FleetInfo> getFleetInfo() {
        return Optional.ofNullable(this.fleetInfo);
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public ErrorsMetadata getErrorsMetadata() {
        return this.errorsMetadata;
    }

    public String getGcType() {
        return this.gcType;
    }

    private static String findRuntimeVersion(ErrorsMetadata errorsMetadata) {
        try {
            return System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " " + System.getProperty("java.runtime.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version");
        }
        catch (Exception e) {
            errorsMetadata.record(LOG, Level.INFO, "Could not extract java runtime version: " + e.getMessage(), null);
            return "";
        }
    }

    public static String findGcType(ErrorsMetadata errorsMetadata) {
        try {
            StringBuilder findType = new StringBuilder();
            List<GarbageCollectorMXBean> gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean gc : gcMXBeans) {
                findType.append(gc.getName() + ";");
            }
            return findType.toString();
        }
        catch (Exception e) {
            errorsMetadata.recordGc(LOG, Level.CONFIG, "Could not extract java garbage collector", e);
            return "";
        }
    }

    public String toString() {
        return "AgentMetadata{fleetInfo=" + this.fleetInfo + '}';
    }

    public static class CodeInfo {
        private final String releaseVersion;
        private final Instant releaseDate;

        public CodeInfo() {
            this.releaseVersion = "1.0";
            this.releaseDate = Instant.parse("2019-12-02T00:00:00.000Z");
        }

        public CodeInfo(String releaseVersion, Instant releaseDate) {
            this.releaseVersion = releaseVersion;
            this.releaseDate = releaseDate;
        }

        void write(IonWriter out, String fieldName) throws IOException {
            IonUtils.writeStruct(out, fieldName, () -> {
                IonUtils.writeString(out, "releaseVersion", this.releaseVersion);
                IonUtils.writeTimestamp(out, "releaseDate", this.releaseDate);
            });
        }

        String getReleaseVersion() {
            return this.releaseVersion;
        }

        Instant getReleaseDate() {
            return this.releaseDate;
        }
    }

    public static class AgentInfo {
        private static final String JAVA_AGENT = "CodeGuruProfiler-java";
        public static final String STANDALONE_INTEGRATION_MODE = "-standalone";
        public static final String CODE_INTEGRATION_MODE = "";
        private final String type;
        private final String version;

        public AgentInfo(String integrationMode) {
            this.type = JAVA_AGENT + integrationMode;
            this.version = "1.0.3";
        }

        public AgentInfo(String type, String version) {
            this.type = type;
            this.version = version;
        }

        void write(IonWriter out, String fieldName) throws IOException {
            IonUtils.writeStruct(out, fieldName, () -> {
                IonUtils.writeString(out, "type", this.type);
                IonUtils.writeString(out, "version", this.version);
            });
        }

        public String getType() {
            return this.type;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

