/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import software.amazon.codeguruprofilerjavaagent.profile.MemoryCounter;

public class StateEncodings {
    private static final Map<Integer, String> STATE_ENCODING;
    private static final int[] STATE_MAPPING;
    private static final String NATIVE_STATE_NAME = "NATIVE";
    private static final int NATIVE_ENCODING;
    private static final int MEMORY_COUNTER_START;

    private StateEncodings() {
    }

    public static Map<Integer, String> getEncodings() {
        return STATE_ENCODING;
    }

    public static int getStateEncoding(Thread.State threadState) {
        return STATE_MAPPING[threadState.ordinal()];
    }

    public static int getStateEncoding(MemoryCounter memoryCounter) {
        return memoryCounter.ordinal() + MEMORY_COUNTER_START;
    }

    public static int getNativeStateEncoding() {
        return NATIVE_ENCODING;
    }

    static {
        STATE_MAPPING = new int[Thread.State.values().length];
        Arrays.fill(STATE_MAPPING, -1);
        int encoding = 0;
        HashMap<Integer, String> stateEncoding = new HashMap<Integer, String>();
        stateEncoding.put(encoding, Thread.State.RUNNABLE.name());
        StateEncodings.STATE_MAPPING[Thread.State.RUNNABLE.ordinal()] = encoding++;
        stateEncoding.put(encoding, Thread.State.BLOCKED.name());
        StateEncodings.STATE_MAPPING[Thread.State.BLOCKED.ordinal()] = encoding++;
        stateEncoding.put(encoding, NATIVE_STATE_NAME);
        NATIVE_ENCODING = encoding++;
        stateEncoding.put(encoding, Thread.State.WAITING.name());
        StateEncodings.STATE_MAPPING[Thread.State.WAITING.ordinal()] = encoding++;
        stateEncoding.put(encoding, Thread.State.TIMED_WAITING.name());
        StateEncodings.STATE_MAPPING[Thread.State.TIMED_WAITING.ordinal()] = encoding++;
        MEMORY_COUNTER_START = encoding;
        stateEncoding.put(encoding, MemoryCounter.ALLOCATED_BYTES.name());
        stateEncoding.put(++encoding, MemoryCounter.ALLOCATION_COUNT.name());
        STATE_ENCODING = Collections.unmodifiableMap(stateEncoding);
    }
}

