/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerClient;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerClientBuilder;
import software.amazon.awssdk.services.codeguruprofiler.model.AgentConfiguration;
import software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.PostAgentProfileRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codeguruprofiler.model.ValidationException;
import software.amazon.codeguruprofilerjavaagent.AgentOrchestrator;
import software.amazon.codeguruprofilerjavaagent.ProfileReporter;
import software.amazon.codeguruprofilerjavaagent.profile.Profile;
import software.amazon.codeguruprofilerjavaagent.profile.ProfileIonSerializer;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;

class CodeGuruProfilerSDKClient
implements AgentOrchestrator,
ProfileReporter<Profile> {
    private static final Logger LOG = Logger.getLogger(CodeGuruProfilerSDKClient.class.getName());
    private static final int INTERVAL_ON_RESOURCE_NOT_FOUND = 300;
    private final String fleetInstanceId;
    private final CodeGuruProfilerClient client;
    private final String profilingGroupName;
    private final ProfileIonSerializer serializer;
    private final ErrorsMetadata errorsMetadata;

    CodeGuruProfilerSDKClient(String profilingGroupName, String fleetInstanceId, AwsCredentialsProvider awsCredentialsProvider, Region awsRegion, ClientOverrideConfiguration clientOverrideConfiguration, ErrorsMetadata errorsMetadata) {
        this(profilingGroupName, fleetInstanceId, (CodeGuruProfilerClient)((CodeGuruProfilerClientBuilder)((CodeGuruProfilerClientBuilder)((CodeGuruProfilerClientBuilder)((CodeGuruProfilerClientBuilder)CodeGuruProfilerClient.builder().credentialsProvider(awsCredentialsProvider)).region(awsRegion)).overrideConfiguration(clientOverrideConfiguration)).httpClientBuilder((SdkHttpClient.Builder)ApacheHttpClient.builder())).build(), errorsMetadata);
    }

    CodeGuruProfilerSDKClient(String profilingGroupName, String fleetInstanceId, CodeGuruProfilerClient client, ErrorsMetadata errorsMetadata) {
        this.profilingGroupName = profilingGroupName;
        this.fleetInstanceId = fleetInstanceId;
        this.client = client;
        this.serializer = new ProfileIonSerializer();
        this.errorsMetadata = errorsMetadata;
    }

    @Override
    public Optional<AgentConfiguration> configureAgent() {
        return this.configureAgent(null);
    }

    @Override
    public Optional<AgentConfiguration> configureAgent(Map<String, String> configureAgentMetadata) {
        try {
            ConfigureAgentResponse response;
            ConfigureAgentRequest.Builder configureAgentRequestBuilder = ConfigureAgentRequest.builder().profilingGroupName(this.profilingGroupName).fleetInstanceId(this.fleetInstanceId);
            if (configureAgentMetadata != null && !configureAgentMetadata.isEmpty()) {
                configureAgentRequestBuilder.metadataWithStrings(configureAgentMetadata);
            }
            if ((response = this.client.configureAgent((ConfigureAgentRequest)configureAgentRequestBuilder.build())) != null && response.configuration() != null) {
                return Optional.of(response.configuration());
            }
        }
        catch (ResourceNotFoundException e) {
            this.errorsMetadata.recordSdk(LOG, Level.INFO, "Profiling group not found. Will retry after 5 minutes.", null);
            return Optional.of(AgentConfiguration.builder().shouldProfile(Boolean.valueOf(false)).periodInSeconds(Integer.valueOf(300)).build());
        }
        catch (ValidationException e) {
            LOG.log(Level.INFO, "Validation exception received while configuring the agent. Profiling will be stopped");
            throw e;
        }
        catch (Exception e) {
            this.errorsMetadata.recordSdk(LOG, Level.INFO, "Exception while calling agent orchestration.", e);
        }
        return Optional.empty();
    }

    @Override
    public boolean report(Profile profile) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.serializer.serialize(profile, baos);
            baos.close();
            this.client.postAgentProfile((PostAgentProfileRequest)PostAgentProfileRequest.builder().profilingGroupName(this.profilingGroupName).agentProfile(SdkBytes.fromByteArray((byte[])baos.toByteArray())).contentType("application/octet-stream").build());
            return true;
        }
        catch (Exception e) {
            this.errorsMetadata.recordSdk(LOG, Level.INFO, "Exception while reporting profile.", e);
            return false;
        }
    }

    String getFleetInstanceId() {
        return this.fleetInstanceId;
    }
}

