/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.sdkclientcopy.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.CodeGuruProfilerAsyncClient;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ListProfileTimesRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ListProfileTimesResponse;

public class ListProfileTimesPublisher
implements SdkPublisher<ListProfileTimesResponse> {
    private final CodeGuruProfilerAsyncClient client;
    private final ListProfileTimesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProfileTimesPublisher(CodeGuruProfilerAsyncClient client, ListProfileTimesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProfileTimesPublisher(CodeGuruProfilerAsyncClient client, ListProfileTimesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProfileTimesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProfileTimesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListProfileTimesResponseFetcher
    implements AsyncPageFetcher<ListProfileTimesResponse> {
        private ListProfileTimesResponseFetcher() {
        }

        public boolean hasNextPage(ListProfileTimesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProfileTimesResponse> nextPage(ListProfileTimesResponse previousPage) {
            if (previousPage == null) {
                return ListProfileTimesPublisher.this.client.listProfileTimes(ListProfileTimesPublisher.this.firstRequest);
            }
            return ListProfileTimesPublisher.this.client.listProfileTimes((ListProfileTimesRequest)((Object)ListProfileTimesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

