/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.sdkclientcopy;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.CodeGuruProfilerClient;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.CodeGuruProfilerException;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.CodeGuruProfilerRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ConfigureAgentRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ConfigureAgentResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ConflictException;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.CreateProfilingGroupRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.CreateProfilingGroupResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.DeleteProfilingGroupRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.DeleteProfilingGroupResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.DescribeProfilingGroupRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.DescribeProfilingGroupResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.GetProfileRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.GetProfileResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.InternalServerException;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ListProfileTimesRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ListProfileTimesResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ListProfilingGroupsRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ListProfilingGroupsResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.PostAgentProfileRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.PostAgentProfileResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ResourceNotFoundException;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ServiceQuotaExceededException;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ThrottlingException;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.UpdateProfilingGroupRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.UpdateProfilingGroupResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ValidationException;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.paginators.ListProfileTimesIterable;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.paginators.ListProfilingGroupsIterable;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.ConfigureAgentRequestMarshaller;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.CreateProfilingGroupRequestMarshaller;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.DeleteProfilingGroupRequestMarshaller;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.DescribeProfilingGroupRequestMarshaller;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.GetProfileRequestMarshaller;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.ListProfileTimesRequestMarshaller;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.ListProfilingGroupsRequestMarshaller;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.PostAgentProfileRequestMarshaller;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.UpdateProfilingGroupRequestMarshaller;

@SdkInternalApi
final class DefaultCodeGuruProfilerClient
implements CodeGuruProfilerClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodeGuruProfilerClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "codeguru-profiler";
    }

    @Override
    public ConfigureAgentResponse configureAgent(ConfigureAgentRequest configureAgentRequest) throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConfigureAgentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ConfigureAgentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfigureAgent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)configureAgentRequest).withMarshaller((Marshaller)new ConfigureAgentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateProfilingGroupResponse createProfilingGroup(CreateProfilingGroupRequest createProfilingGroupRequest) throws ServiceQuotaExceededException, InternalServerException, ConflictException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateProfilingGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateProfilingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateProfilingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createProfilingGroupRequest).withMarshaller((Marshaller)new CreateProfilingGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteProfilingGroupResponse deleteProfilingGroup(DeleteProfilingGroupRequest deleteProfilingGroupRequest) throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteProfilingGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteProfilingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteProfilingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteProfilingGroupRequest).withMarshaller((Marshaller)new DeleteProfilingGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeProfilingGroupResponse describeProfilingGroup(DescribeProfilingGroupRequest describeProfilingGroupRequest) throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeProfilingGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeProfilingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeProfilingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeProfilingGroupRequest).withMarshaller((Marshaller)new DescribeProfilingGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetProfileResponse getProfile(GetProfileRequest getProfileRequest) throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getProfileRequest).withMarshaller((Marshaller)new GetProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListProfileTimesResponse listProfileTimes(ListProfileTimesRequest listProfileTimesRequest) throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProfileTimesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListProfileTimesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProfileTimes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listProfileTimesRequest).withMarshaller((Marshaller)new ListProfileTimesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListProfileTimesIterable listProfileTimesPaginator(ListProfileTimesRequest listProfileTimesRequest) throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return new ListProfileTimesIterable(this, this.applyPaginatorUserAgent(listProfileTimesRequest));
    }

    @Override
    public ListProfilingGroupsResponse listProfilingGroups(ListProfilingGroupsRequest listProfilingGroupsRequest) throws InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProfilingGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListProfilingGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProfilingGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listProfilingGroupsRequest).withMarshaller((Marshaller)new ListProfilingGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListProfilingGroupsIterable listProfilingGroupsPaginator(ListProfilingGroupsRequest listProfilingGroupsRequest) throws InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return new ListProfilingGroupsIterable(this, this.applyPaginatorUserAgent(listProfilingGroupsRequest));
    }

    @Override
    public PostAgentProfileResponse postAgentProfile(PostAgentProfileRequest postAgentProfileRequest) throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PostAgentProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PostAgentProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PostAgentProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)postAgentProfileRequest).withMarshaller((Marshaller)new PostAgentProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateProfilingGroupResponse updateProfilingGroup(UpdateProfilingGroupRequest updateProfilingGroupRequest) throws InternalServerException, ConflictException, ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateProfilingGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateProfilingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateProfilingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateProfilingGroupRequest).withMarshaller((Marshaller)new UpdateProfilingGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CodeGuruProfilerException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends CodeGuruProfilerRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.14.14").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CodeGuruProfilerRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

