/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.sdkclientcopy;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.CodeGuruProfilerAsyncClient;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.CodeGuruProfilerException;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.CodeGuruProfilerRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ConfigureAgentRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ConfigureAgentResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ConflictException;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.CreateProfilingGroupRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.CreateProfilingGroupResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.DeleteProfilingGroupRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.DeleteProfilingGroupResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.DescribeProfilingGroupRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.DescribeProfilingGroupResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.GetProfileRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.GetProfileResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.InternalServerException;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ListProfileTimesRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ListProfileTimesResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ListProfilingGroupsRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ListProfilingGroupsResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.PostAgentProfileRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.PostAgentProfileResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ResourceNotFoundException;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ServiceQuotaExceededException;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ThrottlingException;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.UpdateProfilingGroupRequest;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.UpdateProfilingGroupResponse;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.model.ValidationException;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.paginators.ListProfileTimesPublisher;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.paginators.ListProfilingGroupsPublisher;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.ConfigureAgentRequestMarshaller;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.CreateProfilingGroupRequestMarshaller;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.DeleteProfilingGroupRequestMarshaller;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.DescribeProfilingGroupRequestMarshaller;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.GetProfileRequestMarshaller;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.ListProfileTimesRequestMarshaller;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.ListProfilingGroupsRequestMarshaller;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.PostAgentProfileRequestMarshaller;
import software.amazon.codeguruprofilerjavaagent.sdkclientcopy.transform.UpdateProfilingGroupRequestMarshaller;

@SdkInternalApi
final class DefaultCodeGuruProfilerAsyncClient
implements CodeGuruProfilerAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCodeGuruProfilerAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodeGuruProfilerAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "codeguru-profiler";
    }

    @Override
    public CompletableFuture<ConfigureAgentResponse> configureAgent(ConfigureAgentRequest configureAgentRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConfigureAgentResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfigureAgent").withMarshaller((Marshaller)new ConfigureAgentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)configureAgentRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateProfilingGroupResponse> createProfilingGroup(CreateProfilingGroupRequest createProfilingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateProfilingGroupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateProfilingGroup").withMarshaller((Marshaller)new CreateProfilingGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createProfilingGroupRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteProfilingGroupResponse> deleteProfilingGroup(DeleteProfilingGroupRequest deleteProfilingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteProfilingGroupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteProfilingGroup").withMarshaller((Marshaller)new DeleteProfilingGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteProfilingGroupRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeProfilingGroupResponse> describeProfilingGroup(DescribeProfilingGroupRequest describeProfilingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeProfilingGroupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeProfilingGroup").withMarshaller((Marshaller)new DescribeProfilingGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeProfilingGroupRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetProfileResponse> getProfile(GetProfileRequest getProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(false).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetProfileResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetProfile").withMarshaller((Marshaller)new GetProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getProfileRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListProfileTimesResponse> listProfileTimes(ListProfileTimesRequest listProfileTimesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProfileTimesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProfileTimes").withMarshaller((Marshaller)new ListProfileTimesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listProfileTimesRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListProfileTimesPublisher listProfileTimesPaginator(ListProfileTimesRequest listProfileTimesRequest) {
        return new ListProfileTimesPublisher(this, this.applyPaginatorUserAgent(listProfileTimesRequest));
    }

    @Override
    public CompletableFuture<ListProfilingGroupsResponse> listProfilingGroups(ListProfilingGroupsRequest listProfilingGroupsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProfilingGroupsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProfilingGroups").withMarshaller((Marshaller)new ListProfilingGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listProfilingGroupsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListProfilingGroupsPublisher listProfilingGroupsPaginator(ListProfilingGroupsRequest listProfilingGroupsRequest) {
        return new ListProfilingGroupsPublisher(this, this.applyPaginatorUserAgent(listProfilingGroupsRequest));
    }

    @Override
    public CompletableFuture<PostAgentProfileResponse> postAgentProfile(PostAgentProfileRequest postAgentProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PostAgentProfileResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PostAgentProfile").withMarshaller((Marshaller)new PostAgentProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)postAgentProfileRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateProfilingGroupResponse> updateProfilingGroup(UpdateProfilingGroupRequest updateProfilingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateProfilingGroupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateProfilingGroup").withMarshaller((Marshaller)new UpdateProfilingGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateProfilingGroupRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CodeGuruProfilerException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build());
    }

    private <T extends CodeGuruProfilerRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.14.14").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CodeGuruProfilerRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}

